/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.impl;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonMappingException {
        if (serializerProvider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(object);
        }
        jsonGenerator.writeStartObject();
        jsonGenerator.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        if (serializerProvider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(object);
        }
        typeSerializer.writeTypePrefixForObject(object, jsonGenerator);
        typeSerializer.writeTypeSuffixForObject(object, jsonGenerator);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        jsonFormatVisitorWrapper.expectAnyFormat(javaType);
    }

    protected void failForEmpty(Object object) throws JsonMappingException {
        throw new JsonMappingException("No serializer found for class " + object.getClass().getName() + " and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS) )");
    }
}

