/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.std;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.MapperFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

@JacksonStdImpl
public class JsonValueSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
JsonFormatVisitable,
SchemaAware {
    protected final Method _accessorMethod;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final BeanProperty _property;
    protected final boolean _forceTypeInformation;

    public JsonValueSerializer(Method method, JsonSerializer<Object> jsonSerializer) {
        super(Object.class);
        this._accessorMethod = method;
        this._valueSerializer = jsonSerializer;
        this._property = null;
        this._forceTypeInformation = true;
    }

    public JsonValueSerializer(JsonValueSerializer jsonValueSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, boolean bl) {
        super(JsonValueSerializer._notNullClass(jsonValueSerializer.handledType()));
        this._accessorMethod = jsonValueSerializer._accessorMethod;
        this._valueSerializer = jsonSerializer;
        this._property = beanProperty;
        this._forceTypeInformation = bl;
    }

    private static final Class<Object> _notNullClass(Class<?> clazz) {
        return clazz == null ? Object.class : clazz;
    }

    public JsonValueSerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, boolean bl) {
        if (this._property == beanProperty && this._valueSerializer == jsonSerializer && bl == this._forceTypeInformation) {
            return this;
        }
        return new JsonValueSerializer(this, beanProperty, jsonSerializer, bl);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            if (serializerProvider.isEnabled(MapperFeature.USE_STATIC_TYPING) || Modifier.isFinal(this._accessorMethod.getReturnType().getModifiers())) {
                JavaType javaType = serializerProvider.constructType(this._accessorMethod.getGenericReturnType());
                jsonSerializer = serializerProvider.findTypedValueSerializer(javaType, false, this._property);
                boolean bl = this.isNaturalTypeWithStdHandling(javaType.getRawClass(), jsonSerializer);
                return this.withResolved(beanProperty, jsonSerializer, bl);
            }
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, beanProperty);
            return this.withResolved(beanProperty, jsonSerializer, this._forceTypeInformation);
        }
        return this;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        try {
            Object object2 = this._accessorMethod.invoke(object, new Object[0]);
            if (object2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                return;
            }
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                Class<?> clazz = object2.getClass();
                jsonSerializer = serializerProvider.findTypedValueSerializer(clazz, true, this._property);
            }
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw JsonMappingException.wrapWithPath(throwable, object, this._accessorMethod.getName() + "()");
        }
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        Object object2 = null;
        try {
            object2 = this._accessorMethod.invoke(object, new Object[0]);
            if (object2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                return;
            }
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = serializerProvider.findValueSerializer(object2.getClass(), this._property);
            } else if (this._forceTypeInformation) {
                typeSerializer.writeTypePrefixForScalar(object, jsonGenerator);
                jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
                typeSerializer.writeTypeSuffixForScalar(object, jsonGenerator);
                return;
            }
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, typeSerializer);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw JsonMappingException.wrapWithPath(throwable, object, this._accessorMethod.getName() + "()");
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        if (this._valueSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._valueSerializer)).getSchema(serializerProvider, null);
        }
        return JsonSchema.getDefaultSchemaNode();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            if (javaType == null) {
                if (this._property != null) {
                    javaType = this._property.getType();
                }
                if (javaType == null) {
                    javaType = jsonFormatVisitorWrapper.getProvider().constructType(this._accessorMethod.getReturnType());
                }
            }
            if ((jsonSerializer = jsonFormatVisitorWrapper.getProvider().findTypedValueSerializer(javaType, false, this._property)) == null) {
                jsonFormatVisitorWrapper.expectAnyFormat(javaType);
                return;
            }
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, null);
    }

    protected boolean isNaturalTypeWithStdHandling(Class<?> clazz, JsonSerializer<?> jsonSerializer) {
        if (clazz.isPrimitive() ? clazz != Integer.TYPE && clazz != Boolean.TYPE && clazz != Double.TYPE : clazz != String.class && clazz != Integer.class && clazz != Boolean.class && clazz != Double.class) {
            return false;
        }
        return this.isDefaultSerializer(jsonSerializer);
    }

    public String toString() {
        return "(@JsonValue serializer for method " + this._accessorMethod.getDeclaringClass() + "#" + this._accessorMethod.getName() + ")";
    }
}

