/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.collect;

import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import jersey.repackaged.com.google.common.base.Preconditions;
import jersey.repackaged.com.google.common.collect.EmptyImmutableSet;
import jersey.repackaged.com.google.common.collect.Hashing;
import jersey.repackaged.com.google.common.collect.ImmutableCollection;
import jersey.repackaged.com.google.common.collect.ImmutableEnumSet;
import jersey.repackaged.com.google.common.collect.ImmutableList;
import jersey.repackaged.com.google.common.collect.ImmutableSortedSet;
import jersey.repackaged.com.google.common.collect.ObjectArrays;
import jersey.repackaged.com.google.common.collect.RegularImmutableAsList;
import jersey.repackaged.com.google.common.collect.RegularImmutableSet;
import jersey.repackaged.com.google.common.collect.Sets;
import jersey.repackaged.com.google.common.collect.SingletonImmutableSet;
import jersey.repackaged.com.google.common.collect.UnmodifiableIterator;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private static final int CUTOFF = (int)Math.floor(7.516192768E8);

    public static <E> ImmutableSet<E> of() {
        return EmptyImmutableSet.INSTANCE;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element);
    }

    private static <E> ImmutableSet<E> construct(int n, Object ... elements) {
        switch (n) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object elem = elements[0];
                return ImmutableSet.of(elem);
            }
        }
        int tableSize = ImmutableSet.chooseTableSize(n);
        Object[] table = new Object[tableSize];
        int mask = tableSize - 1;
        int hashCode = 0;
        int uniques = 0;
        block4: for (int i = 0; i < n; ++i) {
            Object element = ObjectArrays.checkElementNotNull(elements[i], i);
            int hash = element.hashCode();
            int j = Hashing.smear(hash);
            while (true) {
                int index;
                Object value;
                if ((value = table[index = j & mask]) == null) {
                    elements[uniques++] = element;
                    table[index] = element;
                    hashCode += hash;
                    continue block4;
                }
                if (value.equals(element)) continue block4;
                ++j;
            }
        }
        Arrays.fill(elements, uniques, n, null);
        if (uniques == 1) {
            Object element = elements[0];
            return new SingletonImmutableSet<Object>(element, hashCode);
        }
        if (tableSize != ImmutableSet.chooseTableSize(uniques)) {
            return ImmutableSet.construct(uniques, elements);
        }
        Object[] uniqueElements = uniques < elements.length ? ObjectArrays.arraysCopyOf(elements, uniques) : elements;
        return new RegularImmutableSet(uniqueElements, hashCode, table, mask);
    }

    static int chooseTableSize(int setSize) {
        if (setSize < CUTOFF) {
            int tableSize = Integer.highestOneBit(setSize - 1) << 1;
            while ((double)tableSize * 0.7 < (double)setSize) {
                tableSize <<= 1;
            }
            return tableSize;
        }
        Preconditions.checkArgument(setSize < 0x40000000, "collection too large");
        return 0x40000000;
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> elements) {
        if (elements instanceof ImmutableSet && !(elements instanceof ImmutableSortedSet)) {
            ImmutableSet set = (ImmutableSet)elements;
            if (!set.isPartialView()) {
                return set;
            }
        } else if (elements instanceof EnumSet) {
            EnumSet enumSet = EnumSet.copyOf((EnumSet)elements);
            ImmutableSet result = ImmutableEnumSet.asImmutable(enumSet);
            return result;
        }
        return ImmutableSet.copyFromCollection(elements);
    }

    private static <E> ImmutableSet<E> copyFromCollection(Collection<? extends E> collection) {
        Object[] elements = collection.toArray();
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object onlyElement = elements[0];
                return ImmutableSet.of(onlyElement);
            }
        }
        return ImmutableSet.construct(elements.length, elements);
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    static abstract class ArrayImmutableSet<E>
    extends ImmutableSet<E> {
        final transient Object[] elements;

        ArrayImmutableSet(Object[] elements) {
            this.elements = elements;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return this.asList().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.asList().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.asList().toArray(array);
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            if (targets == this) {
                return true;
            }
            if (!(targets instanceof ArrayImmutableSet)) {
                return super.containsAll(targets);
            }
            if (targets.size() > this.size()) {
                return false;
            }
            for (Object target : ((ArrayImmutableSet)targets).elements) {
                if (this.contains(target)) continue;
                return false;
            }
            return true;
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        ImmutableList<E> createAsList() {
            return new RegularImmutableAsList(this, this.elements);
        }
    }
}

