/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.DockerConfig;
import com.spotify.docker.client.DockerCredentialHelper;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.messages.DockerCredentialHelperAuth;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(DockerConfigReader.class);
    private static final ObjectMapper MAPPER = ObjectMapperProvider.objectMapper();

    @Deprecated
    public RegistryConfigs fromConfig(Path configPath) throws IOException {
        return this.authForAllRegistries(configPath);
    }

    @Deprecated
    public RegistryAuth fromConfig(Path configPath, String serverAddress) throws IOException {
        return this.authForRegistry(configPath, serverAddress);
    }

    public RegistryAuth anyRegistryAuth() throws IOException {
        return this.anyRegistryAuth(this.defaultConfigPath());
    }

    @VisibleForTesting
    RegistryAuth anyRegistryAuth(Path configPath) throws IOException {
        ImmutableCollection registryAuths = this.authForAllRegistries(configPath).configs().values();
        return registryAuths.isEmpty() ? RegistryAuth.builder().build() : (RegistryAuth)registryAuths.iterator().next();
    }

    public RegistryConfigs authForAllRegistries(Path configPath) throws IOException {
        boolean hasCredsStore;
        Preconditions.checkNotNull((Object)configPath);
        DockerConfig config = (DockerConfig)MAPPER.readValue(configPath.toFile(), DockerConfig.class);
        if (config == null) {
            return RegistryConfigs.empty();
        }
        RegistryConfigs.Builder registryConfigsBuilder = RegistryConfigs.builder();
        ImmutableMap<String, String> credHelpers = config.credHelpers();
        boolean hasCredHelpers = credHelpers != null && !credHelpers.isEmpty();
        ImmutableMap<String, RegistryAuth> auths = config.auths();
        boolean hasAuths = auths != null && !auths.isEmpty();
        String credsStore = config.credsStore();
        boolean bl = hasCredsStore = credsStore != null;
        if (hasCredHelpers) {
            for (Map.Entry credHelpersEntry : credHelpers.entrySet()) {
                String registry = (String)credHelpersEntry.getKey();
                String aCredsStore = (String)credHelpersEntry.getValue();
                registryConfigsBuilder.addConfig(registry, this.authWithCredentialHelper(aCredsStore, registry));
            }
        }
        if (hasAuths) {
            RegistryAuth empty = RegistryAuth.builder().build();
            for (Map.Entry authEntry : auths.entrySet()) {
                String registry = (String)authEntry.getKey();
                RegistryAuth registryAuth = (RegistryAuth)authEntry.getValue();
                if (registryAuth == null || registryAuth.equals(empty)) {
                    if (!hasCredsStore) continue;
                    registryConfigsBuilder.addConfig(registry, this.authWithCredentialHelper(credsStore, registry));
                    continue;
                }
                registryConfigsBuilder.addConfig(registry, registryAuth.toBuilder().serverAddress(registry).build());
            }
        }
        if (!(hasAuths || hasCredHelpers || hasCredsStore)) {
            try {
                return (RegistryConfigs)MAPPER.readValue(configPath.toFile(), RegistryConfigs.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return registryConfigsBuilder.build();
    }

    public RegistryAuth authForRegistry(Path configPath, String registry) throws IOException {
        Preconditions.checkNotNull((Object)configPath);
        Preconditions.checkNotNull((Object)registry);
        DockerConfig config = (DockerConfig)MAPPER.readValue(configPath.toFile(), DockerConfig.class);
        if (config == null) {
            return RegistryAuth.builder().build();
        }
        RegistryAuth registryAuth = this.authForRegistry(config, registry);
        if (registryAuth != null) {
            return registryAuth;
        }
        try {
            URI serverAddressUri = new URI(registry);
            if (serverAddressUri.getScheme() == null) {
                for (String proto : Arrays.asList("https://", "http://")) {
                    RegistryAuth protoRegistryAuth = this.authForRegistry(config, proto + registry);
                    if (protoRegistryAuth == null) continue;
                    return protoRegistryAuth;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        throw new IllegalArgumentException("registry \"" + registry + "\" does not appear in config file at " + configPath);
    }

    private RegistryAuth authForRegistry(DockerConfig config, String registry) throws IOException {
        ImmutableMap<String, RegistryAuth> auths = config.auths();
        if (auths != null && auths.get(registry) != null) {
            return ((RegistryAuth)auths.get(registry)).toBuilder().serverAddress(registry).build();
        }
        String credsStore = this.getCredentialStore(config, registry);
        if (credsStore != null) {
            return this.authWithCredentialHelper(credsStore, registry);
        }
        return null;
    }

    public Path defaultConfigPath() {
        String home = System.getProperty("user.home");
        Path dockerConfig = Paths.get(home, ".docker", "config.json");
        Path dockerCfg = Paths.get(home, ".dockercfg");
        if (Files.exists(dockerConfig, new LinkOption[0])) {
            LOG.debug("Using configfile: {}", (Object)dockerConfig);
            return dockerConfig;
        }
        LOG.debug("Using configfile: {} ", (Object)dockerCfg);
        return dockerCfg;
    }

    private RegistryAuth authWithCredentialHelper(String credsStore, String registry) throws IOException {
        DockerCredentialHelperAuth dockerCredentialHelperAuth = DockerCredentialHelper.get(credsStore, registry);
        return dockerCredentialHelperAuth == null ? null : dockerCredentialHelperAuth.toRegistryAuth();
    }

    private String getCredentialStore(DockerConfig config, String registry) {
        Preconditions.checkNotNull((Object)config, (Object)"Docker config cannot be null");
        Preconditions.checkNotNull((Object)registry, (Object)"registry cannot be null");
        ImmutableMap<String, String> credHelpers = config.credHelpers();
        return credHelpers != null && credHelpers.containsKey(registry) ? (String)credHelpers.get(registry) : config.credsStore();
    }
}

