
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_CpuStats_CpuUsage extends CpuStats.CpuUsage {

  private final Long totalUsage;
  private final ImmutableList<Long> percpuUsage;
  private final Long usageInKernelmode;
  private final Long usageInUsermode;

  AutoValue_CpuStats_CpuUsage(
      Long totalUsage,
      ImmutableList<Long> percpuUsage,
      Long usageInKernelmode,
      Long usageInUsermode) {
    if (totalUsage == null) {
      throw new NullPointerException("Null totalUsage");
    }
    this.totalUsage = totalUsage;
    if (percpuUsage == null) {
      throw new NullPointerException("Null percpuUsage");
    }
    this.percpuUsage = percpuUsage;
    if (usageInKernelmode == null) {
      throw new NullPointerException("Null usageInKernelmode");
    }
    this.usageInKernelmode = usageInKernelmode;
    if (usageInUsermode == null) {
      throw new NullPointerException("Null usageInUsermode");
    }
    this.usageInUsermode = usageInUsermode;
  }

  @JsonProperty(value = "total_usage")
  @Override
  public Long totalUsage() {
    return totalUsage;
  }

  @JsonProperty(value = "percpu_usage")
  @Override
  public ImmutableList<Long> percpuUsage() {
    return percpuUsage;
  }

  @JsonProperty(value = "usage_in_kernelmode")
  @Override
  public Long usageInKernelmode() {
    return usageInKernelmode;
  }

  @JsonProperty(value = "usage_in_usermode")
  @Override
  public Long usageInUsermode() {
    return usageInUsermode;
  }

  @Override
  public String toString() {
    return "CpuUsage{"
        + "totalUsage=" + totalUsage + ", "
        + "percpuUsage=" + percpuUsage + ", "
        + "usageInKernelmode=" + usageInKernelmode + ", "
        + "usageInUsermode=" + usageInUsermode
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CpuStats.CpuUsage) {
      CpuStats.CpuUsage that = (CpuStats.CpuUsage) o;
      return (this.totalUsage.equals(that.totalUsage()))
           && (this.percpuUsage.equals(that.percpuUsage()))
           && (this.usageInKernelmode.equals(that.usageInKernelmode()))
           && (this.usageInUsermode.equals(that.usageInUsermode()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.totalUsage.hashCode();
    h *= 1000003;
    h ^= this.percpuUsage.hashCode();
    h *= 1000003;
    h ^= this.usageInKernelmode.hashCode();
    h *= 1000003;
    h ^= this.usageInUsermode.hashCode();
    return h;
  }

}
