/**
 * (c) 2002-2021 JADAPTIVE Limited. All Rights Reserved.
 *
 * This file is part of the Maverick Synergy Java SSH API.
 *
 * Maverick Synergy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Maverick Synergy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Maverick Synergy.  If not, see <https://www.gnu.org/licenses/>.
 */
/* HEADER */
package com.sshtools.common.files.vfs;

import java.io.IOException;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.FileUtils;
import com.sshtools.common.util.UnsignedInteger32;

public class VirtualMount extends AbstractMount {

	AbstractFileFactory<? extends AbstractFile> actualFileFactory;
	VirtualFileFactory virtualFileFactory;
	boolean cached;
	boolean createMountFolder;
	boolean readOnly;
	long lastModified = 0;
	VirtualMountTemplate mountTemplate;
	
	VirtualMount(VirtualMountTemplate mountTemplate, 
			VirtualFileFactory virtualFileFactory,
			AbstractFileFactory<?> actualFileFactory,
			boolean isDefault,
			boolean isImaginary, 
			boolean createMountFolder,
			long lastModified)
				throws IOException, PermissionDeniedException {
		super(mountTemplate.getMount(), 
				mountTemplate.getRoot(),
				isDefault, isImaginary);

		this.mountTemplate = mountTemplate;
		this.actualFileFactory = actualFileFactory;
		this.virtualFileFactory = virtualFileFactory;
		this.createMountFolder = createMountFolder;
		this.lastModified = lastModified;
		if (!isImaginary()) {
			AbstractFile f = actualFileFactory.getFile(path);
			this.path = f.getAbsolutePath();
		}

	}

	public VirtualMount(VirtualMountTemplate mountTemplate, 
			VirtualFileFactory virtualFileFactory,
			AbstractFileFactory<?> actualFileFactory,
			boolean createMountFolder, long lastModified) throws IOException,
			PermissionDeniedException {
		this(mountTemplate, virtualFileFactory, actualFileFactory, false,
				false, createMountFolder, lastModified);
	}

	public VirtualMountTemplate getTemplate() {
		return mountTemplate;
	}
	
	public AbstractFileFactory<? extends AbstractFile> getActualFileFactory() {
		return actualFileFactory;
	}

	public String getResolvePath(String path) {
		
		String thisMount = FileUtils.addTrailingSlash(mount);
		String thisPath = FileUtils.addTrailingSlash(path);
		if (thisPath.length() >= thisMount.length()) {
			return FileUtils.addTrailingSlash(this.path)
					+ thisPath.substring(thisMount.length());
		} else {
			return this.path;
		}

	}

	public boolean isCached() {
		return cached;
	}

	public void setCached(boolean cached) {
		this.cached = cached;
	}

	public AbstractFileFactory<VirtualFile> getVirtualFileFactory() {
		return virtualFileFactory;
	}

	public boolean isCreateMountFolder() {
		return createMountFolder;
	}

	public boolean isParentOf(VirtualMount o2) {
		return o2.getMount().startsWith(getMount());
	}

	public boolean isChildOf(VirtualMount o2) {
		return getMount().startsWith(o2.getMount());
	}

	public long lastModified() {
		return lastModified;
	}
	
	public void setLastModified(long lastModified) {
		this.lastModified = lastModified;
	}

	public boolean isReadOnly() {
		return readOnly;
	}
	
	public void setReadOnly(boolean readOnly) {
		this.readOnly = readOnly;
	}

	public UnsignedInteger32 defaultPermissions() {
		return isReadOnly() ? new UnsignedInteger32(0500) : new UnsignedInteger32(0700);
	}
}
