/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.AbstractDiagramExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.PlantUMLDiagram;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ColorScheme;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ModelView;
import com.structurizr.view.Shape;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;

public abstract class AbstractPlantUMLExporter
extends AbstractDiagramExporter {
    protected static final int DEFAULT_FONT_SIZE = 24;
    public static final String PLANTUML_TITLE_PROPERTY = "plantuml.title";
    public static final String PLANTUML_INCLUDES_PROPERTY = "plantuml.includes";
    public static final String PLANTUML_ANIMATION_PROPERTY = "plantuml.animation";
    public static final String PLANTUML_SEQUENCE_DIAGRAM_PROPERTY = "plantuml.sequenceDiagram";
    public static final String DIAGRAM_TITLE_TAG = "Diagram:Title";
    public static final String DIAGRAM_DESCRIPTION_TAG = "Diagram:Description";
    private final Map<String, String> skinParams = new LinkedHashMap<String, String>();

    protected Map<String, String> getSkinParams() {
        return this.skinParams;
    }

    public void addSkinParam(String name, String value) {
        this.skinParams.put(name, value);
    }

    public void clearSkinParams() {
        this.skinParams.clear();
    }

    public AbstractPlantUMLExporter() {
        this(ColorScheme.Light);
    }

    public AbstractPlantUMLExporter(ColorScheme colorScheme) {
        super(colorScheme);
    }

    String plantUMLShapeOf(ModelView view, Element element) {
        Shape shape = this.findElementStyle(view, element).getShape();
        return this.plantUMLShapeOf(shape);
    }

    String plantUMLShapeOf(Shape shape) {
        switch (shape) {
            case Person: 
            case Robot: {
                return "person";
            }
            case Component: {
                return "component";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "folder";
            }
            case Ellipse: 
            case Circle: {
                return "storage";
            }
            case Hexagon: {
                return "hexagon";
            }
            case Pipe: {
                return "queue";
            }
        }
        return "rectangle";
    }

    String plantumlSequenceType(ModelView view, Element element) {
        Shape shape = this.findElementStyle(view, element).getShape();
        switch (shape) {
            case Box: {
                return "participant";
            }
            case Person: {
                return "actor";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "collections";
            }
            case Ellipse: 
            case Circle: {
                return "entity";
            }
        }
        return "participant";
    }

    String idOf(ModelItem modelItem) {
        if (modelItem instanceof Element) {
            Element element = (Element)modelItem;
            if (element.getParent() == null) {
                if (element instanceof DeploymentNode) {
                    DeploymentNode dn = (DeploymentNode)element;
                    return this.filter(dn.getEnvironment()) + "." + this.id(dn);
                }
                return this.id((ModelItem)element);
            }
            return this.idOf((ModelItem)element.getParent()) + "." + this.id(modelItem);
        }
        return this.id(modelItem);
    }

    private String id(ModelItem modelItem) {
        if (modelItem instanceof Person) {
            return this.id((Person)modelItem);
        }
        if (modelItem instanceof SoftwareSystem) {
            return this.id((SoftwareSystem)modelItem);
        }
        if (modelItem instanceof Container) {
            return this.id((Container)modelItem);
        }
        if (modelItem instanceof Component) {
            return this.id((Component)modelItem);
        }
        if (modelItem instanceof DeploymentNode) {
            return this.id((DeploymentNode)modelItem);
        }
        if (modelItem instanceof InfrastructureNode) {
            return this.id((InfrastructureNode)modelItem);
        }
        if (modelItem instanceof SoftwareSystemInstance) {
            return this.id((SoftwareSystemInstance)modelItem);
        }
        if (modelItem instanceof ContainerInstance) {
            return this.id((ContainerInstance)modelItem);
        }
        return modelItem.getId();
    }

    private String id(Person person) {
        return this.filter(person.getName());
    }

    private String id(SoftwareSystem softwareSystem) {
        return this.filter(softwareSystem.getName());
    }

    private String id(Container container) {
        return this.filter(container.getName());
    }

    private String id(Component component) {
        return this.filter(component.getName());
    }

    private String id(DeploymentNode deploymentNode) {
        return this.filter(deploymentNode.getName());
    }

    private String id(InfrastructureNode infrastructureNode) {
        return this.filter(infrastructureNode.getName());
    }

    private String id(SoftwareSystemInstance softwareSystemInstance) {
        return this.filter(softwareSystemInstance.getName()) + "_" + softwareSystemInstance.getInstanceId();
    }

    private String id(ContainerInstance containerInstance) {
        return this.filter(containerInstance.getName()) + "_" + containerInstance.getInstanceId();
    }

    private String filter(String s) {
        return s.replaceAll("(?U)\\W", "");
    }

    protected boolean includeTitle(ModelView view) {
        return "true".equals(this.getViewOrViewSetProperty(view, PLANTUML_TITLE_PROPERTY, "true"));
    }

    @Override
    protected boolean isAnimationSupported(ModelView view) {
        return "true".equalsIgnoreCase(this.getViewOrViewSetProperty(view, PLANTUML_ANIMATION_PROPERTY, "false"));
    }

    @Override
    protected void writeHeader(ModelView view, IndentingWriter writer) {
        writer.writeLine("@startuml");
        if (this.includeTitle(view)) {
            String description;
            ElementStyle titleStyle = this.findElementStyle(view, DIAGRAM_TITLE_TAG);
            ElementStyle descriptionStyle = this.findElementStyle(view, DIAGRAM_DESCRIPTION_TAG);
            String title = view.getTitle();
            if (StringUtils.isNullOrEmpty((String)title)) {
                title = view.getName();
            }
            if (StringUtils.isNullOrEmpty((String)(description = view.getDescription()))) {
                writer.writeLine(String.format("title <size:%s>%s</size>", titleStyle != null ? titleStyle.getFontSize() : 24, title));
            } else {
                writer.writeLine(String.format("title <size:%s>%s</size>\\n<size:%s>%s</size>", titleStyle != null ? titleStyle.getFontSize() : 24, title, descriptionStyle != null ? descriptionStyle.getFontSize() : 24, description));
            }
        }
        writer.writeLine();
        writer.writeLine("set separator none");
    }

    protected void writeSkinParams(IndentingWriter writer) {
        if (!this.skinParams.isEmpty()) {
            writer.writeLine();
            writer.writeLine("skinparam {");
            writer.indent();
            for (String name : this.skinParams.keySet()) {
                writer.writeLine(String.format("%s %s", name, this.skinParams.get(name)));
            }
            writer.outdent();
            writer.writeLine("}");
        }
        writer.writeLine();
    }

    protected void writeIncludes(ModelView view, IndentingWriter writer) {
        String commaSeparatedIncludes = this.getViewOrViewSetProperty(view, PLANTUML_INCLUDES_PROPERTY, "");
        if (!StringUtils.isNullOrEmpty((String)commaSeparatedIncludes)) {
            String[] includes;
            for (String include : includes = commaSeparatedIncludes.split(",")) {
                if (StringUtils.isNullOrEmpty((String)include)) continue;
                include = include.trim();
                writer.writeLine("!include " + include);
            }
            writer.writeLine();
        }
    }

    @Override
    protected void writeFooter(ModelView view, IndentingWriter writer) {
        writer.writeLine("@enduml");
    }

    @Override
    protected Diagram createDiagram(ModelView view, String definition) {
        return new PlantUMLDiagram(view, definition);
    }

    protected boolean isSupportedIcon(String icon) {
        return !StringUtils.isNullOrEmpty((String)icon) && icon.startsWith("http");
    }

    protected double calculateIconScale(String iconUrl, int maxIconSize) {
        double scale = 0.5;
        try {
            URL url = new URL(iconUrl);
            BufferedImage bi = ImageIO.read(url);
            int width = bi.getWidth();
            int height = bi.getHeight();
            scale = (double)maxIconSize / (double)Math.max(width, height);
        }
        catch (UnsatisfiedLinkError | UnsupportedOperationException | IIOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scale;
    }
}

