/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.PlantUMLStyle;
import com.structurizr.view.Border;
import java.util.Base64;

class PlantUMLDeploymentNodeStyle
extends PlantUMLStyle {
    private final String background;
    private final String color;
    private final String stroke;
    private final int strokeWidth;
    private final String lineStyle;
    private final int fontSize;
    private final String icon;
    private final boolean shadow;
    private Integer width;

    PlantUMLDeploymentNodeStyle(String name, String background, String color, String stroke, int strokeWidth, Border border, int fontSize, String icon, boolean shadow) {
        super(name);
        this.background = background;
        this.color = color;
        this.stroke = stroke;
        this.strokeWidth = strokeWidth;
        switch (border) {
            case Dotted: {
                this.lineStyle = strokeWidth + "-" + strokeWidth;
                break;
            }
            case Dashed: {
                this.lineStyle = strokeWidth * 5 + "-" + strokeWidth * 5;
                break;
            }
            default: {
                this.lineStyle = "0";
            }
        }
        this.fontSize = fontSize;
        this.icon = icon;
        this.shadow = shadow;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    String getClassSelector() {
        return "DeploymentNode-" + Base64.getEncoder().encodeToString(this.name.getBytes());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlantUMLDeploymentNodeStyle that = (PlantUMLDeploymentNodeStyle)o;
        return this.getClassSelector().equals(that.getClassSelector());
    }

    public String toString() {
        IndentingWriter writer = new IndentingWriter();
        writer.indent();
        writer.writeLine(String.format("// %s", this.name));
        writer.writeLine(String.format(".%s {", this.getClassSelector()));
        writer.indent();
        writer.writeLine(String.format("BackgroundColor: %s;", this.background));
        writer.writeLine(String.format("LineColor: %s;", this.stroke));
        writer.writeLine(String.format("LineStyle: %s;", this.lineStyle));
        writer.writeLine(String.format("LineThickness: %s;", this.strokeWidth));
        writer.writeLine(String.format("FontColor: %s;", this.color));
        writer.writeLine(String.format("FontSize: %s;", this.fontSize));
        writer.writeLine("HorizontalAlignment: center;");
        writer.writeLine(String.format("Shadowing: %s;", this.shadow ? 10 : 0));
        if (this.width != null) {
            writer.writeLine(String.format("MaximumWidth: %s;", this.width));
        }
        writer.outdent();
        writer.writeLine("}");
        writer.outdent();
        writer.writeLine();
        return writer.toString();
    }
}

