/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.maven;

import com.sun.istack.maven.ArtifactItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class MetainfServicesCompilerMojo
extends AbstractMojo {
    private List<ArtifactItem> artifactItems;
    private List<String> providers;
    private File destDir;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected List remoteRepositories;
    protected ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"About to compile META-INF/services files");
        this.getLog().info((CharSequence)("Artifact Items = " + this.artifactItems));
        this.getLog().info((CharSequence)("SPIs = " + this.providers));
        this.getLog().info((CharSequence)("dest dir = " + this.destDir));
        File msDir = new File(this.destDir, "META-INF/services");
        msDir.mkdirs();
        for (String spi : this.providers) {
            PrintWriter registryWriter = null;
            try {
                File spiRegistry = new File(msDir, spi);
                if (spiRegistry.exists()) {
                    spiRegistry.delete();
                }
                spiRegistry.createNewFile();
                registryWriter = new PrintWriter(spiRegistry);
                try {
                    for (ArtifactItem ai : this.artifactItems) {
                        Artifact artifact = this.artifactFactory.createExtensionArtifact(ai.getGroupId(), ai.getArtifactId(), VersionRange.createFromVersion((String)ai.getVersion()));
                        this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                        ZipFile zipFile = new ZipFile(artifact.getFile());
                        ZipEntry servicesEntry = zipFile.getEntry("META-INF/services/" + spi);
                        if (servicesEntry == null) continue;
                        InputStream inputStream = zipFile.getInputStream(servicesEntry);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        while (reader.ready()) {
                            registryWriter.println(reader.readLine());
                        }
                    }
                }
                catch (ArtifactResolutionException ex) {
                    throw new MojoExecutionException("Can not resolve artifact!", (Exception)((Object)ex));
                }
                catch (ArtifactNotFoundException ex) {
                    Logger.getLogger(MetainfServicesCompilerMojo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can not create spi registry file!", (Exception)ex);
            }
            finally {
                registryWriter.close();
            }
        }
    }
}

