/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import javax.security.sasl.SaslClient;

final class SASLHelper {
    private final Control[] controls;
    private final int messageID;
    private final LDAPConnection connection;
    private final long responseTimeoutMillis;
    private final SASLBindRequest bindRequest;
    private final SaslClient saslClient;
    private final String mechanism;

    SASLHelper(SASLBindRequest bindRequest, LDAPConnection connection, String mechanism, SaslClient saslClient, Control[] controls, long responseTimeoutMillis) {
        this.bindRequest = bindRequest;
        this.connection = connection;
        this.mechanism = mechanism;
        this.saslClient = saslClient;
        this.controls = controls;
        this.responseTimeoutMillis = responseTimeoutMillis;
        this.messageID = -1;
    }

    BindResult processSASLBind() throws LDAPException {
        BindResult bindResult;
        byte[] serverCredBytes;
        BindResult bindResult2;
        ASN1OctetString saslCredentials;
        byte[] credBytes;
        block14: {
            credBytes = null;
            try {
                if (this.saslClient.hasInitialResponse()) {
                    credBytes = this.saslClient.evaluateChallenge(new byte[0]);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_INITIAL_REQUEST.get(this.mechanism, StaticUtils.getExceptionMessage(e)), e);
            }
            saslCredentials = credBytes == null || credBytes.length == 0 ? null : new ASN1OctetString(credBytes);
            bindResult2 = this.bindRequest.sendBindRequest(this.connection, "", saslCredentials, this.controls, this.responseTimeoutMillis);
            if (bindResult2.getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) break block14;
            BindResult bindResult3 = bindResult2;
            Object var7_7 = null;
            try {
                this.saslClient.dispose();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            return bindResult3;
        }
        try {
            serverCredBytes = bindResult2.getServerSASLCredentials().getValue();
            while (true) {
                try {
                    credBytes = this.saslClient.evaluateChallenge(serverCredBytes);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_SUBSEQUENT_REQUEST.get(this.mechanism, StaticUtils.getExceptionMessage(e)), e);
                }
                saslCredentials = credBytes == null || credBytes.length == 0 ? null : new ASN1OctetString(credBytes);
                bindResult2 = this.bindRequest.sendBindRequest(this.connection, "", saslCredentials, this.controls, this.responseTimeoutMillis);
                if (bindResult2.getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) break block16;
                bindResult = bindResult2;
                Object var7_8 = null;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                this.saslClient.dispose();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            throw throwable;
        }
        {
            block16: {
                try {
                    this.saslClient.dispose();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                return bindResult;
            }
            serverCredBytes = bindResult2.getServerSASLCredentials().getValue();
            continue;
        }
    }

    int getMessageID() {
        return this.messageID;
    }
}

