/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFDeleteChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = 486284031156138191L;

    public LDIFDeleteChangeRecord(String dn) {
        super(dn);
    }

    public LDIFDeleteChangeRecord(DeleteRequest deleteRequest) {
        super(deleteRequest.getDN());
    }

    public DeleteRequest toDeleteRequest() {
        return new DeleteRequest(this.getDN());
    }

    public ChangeType getChangeType() {
        return ChangeType.DELETE;
    }

    public LDAPResult processChange(LDAPInterface connection) throws LDAPException {
        return connection.delete(this.toDeleteRequest());
    }

    public String[] toLDIF(int wrapColumn) {
        if (wrapColumn > 0) {
            List<String> ldifLines = Arrays.asList(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())), "changetype: delete");
            ldifLines = LDIFWriter.wrapLines(wrapColumn, ldifLines);
            String[] lineArray = new String[ldifLines.size()];
            return ldifLines.toArray(lineArray);
        }
        return new String[]{LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())), "changetype: delete"};
    }

    public void toLDIF(ByteStringBuffer buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("delete"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
    }

    public void toLDIFString(StringBuilder buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("delete"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
    }

    public int hashCode() {
        try {
            return this.getParsedDN().hashCode();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return StaticUtils.toLowerCase(this.getDN()).hashCode();
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LDIFDeleteChangeRecord)) {
            return false;
        }
        LDIFDeleteChangeRecord r = (LDIFDeleteChangeRecord)o;
        try {
            return this.getParsedDN().equals(r.getParsedDN());
        }
        catch (Exception e) {
            Debug.debugException(e);
            return StaticUtils.toLowerCase(this.getDN()).equals(StaticUtils.toLowerCase(r.getDN()));
        }
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDIFDeleteChangeRecord(dn='");
        buffer.append(this.getDN());
        buffer.append("')");
    }
}

