/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.regex.RegExpTree;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Set;

class CheckRegExp
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType REGEXP_REFERENCE = DiagnosticType.warning("JSC_REGEXP_REFERENCE", "References to the global RegExp object prevents optimization of regular expressions.");
    static final DiagnosticType MALFORMED_REGEXP = DiagnosticType.warning("JSC_MALFORMED_REGEXP", "Malformed Regular Expression: {0}");
    private static final Set<String> REGEXP_PROPERTY_BLACKLIST = ImmutableSet.of((Object)"$1", (Object)"$2", (Object)"$3", (Object)"$4", (Object)"$5", (Object)"$6", (Object[])new String[]{"$7", "$8", "$9", "$_", "$input", "input", "lastMatch", "lastParen", "leftContext", "rightContext", "global", "ignoreCase", "lastIndex", "multiline", "source"});
    private final AbstractCompiler compiler;
    private boolean globalRegExpPropertiesUsed = false;

    public boolean isGlobalRegExpPropertiesUsed() {
        return this.globalRegExpPropertiesUsed;
    }

    public CheckRegExp(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (NodeUtil.isReferenceName(n)) {
            String name = n.getString();
            if (name.equals("RegExp") && t.getScope().getVar(name) == null) {
                boolean first;
                int parentType = parent.getType();
                boolean bl = first = n == parent.getFirstChild();
                if (!(parentType == 30 && first || parentType == 37 && first || parentType == 52 && !first || parentType == 12 || parentType == 13 || parentType == 45 || parentType == 46 || parentType == 111 || parentType == 33 && first && !REGEXP_PROPERTY_BLACKLIST.contains(parent.getLastChild().getString()))) {
                    t.report(n, REGEXP_REFERENCE, new String[0]);
                    this.globalRegExpPropertiesUsed = true;
                }
            }
        } else if (n.isRegExp()) {
            String pattern = n.getFirstChild().getString();
            String flags = n.getChildCount() == 2 ? n.getLastChild().getString() : "";
            try {
                RegExpTree.parseRegExp(pattern, flags);
            }
            catch (IllegalArgumentException ex) {
                t.report(n, MALFORMED_REGEXP, ex.getMessage());
            }
            catch (IndexOutOfBoundsException ex) {
                t.report(n, MALFORMED_REGEXP, ex.getMessage());
            }
        }
    }
}

