/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.List;

final class ClosureOptimizePrimitives
implements CompilerPass {
    private final AbstractCompiler compiler;

    ClosureOptimizePrimitives(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        FindObjectCreateCalls pass = new FindObjectCreateCalls();
        NodeTraversal.traverse(this.compiler, root, pass);
        this.processObjectCreateCalls(pass.callNodes);
    }

    private void processObjectCreateCalls(List<Node> callNodes) {
        for (Node callNode : callNodes) {
            Node curParam = callNode.getFirstChild().getNext();
            if (!this.canOptimizeObjectCreate(curParam)) continue;
            Node objNode = IR.objectlit(new Node[0]).srcref(callNode);
            while (curParam != null) {
                Node keyNode = curParam;
                Node valueNode = curParam.getNext();
                curParam = valueNode.getNext();
                callNode.removeChild(keyNode);
                callNode.removeChild(valueNode);
                if (!keyNode.isString()) {
                    keyNode = IR.string(NodeUtil.getStringValue(keyNode)).srcref(keyNode);
                }
                keyNode.setType(154);
                keyNode.setQuotedString();
                objNode.addChildToBack(IR.propdef(keyNode, valueNode));
            }
            callNode.getParent().replaceChild(callNode, objNode);
            this.compiler.reportCodeChange();
        }
    }

    private boolean canOptimizeObjectCreate(Node firstParam) {
        Node curParam = firstParam;
        while (curParam != null) {
            if (!curParam.isString() && !curParam.isNumber()) {
                return false;
            }
            if ((curParam = curParam.getNext()) == null) {
                return false;
            }
            curParam = curParam.getNext();
        }
        return true;
    }

    private class FindObjectCreateCalls
    extends NodeTraversal.AbstractPostOrderCallback {
        List<Node> callNodes = Lists.newArrayList();

        private FindObjectCreateCalls() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            String fnName;
            if (n.isCall() && ("goog$object$create".equals(fnName = n.getFirstChild().getQualifiedName()) || "goog.object.create".equals(fnName))) {
                this.callNodes.add(n);
            }
        }
    }
}

