/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.CheckLevel;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticGroup;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.WarningsGuard;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ComposeWarningsGuard
extends WarningsGuard {
    private static final long serialVersionUID = 1L;
    private final Map<WarningsGuard, Integer> orderOfAddition = Maps.newHashMap();
    private int numberOfAdds = 0;
    private final Comparator<WarningsGuard> guardComparator = new GuardComparator(this.orderOfAddition);
    private boolean demoteErrors = false;
    private final TreeSet<WarningsGuard> guards = new TreeSet<WarningsGuard>(this.guardComparator);

    public ComposeWarningsGuard(List<WarningsGuard> guards) {
        this.addGuards(guards);
    }

    public ComposeWarningsGuard(WarningsGuard ... guards) {
        this(Lists.newArrayList((Object[])guards));
    }

    void addGuard(WarningsGuard guard) {
        if (guard instanceof ComposeWarningsGuard) {
            ComposeWarningsGuard composeGuard = (ComposeWarningsGuard)guard;
            if (composeGuard.demoteErrors) {
                this.demoteErrors = composeGuard.demoteErrors;
            }
            this.addGuards(Lists.newArrayList(composeGuard.guards.descendingSet()));
        } else {
            ++this.numberOfAdds;
            this.orderOfAddition.put(guard, this.numberOfAdds);
            this.guards.remove(guard);
            this.guards.add(guard);
        }
    }

    private void addGuards(Iterable<WarningsGuard> guards) {
        for (WarningsGuard guard : guards) {
            this.addGuard(guard);
        }
    }

    @Override
    public CheckLevel level(JSError error) {
        for (WarningsGuard guard : this.guards) {
            CheckLevel newLevel = guard.level(error);
            if (newLevel == null) continue;
            if (this.demoteErrors && newLevel == CheckLevel.ERROR) {
                return CheckLevel.WARNING;
            }
            return newLevel;
        }
        return null;
    }

    @Override
    public boolean disables(DiagnosticGroup group) {
        block0: for (DiagnosticType type : group.getTypes()) {
            DiagnosticGroup singleton = DiagnosticGroup.forType(type);
            for (WarningsGuard guard : this.guards) {
                if (guard.disables(singleton)) continue block0;
                if (!guard.enables(singleton)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean enables(DiagnosticGroup group) {
        for (WarningsGuard guard : this.guards) {
            if (guard.enables(group)) {
                return true;
            }
            if (!guard.disables(group)) continue;
            return false;
        }
        return false;
    }

    List<WarningsGuard> getGuards() {
        return Collections.unmodifiableList(Lists.newArrayList(this.guards));
    }

    ComposeWarningsGuard makeEmergencyFailSafeGuard() {
        ComposeWarningsGuard safeGuard = new ComposeWarningsGuard(new WarningsGuard[0]);
        safeGuard.demoteErrors = true;
        for (WarningsGuard guard : this.guards.descendingSet()) {
            safeGuard.addGuard(guard);
        }
        return safeGuard;
    }

    public String toString() {
        return Joiner.on((String)", ").join(this.guards);
    }

    private static class GuardComparator
    implements Comparator<WarningsGuard>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<WarningsGuard, Integer> orderOfAddition;

        private GuardComparator(Map<WarningsGuard, Integer> orderOfAddition) {
            this.orderOfAddition = orderOfAddition;
        }

        @Override
        public int compare(WarningsGuard a, WarningsGuard b) {
            int priorityDiff = a.getPriority() - b.getPriority();
            if (priorityDiff != 0) {
                return priorityDiff;
            }
            return this.orderOfAddition.get(b) - this.orderOfAddition.get(a);
        }
    }
}

