/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.JSModule;
import com.google.gwt.thirdparty.javascript.jscomp.JSModuleGraph;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

class CrossModuleMethodMotion
implements CompilerPass {
    static final DiagnosticType NULL_COMMON_MODULE_ERROR = DiagnosticType.error("JSC_INTERNAL_ERROR_MODULE_DEPEND", "null deepest common module");
    private final AbstractCompiler compiler;
    private final IdGenerator idGenerator;
    private final AnalyzePrototypeProperties analyzer;
    private final JSModuleGraph moduleGraph;
    static final String STUB_METHOD_NAME = "JSCompiler_stubMethod";
    static final String UNSTUB_METHOD_NAME = "JSCompiler_unstubMethod";
    static final String STUB_DECLARATIONS = "var JSCompiler_stubMap = [];function JSCompiler_stubMethod(JSCompiler_stubMethod_id) {  return function() {    return JSCompiler_stubMap[JSCompiler_stubMethod_id].apply(        this, arguments);  };}function JSCompiler_unstubMethod(    JSCompiler_unstubMethod_id, JSCompiler_unstubMethod_body) {  return JSCompiler_stubMap[JSCompiler_unstubMethod_id] =       JSCompiler_unstubMethod_body;}";

    CrossModuleMethodMotion(AbstractCompiler compiler, IdGenerator idGenerator, boolean canModifyExterns) {
        this.compiler = compiler;
        this.idGenerator = idGenerator;
        this.moduleGraph = compiler.getModuleGraph();
        this.analyzer = new AnalyzePrototypeProperties(compiler, this.moduleGraph, canModifyExterns, false);
    }

    @Override
    public void process(Node externRoot, Node root) {
        if (this.moduleGraph != null && this.moduleGraph.getModuleCount() > 1) {
            this.analyzer.process(externRoot, root);
            this.moveMethods(this.analyzer.getAllNameInfo());
        }
    }

    private void moveMethods(Collection<AnalyzePrototypeProperties.NameInfo> allNameInfo) {
        boolean hasStubDeclaration = this.idGenerator.hasGeneratedAnyIds();
        for (AnalyzePrototypeProperties.NameInfo nameInfo : allNameInfo) {
            if (!nameInfo.isReferenced() || nameInfo.readsClosureVariables()) continue;
            JSModule deepestCommonModuleRef = nameInfo.getDeepestCommonModuleRef();
            if (deepestCommonModuleRef == null) {
                this.compiler.report(JSError.make(NULL_COMMON_MODULE_ERROR, new String[0]));
                continue;
            }
            Iterator<AnalyzePrototypeProperties.Symbol> declarations = nameInfo.getDeclarations().descendingIterator();
            while (declarations.hasNext()) {
                Node value;
                AnalyzePrototypeProperties.Property prop;
                AnalyzePrototypeProperties.Symbol symbol2 = declarations.next();
                if (!(symbol2 instanceof AnalyzePrototypeProperties.Property) || (prop = (AnalyzePrototypeProperties.Property)symbol2).getRootVar() == null || !prop.getRootVar().isGlobal() || !(value = prop.getValue()).isFunction() || value.getParent().isGetterDef() || value.getParent().isSetterDef() || !this.moduleGraph.dependsOn(deepestCommonModuleRef, prop.getModule()) || CrossModuleMethodMotion.hasUnmovableRedeclaration(nameInfo, prop)) continue;
                Node valueParent = value.getParent();
                Node proto = prop.getPrototype();
                int stubId = this.idGenerator.newId();
                Node stubCall = IR.call(IR.name(STUB_METHOD_NAME), IR.number(stubId)).copyInformationFromForTree(value);
                stubCall.putBooleanProp(50, true);
                valueParent.replaceChild(value, stubCall);
                Node unstubParent = this.compiler.getNodeForCodeInsertion(deepestCommonModuleRef);
                Node unstubCall = IR.call(IR.name(UNSTUB_METHOD_NAME), IR.number(stubId), value);
                unstubCall.putBooleanProp(50, true);
                unstubParent.addChildToFront(IR.exprResult(IR.assign(IR.getprop(proto.cloneTree(), IR.string(nameInfo.name)), unstubCall)).copyInformationFromForTree(value));
                this.compiler.reportCodeChange();
            }
        }
        if (!hasStubDeclaration && this.idGenerator.hasGeneratedAnyIds()) {
            Node declarations = this.compiler.parseSyntheticCode(STUB_DECLARATIONS);
            this.compiler.getNodeForCodeInsertion(null).addChildrenToFront(declarations.removeChildren());
        }
    }

    static boolean hasUnmovableRedeclaration(AnalyzePrototypeProperties.NameInfo nameInfo, AnalyzePrototypeProperties.Property prop) {
        for (AnalyzePrototypeProperties.Symbol symbol2 : nameInfo.getDeclarations()) {
            AnalyzePrototypeProperties.Property otherProp;
            if (!(symbol2 instanceof AnalyzePrototypeProperties.Property) || prop == (otherProp = (AnalyzePrototypeProperties.Property)symbol2) || prop.getRootVar() != otherProp.getRootVar() || prop.getModule() == otherProp.getModule()) continue;
            return true;
        }
        return false;
    }

    static class IdGenerator
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private int currentId = 0;

        IdGenerator() {
        }

        boolean hasGeneratedAnyIds() {
            return this.currentId != 0;
        }

        int newId() {
            return this.currentId++;
        }
    }
}

