/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class GatherSideEffectSubexpressionsCallback
implements NodeTraversal.Callback {
    private static final Set<Integer> FORBIDDEN_TYPES = ImmutableSet.of((Object)125, (Object)132, (Object)118, (Object)130, (Object)4);
    private final AbstractCompiler compiler;
    private final SideEffectAccumulator accumulator;

    GatherSideEffectSubexpressionsCallback(AbstractCompiler compiler, SideEffectAccumulator accumulator) {
        this.compiler = compiler;
        this.accumulator = accumulator;
    }

    private boolean isClassDefiningCall(Node callNode) {
        CodingConvention.SubclassRelationship classes = this.compiler.getCodingConvention().getClassesDefinedByCall(callNode);
        return classes != null;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
        if (FORBIDDEN_TYPES.contains(node.getType()) || NodeUtil.isControlStructure(node)) {
            throw new IllegalArgumentException(String.valueOf(Token.name(node.getType())) + " nodes are not supported.");
        }
        if (node.isFunction()) {
            return false;
        }
        if (node.isHook()) {
            return this.processHook(node);
        }
        if (node.isAnd() || node.isOr()) {
            return this.processShortCircuitExpression(node);
        }
        if (!NodeUtil.nodeTypeMayHaveSideEffects(node, this.compiler)) {
            return true;
        }
        if (node.isCall()) {
            return this.processFunctionCall(node);
        }
        if (node.isNew()) {
            return this.processConstructorCall(node);
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    boolean processShortCircuitExpression(Node node) {
        Preconditions.checkArgument((node.isAnd() || node.isOr() ? 1 : 0) != 0, (String)"Expected: AND or OR, Got: %s", (Object[])new Object[]{Token.name(node.getType())});
        Node left = node.getFirstChild();
        Node right = left.getNext();
        if (NodeUtil.mayHaveSideEffects(right, this.compiler)) {
            this.accumulator.keepSimplifiedShortCircuitExpression(node);
            return false;
        }
        return true;
    }

    boolean processHook(Node node) {
        Preconditions.checkArgument((boolean)node.isHook(), (String)"Expected: HOOK, Got: %s", (Object[])new Object[]{Token.name(node.getType())});
        Node condition = node.getFirstChild();
        Node ifBranch = condition.getNext();
        Node elseBranch = ifBranch.getNext();
        boolean thenHasSideEffects = NodeUtil.mayHaveSideEffects(ifBranch, this.compiler);
        boolean elseHasSideEffects = NodeUtil.mayHaveSideEffects(elseBranch, this.compiler);
        if (thenHasSideEffects || elseHasSideEffects) {
            this.accumulator.keepSimplifiedHookExpression(node, thenHasSideEffects, elseHasSideEffects);
            return false;
        }
        return true;
    }

    boolean processFunctionCall(Node node) {
        Preconditions.checkArgument((boolean)node.isCall(), (String)"Expected: CALL, Got: %s", (Object[])new Object[]{Token.name(node.getType())});
        Node functionName = node.getFirstChild();
        if ((functionName.isName() || functionName.isGetProp()) && !this.accumulator.classDefiningCallsHaveSideEffects() && this.isClassDefiningCall(node)) {
            return true;
        }
        if (!NodeUtil.functionCallHasSideEffects(node)) {
            return true;
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    boolean processConstructorCall(Node node) {
        Preconditions.checkArgument((boolean)node.isNew(), (String)"Expected: NEW, Got: %s", (Object[])new Object[]{Token.name(node.getType())});
        if (!NodeUtil.constructorCallHasSideEffects(node)) {
            return true;
        }
        this.accumulator.keepSubTree(node);
        return false;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
    }

    static final class GetReplacementSideEffectSubexpressions
    implements SideEffectAccumulator {
        private final AbstractCompiler compiler;
        private final List<Node> replacements;

        GetReplacementSideEffectSubexpressions(AbstractCompiler compiler, List<Node> replacements) {
            this.compiler = compiler;
            this.replacements = replacements;
        }

        @Override
        public boolean classDefiningCallsHaveSideEffects() {
            return true;
        }

        @Override
        public void keepSubTree(Node original) {
            if (original.getParent() != null) {
                original.detachFromParent();
            }
            this.replacements.add(original);
        }

        @Override
        public void keepSimplifiedShortCircuitExpression(Node original) {
            Preconditions.checkArgument((original.isAnd() || original.isOr() ? 1 : 0) != 0, (String)"Expected: AND or OR, Got: %s", (Object[])new Object[]{Token.name(original.getType())});
            Node left = original.getFirstChild();
            Node right = left.getNext();
            Node simplifiedRight = this.simplifyShortCircuitBranch(right);
            original.detachChildren();
            original.addChildToBack(left);
            original.addChildToBack(simplifiedRight);
            this.keepSubTree(original);
        }

        @Override
        public void keepSimplifiedHookExpression(Node hook, boolean thenHasSideEffects, boolean elseHasSideEffects) {
            Preconditions.checkArgument((boolean)hook.isHook(), (String)"Expected: HOOK, Got: %s", (Object[])new Object[]{Token.name(hook.getType())});
            Node condition = hook.getFirstChild();
            Node thenBranch = condition.getNext();
            Node elseBranch = thenBranch.getNext();
            if (thenHasSideEffects && elseHasSideEffects) {
                hook.detachChildren();
                hook.addChildToBack(condition);
                hook.addChildToBack(this.simplifyShortCircuitBranch(thenBranch));
                hook.addChildToBack(this.simplifyShortCircuitBranch(elseBranch));
                this.keepSubTree(hook);
            } else if (thenHasSideEffects || elseHasSideEffects) {
                int type = thenHasSideEffects ? 101 : 100;
                Node body = thenHasSideEffects ? thenBranch : elseBranch;
                Node simplified = new Node(type, condition.detachFromParent(), this.simplifyShortCircuitBranch(body)).copyInformationFrom(hook);
                this.keepSubTree(simplified);
            } else {
                throw new IllegalArgumentException("keepSimplifiedHookExpression must keep at least 1 branch");
            }
        }

        private Node simplifyShortCircuitBranch(Node node) {
            ArrayList parts = Lists.newArrayList();
            NodeTraversal.traverse(this.compiler, node, new GatherSideEffectSubexpressionsCallback(this.compiler, new GetReplacementSideEffectSubexpressions(this.compiler, parts)));
            Node ret = null;
            for (Node part : parts) {
                ret = ret != null ? IR.comma(ret, part).srcref(node) : part;
            }
            if (ret == null) {
                throw new IllegalArgumentException("expected at least one side effect subexpression in short circuit branch.");
            }
            return ret;
        }
    }

    static interface SideEffectAccumulator {
        public boolean classDefiningCallsHaveSideEffects();

        public void keepSubTree(Node var1);

        public void keepSimplifiedShortCircuitExpression(Node var1);

        public void keepSimplifiedHookExpression(Node var1, boolean var2, boolean var3);
    }
}

