/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Iterator;
import java.util.LinkedHashSet;

class GroupVariableDeclarations
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;

    GroupVariableDeclarations(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        LinkedHashSet varNodes = Sets.newLinkedHashSet();
        Iterator<Scope.Var> scopeVarIter = t.getScope().getVars();
        while (scopeVarIter.hasNext()) {
            Node parentNode = scopeVarIter.next().getParentNode();
            if (!parentNode.isVar()) continue;
            varNodes.add(parentNode);
        }
        if (varNodes.size() <= 1) {
            return;
        }
        Iterator varNodeIter = varNodes.iterator();
        Node firstVarNode = (Node)varNodeIter.next();
        while (varNodeIter.hasNext()) {
            Node varNode = (Node)varNodeIter.next();
            this.applyGroupingToVar(firstVarNode, varNode);
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private void applyGroupingToVar(Node firstVar, Node groupVar) {
        Node child = groupVar.getFirstChild();
        Node initializedName = null;
        while (child != null) {
            if (child.hasChildren()) {
                if (initializedName != null) {
                    return;
                }
                initializedName = child;
            }
            child = child.getNext();
        }
        Node groupVarParent = groupVar.getParent();
        if (initializedName != null) {
            if (NodeUtil.isForIn(groupVarParent)) {
                return;
            }
            Node clone = initializedName.cloneNode();
            groupVar.replaceChild(initializedName, clone);
            Node initializedVal = initializedName.removeFirstChild();
            Node assignmentNode = IR.assign(initializedName, initializedVal);
            if (groupVarParent.isFor()) {
                groupVarParent.replaceChild(groupVar, assignmentNode);
            } else {
                Node exprNode = NodeUtil.newExpr(assignmentNode);
                groupVarParent.replaceChild(groupVar, exprNode);
            }
        } else if (groupVarParent.isFor()) {
            if (NodeUtil.isForIn(groupVarParent)) {
                Node nameNodeClone = groupVar.getFirstChild().cloneNode();
                groupVarParent.replaceChild(groupVar, nameNodeClone);
            } else {
                Node emptyNode = IR.empty();
                groupVarParent.replaceChild(groupVar, emptyNode);
            }
        } else {
            groupVarParent.removeChild(groupVar);
        }
        Node children = groupVar.removeChildren();
        firstVar.addChildrenToBack(children);
        this.compiler.reportCodeChange();
    }
}

