/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.Compiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerOptions;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.JsMessage;
import com.google.gwt.thirdparty.javascript.jscomp.JsMessageDefinition;
import com.google.gwt.thirdparty.javascript.jscomp.JsMessageVisitor;
import com.google.gwt.thirdparty.javascript.jscomp.LightweightMessageFormatter;
import com.google.gwt.thirdparty.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class JsMessageExtractor {
    private final JsMessage.Style style;
    private final JsMessage.IdGenerator idGenerator;
    private final CompilerOptions options;

    public JsMessageExtractor(JsMessage.IdGenerator idGenerator, JsMessage.Style style) {
        this(idGenerator, style, new CompilerOptions());
    }

    public JsMessageExtractor(JsMessage.IdGenerator idGenerator, JsMessage.Style style, CompilerOptions options) {
        this.idGenerator = idGenerator;
        this.style = style;
        this.options = options;
    }

    public Collection<JsMessage> extractMessages(SourceFile ... inputs) throws IOException {
        return this.extractMessages((Iterable)ImmutableList.copyOf((Object[])inputs));
    }

    public <T extends SourceFile> Collection<JsMessage> extractMessages(Iterable<T> inputs) throws IOException {
        JSError[] errors;
        Compiler compiler = new Compiler();
        compiler.init(ImmutableList.of(), Lists.newArrayList(inputs), this.options);
        compiler.parseInputs();
        ExtractMessagesVisitor extractCompilerPass = new ExtractMessagesVisitor(compiler);
        if (compiler.getErrors().length == 0) {
            extractCompilerPass.process(null, compiler.getRoot());
        }
        if ((errors = compiler.getErrors()).length > 0) {
            StringBuilder msg = new StringBuilder("JSCompiler errors\n");
            LightweightMessageFormatter formatter = new LightweightMessageFormatter(compiler);
            JSError[] jSErrorArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                JSError e = jSErrorArray[n2];
                msg.append(formatter.formatError(e));
                ++n2;
            }
            throw new RuntimeException(msg.toString());
        }
        return extractCompilerPass.getMessages();
    }

    private class ExtractMessagesVisitor
    extends JsMessageVisitor {
        private final List<JsMessage> messages;

        private ExtractMessagesVisitor(AbstractCompiler compiler) {
            super(compiler, true, JsMessageExtractor.this.style, JsMessageExtractor.this.idGenerator);
            this.messages = Lists.newLinkedList();
        }

        @Override
        void processJsMessage(JsMessage message, JsMessageDefinition definition) {
            if (!message.isExternal()) {
                this.messages.add(message);
            }
        }

        public Collection<JsMessage> getMessages() {
            return this.messages;
        }
    }
}

