/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.PeepholeMinimizeConditions;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Collections;
import java.util.Comparator;

class MinimizedCondition {
    private final MeasuredNode positive;
    private final MeasuredNode negative;
    private Node placeholder;
    private static final Comparator<MeasuredNode> AST_LENGTH_COMPARATOR = new Comparator<MeasuredNode>(){

        @Override
        public int compare(MeasuredNode o1, MeasuredNode o2) {
            return o1.length - o2.length;
        }
    };

    private MinimizedCondition(MeasuredNode p, MeasuredNode n) {
        Preconditions.checkArgument((p.node.getParent() == null ? 1 : 0) != 0);
        Preconditions.checkArgument((n.node.getParent() == null ? 1 : 0) != 0);
        this.positive = p;
        this.negative = n.change();
    }

    Node getPlaceholder() {
        return this.placeholder;
    }

    MinimizedCondition setPlaceholder(Node placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    static MinimizedCondition fromConditionNode(Node n) {
        switch (n.getType()) {
            case 26: 
            case 85: 
            case 98: 
            case 100: 
            case 101: {
                Node placeholder = MinimizedCondition.swapWithPlaceholderNode(n);
                return MinimizedCondition.computeMinimizedCondition(n).setPlaceholder(placeholder);
            }
        }
        return MinimizedCondition.unoptimized(n);
    }

    MeasuredNode getMinimized(MinimizationStyle style) {
        if (style == MinimizationStyle.PREFER_UNNEGATED || this.positive.node.isNot() || this.positive.length <= this.negative.length) {
            return this.positive;
        }
        return this.negative.addNot();
    }

    static MinimizedCondition unoptimized(Node n) {
        Preconditions.checkNotNull((Object)n.getParent());
        Node placeholder = MinimizedCondition.swapWithPlaceholderNode(n);
        MeasuredNode pos = new MeasuredNode(n, 0, false);
        MeasuredNode neg = new MeasuredNode(IR.script(), Integer.MAX_VALUE, true);
        return new MinimizedCondition(pos, neg).setPlaceholder(placeholder);
    }

    private static Node swapWithPlaceholderNode(Node n) {
        Preconditions.checkNotNull((Object)n.getParent());
        Node placeholder = IR.script();
        n.getParent().replaceChild(n, placeholder);
        return placeholder;
    }

    private static MinimizedCondition computeMinimizedCondition(Node n) {
        Preconditions.checkArgument((n.getParent() == null ? 1 : 0) != 0);
        switch (n.getType()) {
            case 26: {
                MinimizedCondition subtree = MinimizedCondition.computeMinimizedCondition(n.getFirstChild().detachFromParent());
                ImmutableList positiveAsts = ImmutableList.of((Object)subtree.positive.cloneTree().addNot(), (Object)subtree.negative.cloneTree());
                ImmutableList negativeAsts = ImmutableList.of((Object)subtree.negative.negate(), (Object)subtree.positive);
                return new MinimizedCondition(Collections.min(positiveAsts, AST_LENGTH_COMPARATOR), Collections.min(negativeAsts, AST_LENGTH_COMPARATOR));
            }
            case 100: 
            case 101: {
                int opType = n.getType();
                int complementType = opType == 101 ? 100 : 101;
                MinimizedCondition leftSubtree = MinimizedCondition.computeMinimizedCondition(n.getFirstChild().detachFromParent());
                MinimizedCondition rightSubtree = MinimizedCondition.computeMinimizedCondition(n.getLastChild().detachFromParent());
                ImmutableList positiveAsts = ImmutableList.of((Object)MeasuredNode.addNode(new Node(opType).srcref(n), new MeasuredNode[]{leftSubtree.positive.cloneTree(), rightSubtree.positive.cloneTree()}), (Object)MeasuredNode.addNode(new Node(complementType).srcref(n), new MeasuredNode[]{leftSubtree.negative.cloneTree(), rightSubtree.negative.cloneTree()}).negate());
                ImmutableList negativeAsts = ImmutableList.of((Object)MeasuredNode.addNode(new Node(opType).srcref(n), new MeasuredNode[]{leftSubtree.positive, rightSubtree.positive}).negate(), (Object)MeasuredNode.addNode(new Node(complementType).srcref(n), new MeasuredNode[]{leftSubtree.negative, rightSubtree.negative}));
                return new MinimizedCondition(Collections.min(positiveAsts, AST_LENGTH_COMPARATOR), Collections.min(negativeAsts, AST_LENGTH_COMPARATOR));
            }
            case 98: {
                Node cond = n.getFirstChild();
                Node thenNode = cond.getNext();
                Node elseNode = thenNode.getNext();
                MinimizedCondition thenSubtree = MinimizedCondition.computeMinimizedCondition(thenNode.detachFromParent());
                MinimizedCondition elseSubtree = MinimizedCondition.computeMinimizedCondition(elseNode.detachFromParent());
                MeasuredNode posTree = MeasuredNode.addNode(new Node(98, cond.cloneTree()).srcref(n), new MeasuredNode[]{thenSubtree.positive, elseSubtree.positive});
                MeasuredNode negTree = MeasuredNode.addNode(new Node(98, cond.cloneTree()).srcref(n), new MeasuredNode[]{thenSubtree.negative, elseSubtree.negative});
                return new MinimizedCondition(posTree, negTree);
            }
            case 85: {
                Node lhs = n.getFirstChild();
                MinimizedCondition rhsSubtree = MinimizedCondition.computeMinimizedCondition(lhs.getNext().detachFromParent());
                MeasuredNode posTree = MeasuredNode.addNode(new Node(85, lhs.cloneTree()).srcref(n), new MeasuredNode[]{rhsSubtree.positive});
                MeasuredNode negTree = MeasuredNode.addNode(new Node(85, lhs.cloneTree()).srcref(n), new MeasuredNode[]{rhsSubtree.negative});
                return new MinimizedCondition(posTree, negTree);
            }
        }
        MeasuredNode pos = new MeasuredNode(n, 0, false);
        MeasuredNode neg = pos.cloneTree().negate();
        return new MinimizedCondition(pos, neg);
    }

    static class MeasuredNode {
        private Node node;
        private int length;
        private boolean changed;

        Node getNode() {
            return this.node;
        }

        boolean isChanged() {
            return this.changed;
        }

        MeasuredNode(Node n, int len, boolean ch) {
            this.node = n;
            this.length = len;
            this.changed = ch;
        }

        private MeasuredNode negate() {
            this.change();
            switch (this.node.getType()) {
                case 12: {
                    this.node.setType(13);
                    return this;
                }
                case 13: {
                    this.node.setType(12);
                    return this;
                }
                case 45: {
                    this.node.setType(46);
                    return this;
                }
                case 46: {
                    this.node.setType(45);
                    return this;
                }
            }
            return this.addNot();
        }

        private MeasuredNode change() {
            this.changed = true;
            return this;
        }

        private MeasuredNode addNot() {
            this.node = new Node(26, this.node).srcref(this.node);
            this.length += MeasuredNode.estimateCostOneLevel(this.node);
            return this;
        }

        private static int estimateCostOneLevel(Node n) {
            int cost = 0;
            if (n.isNot()) {
                ++cost;
            }
            int parentPrecedence = NodeUtil.precedence(n.getType());
            Node child = n.getFirstChild();
            while (child != null) {
                if (PeepholeMinimizeConditions.isLowerPrecedence(child, parentPrecedence)) {
                    cost += 2;
                }
                child = child.getNext();
            }
            return cost;
        }

        private MeasuredNode cloneTree() {
            return new MeasuredNode(this.node.cloneTree(), this.length, this.changed);
        }

        private static MeasuredNode addNode(Node parent, MeasuredNode ... children) {
            int cost = 0;
            boolean changed = false;
            MeasuredNode[] measuredNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                MeasuredNode child = measuredNodeArray[n2];
                parent.addChildrenToBack(child.node);
                cost += child.length;
                changed = changed || child.changed;
                ++n2;
            }
            return new MeasuredNode(parent, cost += MeasuredNode.estimateCostOneLevel(parent), changed);
        }
    }

    static enum MinimizationStyle {
        PREFER_UNNEGATED,
        ALLOW_LEADING_NOT;

    }
}

