/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.primitives.Chars;
import com.google.gwt.thirdparty.javascript.rhino.TokenStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class NameGenerator {
    private final Map<Character, CharPriority> priorityLookupMap;
    static final char[] FIRST_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$".toCharArray();
    static final char[] NONFIRST_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789$".toCharArray();
    private final Set<String> reservedNames;
    private final String prefix;
    private int nameCount;
    private final CharPriority[] firstChars;
    private final CharPriority[] nonFirstChars;

    NameGenerator(Set<String> reservedNames, String prefix, @Nullable char[] reservedCharacters) {
        this.reservedNames = reservedNames;
        this.prefix = prefix;
        this.priorityLookupMap = Maps.newHashMapWithExpectedSize((int)NONFIRST_CHAR.length);
        int order = 0;
        char[] cArray = NONFIRST_CHAR;
        int n = NONFIRST_CHAR.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.priorityLookupMap.put(Character.valueOf(c), new CharPriority(c, order));
            ++order;
            ++n2;
        }
        this.firstChars = this.reserveCharacters(FIRST_CHAR, reservedCharacters);
        this.nonFirstChars = this.reserveCharacters(NONFIRST_CHAR, reservedCharacters);
        this.checkPrefix(prefix);
    }

    public void restartNaming() {
        Arrays.sort(this.firstChars);
        Arrays.sort(this.nonFirstChars);
        this.nameCount = 0;
    }

    public void favors(CharSequence sequence) {
        int i = 0;
        while (i < sequence.length()) {
            CharPriority c = this.priorityLookupMap.get(Character.valueOf(sequence.charAt(i)));
            if (c != null) {
                ++c.occurance;
            }
            ++i;
        }
    }

    CharPriority[] reserveCharacters(char[] chars, char[] reservedCharacters) {
        if (reservedCharacters == null || reservedCharacters.length == 0) {
            CharPriority[] result = new CharPriority[chars.length];
            int i = 0;
            while (i < chars.length) {
                result[i] = this.priorityLookupMap.get(Character.valueOf(chars[i]));
                ++i;
            }
            return result;
        }
        LinkedHashSet charSet = Sets.newLinkedHashSet((Iterable)Chars.asList((char[])chars));
        Object object = reservedCharacters;
        int n = reservedCharacters.length;
        int n2 = 0;
        while (n2 < n) {
            char reservedCharacter = object[n2];
            charSet.remove(Character.valueOf(reservedCharacter));
            ++n2;
        }
        CharPriority[] result = new CharPriority[charSet.size()];
        int index = 0;
        object = charSet.iterator();
        while (object.hasNext()) {
            char c = ((Character)object.next()).charValue();
            result[index++] = this.priorityLookupMap.get(Character.valueOf(c));
        }
        return result;
    }

    private void checkPrefix(String prefix) {
        if (prefix.length() > 0) {
            if (!NameGenerator.contains(this.firstChars, prefix.charAt(0))) {
                char[] chars = new char[this.firstChars.length];
                int i = 0;
                while (i < chars.length) {
                    chars[i] = this.firstChars[i].name;
                    ++i;
                }
                throw new IllegalArgumentException("prefix must start with one of: " + Arrays.toString(chars));
            }
            int pos = 1;
            while (pos < prefix.length()) {
                char[] chars = new char[this.nonFirstChars.length];
                int i = 0;
                while (i < chars.length) {
                    chars[i] = this.nonFirstChars[i].name;
                    ++i;
                }
                if (!NameGenerator.contains(this.nonFirstChars, prefix.charAt(pos))) {
                    throw new IllegalArgumentException("prefix has invalid characters, must be one of: " + Arrays.toString(chars));
                }
                ++pos;
            }
        }
    }

    private static boolean contains(CharPriority[] arr, char c) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i].name == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    String generateNextName() {
        String name;
        do {
            int pos;
            name = this.prefix;
            int i = this.nameCount;
            if (name.isEmpty()) {
                pos = i % this.firstChars.length;
                name = String.valueOf(name) + this.firstChars[pos].name;
                i /= this.firstChars.length;
            }
            while (i > 0) {
                pos = --i % this.nonFirstChars.length;
                name = String.valueOf(name) + this.nonFirstChars[pos].name;
                i /= this.nonFirstChars.length;
            }
            ++this.nameCount;
        } while (TokenStream.isKeyword(name) || this.reservedNames.contains(name));
        return name;
    }

    private final class CharPriority
    implements Comparable<CharPriority> {
        final char name;
        int occurance;
        final int order;

        CharPriority(char name, int order) {
            this.name = name;
            this.order = order;
            this.occurance = 0;
        }

        @Override
        public int compareTo(CharPriority other) {
            int result = other.occurance - this.occurance;
            if (result != 0) {
                return result;
            }
            result = this.order - other.order;
            return result;
        }
    }
}

