/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CheckGlobalThis;
import com.google.gwt.thirdparty.javascript.jscomp.CheckMissingReturn;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.ControlFlowAnalysis;
import com.google.gwt.thirdparty.javascript.jscomp.ControlFlowGraph;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.GlobalTypeInfo;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.TypeCheck;
import com.google.gwt.thirdparty.javascript.jscomp.graph.DiGraph;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.TypeUtils;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NewTypeInference
implements CompilerPass {
    static final DiagnosticType MISTYPED_ASSIGN_RHS = DiagnosticType.warning("JSC_MISTYPED_ASSIGN_RHS", "The right-hand side in the assignment is not a subtype of the declared type.\ndeclared : {0}\nfound    : {1}\n");
    static final DiagnosticType INVALID_OPERAND_TYPE = DiagnosticType.warning("JSC_INVALID_OPERAND_TYPE", "Invalid type(s) for operator {0}.\nexpected : {1}\nfound    : {2}\n");
    static final DiagnosticType RETURN_NONDECLARED_TYPE = DiagnosticType.warning("JSC_RETURN_NONDECLARED_TYPE", "Returned type does not match declared return type.\n declared : {0}\nfound    : {1}\n");
    static final DiagnosticType INVALID_INFERRED_RETURN_TYPE = DiagnosticType.warning("JSC_INVALID_INFERRED_RETURN_TYPE", "Function called in context that expects incompatible type.\n expected : {0}\nfound    : {1}\n");
    static final DiagnosticType INVALID_ARGUMENT_TYPE = DiagnosticType.warning("JSC_INVALID_ARGUMENT_TYPE", "Invalid type for parameter {0} of function {1}.\n expected : {2}\nfound    : {3}\n");
    static final DiagnosticType CROSS_SCOPE_GOTCHA = DiagnosticType.warning("JSC_CROSS_SCOPE_GOTCHA", "You thought we weren't going to notice? Guess again.\nVariable {0} typed inconsistently across scopes.\n In outer scope : {1}\nIn inner scope : {2}\n");
    static final DiagnosticType POSSIBLY_INEXISTENT_PROPERTY = DiagnosticType.warning("JSC_POSSIBLY_INEXISTENT_PROPERTY", "Property {0} may not be present on {1}.");
    static final DiagnosticType PROPERTY_ACCESS_ON_NONOBJECT = DiagnosticType.warning("JSC_PROPERTY_ACCESS_ON_NONOBJECT", "Cannot access property {0} of non-object type {1}.");
    static final DiagnosticType CALL_FUNCTION_WITH_BOTTOM_FORMAL = DiagnosticType.warning("JSC_CALL_FUNCTION_WITH_BOTTOM_FORMAL", "The #{0} formal parameter of this function has an invalid type, which prevents the function from being called.\nPlease change the type.");
    Set<JSError> warnings = Sets.newHashSet();
    private final AbstractCompiler compiler;
    Map<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>, TypeEnv> envs;
    Map<GlobalTypeInfo.Scope, JSType> summaries;
    Map<Node, DeferredCheck> deferredChecks;
    ControlFlowGraph<Node> cfg;
    Node jsRoot;
    GlobalTypeInfo.Scope currentScope;
    GlobalTypeInfo symbolTable;
    static final String RETVAL_ID = "%return";
    private JSType arrayType;
    private JSType regexpType;
    private static boolean debugging = false;

    NewTypeInference(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.envs = Maps.newHashMap();
        this.summaries = Maps.newHashMap();
        this.deferredChecks = Maps.newHashMap();
    }

    @Override
    public void process(Node externs, Node root) {
        this.jsRoot = root;
        this.symbolTable = this.compiler.getSymbolTable();
        GlobalTypeInfo.Scope gs = this.symbolTable.getGlobalScope();
        JSType arrayCtor = gs.getDeclaredTypeOf("Array");
        this.arrayType = arrayCtor == null ? JSType.UNKNOWN : arrayCtor.getFunType().getReturnType();
        JSType regexpCtor = gs.getDeclaredTypeOf("RegExp");
        this.regexpType = regexpCtor == null ? JSType.UNKNOWN : regexpCtor.getFunType().getReturnType();
        for (GlobalTypeInfo.Scope scope : this.symbolTable.getScopes()) {
            this.analyzeFunction(scope);
        }
        for (DeferredCheck check : this.deferredChecks.values()) {
            check.runCheck(this.summaries, this.warnings);
        }
        for (JSError warning : this.warnings) {
            this.compiler.report(warning);
        }
    }

    private static void println(Object ... objs) {
        if (debugging) {
            StringBuilder b = new StringBuilder();
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                b.append(obj == null ? "null" : obj.toString());
                ++n2;
            }
            System.out.println(b.toString());
        }
    }

    private static Node getConditionExpression(Node n) {
        return NodeUtil.isForIn(n) ? n.getFirstChild() : NodeUtil.getConditionExpression(n);
    }

    private TypeEnv getInEnv(Node n) {
        Preconditions.checkArgument((this.cfg.getInEdges(n).size() > 0 ? 1 : 0) != 0);
        TypeEnv inEnv = null;
        for (DiGraph.DiGraphEdge de : this.cfg.getInEdges(n)) {
            TypeEnv env = this.envs.get(de);
            TypeEnv typeEnv = inEnv = inEnv == null ? env : TypeEnv.join(inEnv, env);
        }
        return inEnv == null ? new TypeEnv() : inEnv;
    }

    private TypeEnv getOutEnv(Node n) {
        Preconditions.checkState((this.cfg.getOutEdges(n).size() > 0 ? 1 : 0) != 0);
        TypeEnv outEnv = null;
        for (DiGraph.DiGraphEdge de : this.cfg.getOutEdges(n)) {
            TypeEnv env = this.envs.get(de);
            TypeEnv typeEnv = outEnv = outEnv == null ? env : TypeEnv.join(outEnv, env);
        }
        return outEnv == null ? new TypeEnv() : outEnv;
    }

    private TypeEnv setOutEnv(Node n, TypeEnv e) {
        for (DiGraph.DiGraphEdge de : this.cfg.getOutEdges(n)) {
            this.envs.put(de, e);
        }
        return e;
    }

    private TypeEnv setInEnv(Node n, TypeEnv e) {
        for (DiGraph.DiGraphEdge de : this.cfg.getInEdges(n)) {
            this.envs.put(de, e);
        }
        return e;
    }

    private void initEdgeEnvsFwd() {
        DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> entry = this.cfg.getEntry();
        DiGraph.DiGraphEdge entryOutEdge = this.cfg.getOutEdges((Node)entry.getValue()).get(0);
        TypeEnv entryEnv = this.envs.get(entryOutEdge);
        this.initEdgeEnvs(new TypeEnv());
        if (this.currentScope.isFunction()) {
            Set<String> formalsAndOuters = this.currentScope.getOuterVars();
            formalsAndOuters.addAll(this.currentScope.getFormals());
            if (this.currentScope.hasThis()) {
                formalsAndOuters.add("this");
            }
            for (String name : formalsAndOuters) {
                JSType declType = this.currentScope.getDeclaredTypeOf(name);
                JSType initType = declType == null ? NewTypeInference.envGetType(entryEnv, name) : (declType.getFunTypeIfSingletonObj() != null && declType.getFunTypeIfSingletonObj().isConstructor() ? declType.getFunTypeIfSingletonObj().createConstructorObject() : declType);
                entryEnv = NewTypeInference.envPutType(entryEnv, name, initType.withLocation(name));
            }
            entryEnv = NewTypeInference.envPutType(entryEnv, RETVAL_ID, JSType.UNDEFINED);
        }
        for (String local : this.currentScope.getLocals()) {
            entryEnv = NewTypeInference.envPutType(entryEnv, local, JSType.UNDEFINED);
        }
        for (String fnName : this.currentScope.getLocalFunDefs()) {
            JSType summaryType = this.summaries.get(this.currentScope.getScope(fnName));
            FunctionType fnType = summaryType.getFunType();
            summaryType = fnType.isConstructor() ? fnType.createConstructorObject() : summaryType.withProperty("prototype", JSType.TOP_OBJECT);
            entryEnv = NewTypeInference.envPutType(entryEnv, fnName, summaryType);
        }
        NewTypeInference.println("Keeping env: ", entryEnv);
        this.envs.put(entryOutEdge, entryEnv);
    }

    private void initEdgeEnvsBwd() {
        TypeEnv env = new TypeEnv();
        Set<String> varNames = this.currentScope.getOuterVars();
        varNames.addAll(this.currentScope.getFormals());
        varNames.addAll(this.currentScope.getLocals());
        if (this.currentScope.hasThis()) {
            varNames.add("this");
        }
        for (String varName : varNames) {
            JSType declType = this.currentScope.getDeclaredTypeOf(varName);
            env = declType == null ? NewTypeInference.envPutType(env, varName, JSType.UNKNOWN) : NewTypeInference.envPutType(env, varName, declType);
        }
        for (String fnName : this.currentScope.getLocalFunDefs()) {
            JSType summaryType = this.summaries.get(this.currentScope.getScope(fnName));
            FunctionType fnType = summaryType.getFunType();
            summaryType = fnType.isConstructor() ? fnType.createConstructorObject() : summaryType.withProperty("prototype", JSType.TOP_OBJECT);
            env = NewTypeInference.envPutType(env, fnName, summaryType);
        }
        this.initEdgeEnvs(env);
    }

    private void initEdgeEnvs(TypeEnv env) {
        for (DiGraph.DiGraphEdge e : this.cfg.getEdges()) {
            this.envs.put(e, env);
        }
    }

    private void buildWorkset(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        this.buildWorksetHelper(dn, workset, new HashSet<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>());
    }

    private void buildWorksetHelper(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset, Set<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> seen) {
        if (seen.contains(dn) || dn == this.cfg.getImplicitReturn()) {
            return;
        }
        Node currentNode = (Node)dn.getValue();
        switch (currentNode.getType()) {
            case 113: 
            case 114: 
            case 115: {
                List outEdges = this.cfg.getOutEdges((Node)dn.getValue());
                seen.add(dn);
                workset.add(dn);
                for (DiGraph.DiGraphEdge diGraphEdge : outEdges) {
                    if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_TRUE) continue;
                    this.buildWorksetHelper(diGraphEdge.getDestination(), workset, seen);
                }
                workset.add(dn);
                for (DiGraph.DiGraphEdge diGraphEdge : outEdges) {
                    if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_FALSE) continue;
                    this.buildWorksetHelper(diGraphEdge.getDestination(), workset, seen);
                }
                break;
            }
            default: {
                for (DiGraph.DiGraphEdge diGraphEdge : this.cfg.getInEdges((Node)dn.getValue())) {
                    if (seen.contains(diGraphEdge.getSource()) || ((Node)diGraphEdge.getSource().getValue()).isDo()) continue;
                    return;
                }
                seen.add(dn);
                if (this.cfg.getEntry() != dn) {
                    workset.add(dn);
                }
                for (DiGraph.DiGraphNode diGraphNode : this.cfg.getDirectedSuccNodes(dn)) {
                    this.buildWorksetHelper(diGraphNode, workset, seen);
                }
            }
        }
    }

    private void analyzeFunction(GlobalTypeInfo.Scope scope) {
        NewTypeInference.println("=== Analyzing function: ", scope.getReadableName(), " ===");
        this.currentScope = scope;
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, scope.getRoot());
        this.cfg = cfa.getCfg();
        NewTypeInference.println(this.cfg);
        LinkedList workset = Lists.newLinkedList();
        this.buildWorkset(this.cfg.getEntry(), workset);
        Collections.reverse(workset);
        this.initEdgeEnvsBwd();
        this.analyzeFunctionBwd(workset);
        Collections.reverse(workset);
        this.initEdgeEnvsFwd();
        this.analyzeFunctionFwd(workset);
        if (scope.isFunction()) {
            this.createSummary(scope);
        }
    }

    private void analyzeFunctionBwd(List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : workset) {
            TypeEnv inEnv;
            Node n = (Node)dn.getValue();
            if (n.isThrow()) continue;
            TypeEnv outEnv = this.getOutEnv(n);
            NewTypeInference.println("\tBWD Statment: ", n);
            NewTypeInference.println("\t\toutEnv: ", outEnv);
            switch (n.getType()) {
                case 130: {
                    inEnv = this.analyzeExprBwd((Node)n.getFirstChild(), (TypeEnv)outEnv, (JSType)JSType.TOP).env;
                    break;
                }
                case 4: {
                    Node retExp = n.getFirstChild();
                    if (retExp == null) {
                        inEnv = outEnv;
                        break;
                    }
                    JSType declRetType = this.currentScope.getDeclaredType().getReturnType();
                    declRetType = declRetType == null ? JSType.UNKNOWN : declRetType;
                    inEnv = this.analyzeExprBwd((Node)retExp, (TypeEnv)outEnv, (JSType)declRetType).env;
                    break;
                }
                case 118: {
                    inEnv = null;
                    Node nameNode = n.getFirstChild();
                    while (nameNode != null) {
                        String varName = nameNode.getQualifiedName();
                        Node rhs = nameNode.getFirstChild();
                        JSType declType = this.currentScope.getDeclaredTypeOf(varName);
                        inEnv = NewTypeInference.envPutType(outEnv, varName, JSType.UNKNOWN);
                        if (rhs != null && !this.currentScope.isLocalFunDef(varName)) {
                            JSType requiredType = declType == null ? JSType.UNKNOWN : declType;
                            inEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)inEnv, (JSType)JSType.meet((JSType)requiredType, (JSType)NewTypeInference.envGetType((TypeEnv)outEnv, (String)varName))).env;
                        }
                        nameNode = nameNode.getNext();
                    }
                    break;
                }
                case 77: 
                case 112: 
                case 116: 
                case 117: 
                case 120: 
                case 124: 
                case 125: 
                case 132: {
                    inEnv = outEnv;
                    break;
                }
                case 108: 
                case 113: 
                case 114: 
                case 115: {
                    inEnv = this.analyzeExprBwd((Node)NewTypeInference.getConditionExpression((Node)n), (TypeEnv)outEnv).env;
                    break;
                }
                case 110: 
                case 111: {
                    inEnv = this.analyzeExprBwd((Node)n.getFirstChild(), (TypeEnv)outEnv).env;
                    break;
                }
                default: {
                    if (NodeUtil.isStatement(n)) {
                        throw new RuntimeException("Unhandled statement type: " + Token.name(n.getType()));
                    }
                    inEnv = this.analyzeExprBwd((Node)n, (TypeEnv)outEnv).env;
                }
            }
            NewTypeInference.println("\t\tinEnv: ", inEnv);
            this.setInEnv(n, inEnv);
        }
    }

    private void analyzeFunctionFwd(List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : workset) {
            Node n = (Node)dn.getValue();
            Preconditions.checkState((n != null ? 1 : 0) != 0, (Object)"Implicit return should not be in workset.");
            TypeEnv inEnv = this.getInEnv(n);
            TypeEnv outEnv = null;
            NewTypeInference.println("\tFWD Statment: ", n);
            NewTypeInference.println("\t\tinEnv: ", inEnv);
            boolean conditional = false;
            switch (n.getType()) {
                case 77: 
                case 105: 
                case 112: 
                case 116: 
                case 117: 
                case 120: 
                case 124: 
                case 125: 
                case 132: {
                    outEnv = inEnv;
                    break;
                }
                case 130: {
                    NewTypeInference.println("\tsemi ", Token.name(n.getFirstChild().getType()));
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv, (JSType)JSType.TOP).env;
                    break;
                }
                case 4: {
                    JSType actualRetType;
                    Node retExp = n.getFirstChild();
                    JSType declRetType = this.currentScope.getDeclaredType().getReturnType();
                    JSType jSType = declRetType = declRetType == null ? JSType.UNKNOWN : declRetType;
                    if (retExp == null) {
                        actualRetType = JSType.UNDEFINED;
                        outEnv = NewTypeInference.envPutType(inEnv, RETVAL_ID, actualRetType);
                    } else {
                        EnvTypePair retPair = this.analyzeExprFwd(retExp, inEnv, declRetType);
                        actualRetType = retPair.type;
                        outEnv = NewTypeInference.envPutType(retPair.env, RETVAL_ID, actualRetType);
                    }
                    if (actualRetType.isSubtypeOf(declRetType)) break;
                    this.warnings.add(JSError.make(n, RETURN_NONDECLARED_TYPE, declRetType.toString(), actualRetType.toString()));
                    break;
                }
                case 108: 
                case 113: 
                case 114: 
                case 115: {
                    conditional = true;
                    this.analyzeConditionalStmFwd(n, NewTypeInference.getConditionExpression(n), inEnv);
                    break;
                }
                case 111: {
                    conditional = true;
                    Node switchedExp = n.getParent().getFirstChild().cloneTree();
                    Node syntheticSheq = IR.sheq(switchedExp, n.getFirstChild().cloneTree());
                    this.analyzeConditionalStmFwd(n, syntheticSheq, inEnv);
                    break;
                }
                case 118: {
                    outEnv = inEnv;
                    Node nameNode = n.getFirstChild();
                    while (nameNode != null) {
                        outEnv = this.processVarDeclaration(nameNode, outEnv);
                        nameNode = nameNode.getNext();
                    }
                    break;
                }
                case 49: 
                case 110: {
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv).env;
                    break;
                }
                default: {
                    if (NodeUtil.isStatement(n)) {
                        throw new RuntimeException("Unhandled statement type: " + Token.name(n.getType()));
                    }
                    outEnv = this.analyzeExprFwd((Node)n, (TypeEnv)inEnv, (JSType)JSType.TOP).env;
                }
            }
            if (conditional) continue;
            NewTypeInference.println("\t\toutEnv: ", outEnv);
            this.setOutEnv(n, outEnv);
        }
    }

    private void analyzeConditionalStmFwd(Node stm, Node cond, TypeEnv inEnv) {
        for (DiGraph.DiGraphEdge outEdge : this.cfg.getOutEdges(stm)) {
            JSType specializedType;
            switch ((ControlFlowGraph.Branch)((Object)outEdge.getValue())) {
                case ON_TRUE: {
                    specializedType = JSType.TRUTHY;
                    break;
                }
                case ON_FALSE: {
                    specializedType = JSType.FALSY;
                    break;
                }
                default: {
                    throw new RuntimeException("A condition with an edge that is neither true nor false?");
                }
            }
            this.envs.put(outEdge, this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.TOP, (JSType)specializedType).env);
        }
    }

    private void createSummary(GlobalTypeInfo.Scope fn) {
        TypeEnv entryEnv = this.getInitTypeEnv();
        TypeEnv exitEnv = this.getFinalTypeEnv();
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Multimap<String, String> taints = exitEnv.getTaints();
        int formalIndex = 0;
        DeclaredFunctionType declType = fn.getDeclaredType();
        int reqArity = declType.getRequiredArity();
        int optArity = declType.getOptionalArity();
        for (String formal : fn.getFormals()) {
            JSType formalType = fn.getDeclaredTypeOf(formal);
            if (formalType == null) {
                formalType = NewTypeInference.envGetType(entryEnv, formal);
                if (!formalType.hasNonScalar() || formalType.getFunType() != null) {
                    for (String taintedVarName : taints.get((Object)formal)) {
                        JSType taintType = NewTypeInference.envGetType(exitEnv, taintedVarName);
                        formalType = JSType.meet(taintType, formalType);
                    }
                }
                formalType = formalType.withLocation(null);
            }
            if (formalIndex < reqArity) {
                builder.addReqFormal(formalType);
            } else if (formalIndex < optArity) {
                builder.addOptFormal(formalType);
            }
            ++formalIndex;
        }
        if (declType.hasRestFormals()) {
            builder.addRestFormals(declType.getFormalType(formalIndex));
        }
        for (String outer : fn.getOuterVars()) {
            NewTypeInference.println("Free var ", outer, " going in summary");
            JSType outerType = NewTypeInference.envGetType(entryEnv, outer);
            for (String taintedVarName : taints.get((Object)outer)) {
                JSType taintType = NewTypeInference.envGetType(exitEnv, taintedVarName);
                outerType = JSType.meet(taintType, outerType);
            }
            builder.addOuterVarPrecondition(outer, outerType.withLocation(null));
        }
        builder.addClass(declType.getClassType());
        JSType declRetType = declType.getReturnType();
        JSType actualRetType = NewTypeInference.envGetType(exitEnv, RETVAL_ID);
        if (declRetType == null) {
            builder.addRetType(actualRetType.withLocation(null));
        } else {
            builder.addRetType(declRetType);
            if (!JSType.UNDEFINED.isSubtypeOf(declRetType) && NewTypeInference.hasPathWithNoReturn(this.cfg)) {
                this.warnings.add(JSError.make(fn.getRoot(), CheckMissingReturn.MISSING_RETURN_STATEMENT, declRetType.toString()));
            }
        }
        JSType summary = builder.buildType();
        NewTypeInference.println("Function summary for ", fn.getReadableName());
        NewTypeInference.println("\t", summary);
        this.summaries.put(fn, summary);
    }

    private static boolean hasPathWithNoReturn(ControlFlowGraph<Node> cfg) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : cfg.getDirectedPredNodes(cfg.getImplicitReturn())) {
            if (((Node)dn.getValue()).isReturn()) continue;
            return true;
        }
        return false;
    }

    private TypeEnv processVarDeclaration(Node nameNode, TypeEnv inEnv) {
        JSType rhsType;
        String varName = nameNode.getQualifiedName();
        if (this.currentScope.isLocalFunDef(varName)) {
            return inEnv;
        }
        Node rhs = nameNode.getFirstChild();
        TypeEnv outEnv = inEnv;
        JSType declType = this.currentScope.getDeclaredTypeOf(varName);
        if (rhs == null) {
            rhsType = JSType.UNDEFINED;
        } else {
            EnvTypePair pair = this.analyzeExprFwd(rhs, inEnv, declType != null ? declType : JSType.TOP);
            outEnv = pair.env;
            rhsType = pair.type;
        }
        if (!NodeUtil.isNamespaceDecl((Node)nameNode) && declType != null && rhs != null && !rhsType.isSubtypeOf(declType)) {
            this.warnings.add(JSError.make(rhs, MISTYPED_ASSIGN_RHS, declType.toString(), rhsType.toString()));
            rhsType = declType;
        }
        return NewTypeInference.envPutType(outEnv, varName, rhsType);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv) {
        return this.analyzeExprFwd(expr, inEnv, JSType.TOP, JSType.TOP);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        return this.analyzeExprFwd(expr, inEnv, requiredType, requiredType);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Preconditions.checkArgument((requiredType != null && !requiredType.isBottom() ? 1 : 0) != 0);
        int exprKind = expr.getType();
        switch (exprKind) {
            case 124: {
                return new EnvTypePair(inEnv, JSType.UNKNOWN);
            }
            case 105: {
                String fnName = this.symbolTable.getFunInternalName(expr);
                return new EnvTypePair(inEnv, NewTypeInference.envGetType(inEnv, fnName));
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return new EnvTypePair(inEnv, NewTypeInference.scalarValueToType(exprKind));
            }
            case 64: {
                JSType result = JSType.TOP_OBJECT;
                TypeEnv env = inEnv;
                for (Node key : expr.children()) {
                    String pname = NodeUtil.getObjectLitKeyName(key);
                    JSType reqPtype = requiredType.mayHaveProp(pname) ? requiredType.getProp(pname) : JSType.TOP;
                    JSType specPtype = specializedType.mayHaveProp(pname) ? specializedType.getProp(pname) : JSType.TOP;
                    EnvTypePair pair = this.analyzeExprFwd(key.getLastChild(), env, reqPtype, specPtype);
                    result = result.withProperty(pname, pair.type);
                    env = pair.env;
                }
                return new EnvTypePair(env, result);
            }
            case 42: {
                if (!this.currentScope.hasThis()) {
                    this.warnings.add(JSError.make(expr, CheckGlobalThis.GLOBAL_THIS, new String[0]));
                    return new EnvTypePair(inEnv, JSType.UNKNOWN);
                }
                JSType thisType = this.currentScope.getDeclaredTypeOf("this");
                return new EnvTypePair(inEnv, thisType);
            }
            case 38: {
                String varName = expr.getQualifiedName();
                if (varName.equals("undefined")) {
                    return new EnvTypePair(inEnv, JSType.UNDEFINED);
                }
                if (this.currentScope.isLocalVar(varName) || this.currentScope.isFormalParam(varName) || this.currentScope.isLocalFunDef(varName) || this.currentScope.isOuterVar(varName)) {
                    JSType inferredType = NewTypeInference.envGetType(inEnv, varName);
                    NewTypeInference.println(varName, "'s inferredType: ", inferredType, " requiredType:  ", requiredType);
                    if (!inferredType.isSubtypeOf(requiredType)) {
                        if (this.currentScope.getDeclaredTypeOf(varName) == null && inferredType.equals(JSType.NUM_OR_STR) && requiredType.isSubtypeOf(inferredType)) {
                            inferredType = requiredType;
                        } else {
                            return new EnvTypePair(inEnv, inferredType);
                        }
                    }
                    JSType preciseType = inferredType.specialize(specializedType);
                    NewTypeInference.println(varName, "'s preciseType: ", preciseType);
                    if (this.currentScope.isUndeclaredFormal(varName) && requiredType.hasNonScalar()) {
                        preciseType = preciseType.withLoose();
                    }
                    return EnvTypePair.addBinding(inEnv, varName, preciseType);
                }
                NewTypeInference.println("Found global variable ", varName);
                return new EnvTypePair(inEnv, JSType.UNKNOWN);
            }
            case 100: 
            case 101: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                if (specializedType.isTruthy() && exprKind == 101 || specializedType.isFalsy() && exprKind == 100) {
                    EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.TOP, specializedType);
                    EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.TOP, specializedType);
                    return rhsPair;
                }
                if (specializedType.isFalsy() && exprKind == 101 || specializedType.isTruthy() && exprKind == 100) {
                    EnvTypePair shortCircuitPair = this.analyzeExprFwd(lhs, inEnv, JSType.TOP, specializedType);
                    JSType negatedType = specializedType.isTruthy() ? JSType.FALSY : JSType.TRUTHY;
                    EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.TOP, negatedType);
                    EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.TOP, specializedType);
                    return EnvTypePair.join(rhsPair, shortCircuitPair);
                }
                EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
                EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
                return rhsPair;
            }
            case 27: 
            case 28: 
            case 29: 
            case 102: 
            case 103: {
                Node child = expr.getFirstChild();
                EnvTypePair pair = this.analyzeExprFwd(child, inEnv, JSType.NUMBER);
                if (!pair.type.isSubtypeOf(JSType.NUMBER)) {
                    this.warnInvalidOperand(child, expr.getType(), JSType.NUMBER, pair.type);
                }
                pair.type = JSType.NUMBER;
                return pair;
            }
            case 32: {
                EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                pair.type = JSType.STRING;
                return pair;
            }
            case 52: {
                Node obj = expr.getFirstChild();
                Node ctor = expr.getLastChild();
                EnvTypePair objPair = this.analyzeExprFwd(obj, inEnv);
                JSType objType = objPair.type;
                if (!(objType.equals(JSType.TOP) || objType.equals(JSType.UNKNOWN) || objType.hasNonScalar())) {
                    this.warnInvalidOperand(obj, 52, "an object or a union type that includes an object", objPair.type);
                }
                EnvTypePair ctorPair = this.analyzeExprFwd(ctor, objPair.env, JSType.topFunction());
                JSType ctorType = ctorPair.type;
                FunctionType ctorFunType = ctorType.getFunType();
                if (!ctorType.isSubtypeOf(JSType.topFunction()) || !ctorFunType.isConstructor()) {
                    this.warnInvalidOperand(ctor, 52, "a constructor function", ctorType);
                }
                if (ctorFunType == null || !ctorFunType.isConstructor() || !specializedType.isTruthy() && !specializedType.isFalsy()) {
                    ctorPair.type = JSType.BOOLEAN;
                    return ctorPair;
                }
                JSType instanceType = ctorFunType.getTypeOfThis();
                objPair = this.analyzeExprFwd(obj, inEnv, JSType.TOP, specializedType.isTruthy() ? objPair.type.specialize(instanceType) : objPair.type.removeType(instanceType));
                ctorPair = this.analyzeExprFwd(ctor, objPair.env, JSType.topFunction());
                ctorPair.type = JSType.BOOLEAN;
                return ctorPair;
            }
            case 21: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.NUM_OR_STR);
                EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.NUM_OR_STR);
                JSType lhsType = lhsPair.type;
                JSType rhsType = rhsPair.type;
                if (!lhsType.isSubtypeOf(JSType.NUM_OR_STR)) {
                    this.warnInvalidOperand(lhs, expr.getType(), JSType.NUM_OR_STR, lhsType);
                }
                if (!rhsType.isSubtypeOf(JSType.NUM_OR_STR)) {
                    this.warnInvalidOperand(rhs, expr.getType(), JSType.NUM_OR_STR, rhsType);
                }
                return new EnvTypePair(rhsPair.env, JSType.plus(lhsType, rhsType));
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.NUMBER);
                EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.NUMBER);
                if (!lhsPair.type.isSubtypeOf(JSType.NUMBER)) {
                    this.warnInvalidOperand(lhs, expr.getType(), JSType.NUMBER, lhsPair.type);
                }
                if (!rhsPair.type.isSubtypeOf(JSType.NUMBER)) {
                    this.warnInvalidOperand(rhs, expr.getType(), JSType.NUMBER, rhsPair.type);
                }
                rhsPair.type = JSType.NUMBER;
                return rhsPair;
            }
            case 86: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                LValueResult lvalue = this.analyzeLValueFwd(lhs, inEnv, requiredType);
                JSType declType = lvalue.declType;
                EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lvalue.env, requiredType, specializedType);
                JSType rhsType = rhsPair.type;
                if (declType != null && !rhsType.isSubtypeOf(declType)) {
                    this.warnings.add(JSError.make(expr, MISTYPED_ASSIGN_RHS, declType.toString(), rhsType.toString()));
                    rhsType = declType;
                }
                return new EnvTypePair(NewTypeInference.updateLvalueTypeInEnv(rhsPair.env, lhs, lvalue.ptr, rhsType), rhsType);
            }
            case 93: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                JSType lhsReqType = NewTypeInference.specializeWithCorrection(requiredType, JSType.NUM_OR_STR);
                LValueResult lvalue = this.analyzeLValueFwd(lhs, inEnv, lhsReqType);
                JSType lhsType = lvalue.type;
                if (!lhsType.isSubtypeOf(JSType.NUM_OR_STR)) {
                    this.warnInvalidOperand(lhs, 93, JSType.NUM_OR_STR, lhsType);
                }
                JSType rhsReqType = lhsType.equals(JSType.NUMBER) ? JSType.NUMBER : JSType.NUM_OR_STR;
                EnvTypePair pair = this.analyzeExprFwd(rhs, lvalue.env, rhsReqType);
                if (!pair.type.isSubtypeOf(rhsReqType)) {
                    this.warnInvalidOperand(rhs, 93, rhsReqType, pair.type);
                }
                return pair;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                LValueResult lvalue = this.analyzeLValueFwd(lhs, inEnv, JSType.NUMBER);
                JSType lhsType = lvalue.type;
                if (!lhsType.isSubtypeOf(JSType.NUMBER)) {
                    this.warnInvalidOperand(lhs, expr.getType(), JSType.NUMBER, lhsType);
                }
                EnvTypePair pair = this.analyzeExprFwd(rhs, lvalue.env, JSType.NUMBER);
                if (!pair.type.isSubtypeOf(JSType.NUMBER)) {
                    this.warnInvalidOperand(rhs, expr.getType(), JSType.NUMBER, pair.type);
                }
                return new EnvTypePair(NewTypeInference.updateLvalueTypeInEnv(pair.env, lhs, lvalue.ptr, JSType.NUMBER), JSType.NUMBER);
            }
            case 45: 
            case 46: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
                EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
                if (exprKind == 45 && specializedType.isTruthy() || exprKind == 46 && specializedType.isFalsy()) {
                    JSType meetType = JSType.meet(lhsPair.type, rhsPair.type);
                    lhsPair = this.analyzeExprFwd(lhs, rhsPair.env, JSType.TOP, meetType);
                    rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.TOP, meetType);
                } else if (exprKind == 45 && specializedType.isFalsy() || exprKind == 46 && specializedType.isTruthy()) {
                    JSType lhsType = lhsPair.type;
                    JSType rhsType = rhsPair.type;
                    if (lhsType.equals(JSType.NULL) || lhsType.equals(JSType.UNDEFINED)) {
                        rhsType = rhsType.removeType(lhsType);
                    } else if (rhsType.equals(JSType.NULL) || rhsType.equals(JSType.UNDEFINED)) {
                        lhsType = lhsType.removeType(rhsType);
                    }
                    lhsPair = this.analyzeExprFwd(lhs, rhsPair.env, JSType.TOP, lhsType);
                    rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.TOP, rhsType);
                }
                rhsPair.type = JSType.BOOLEAN;
                return rhsPair;
            }
            case 12: 
            case 13: {
                return this.analyzeNonStrictComparisonFwd(expr, inEnv, requiredType, specializedType);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
                EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
                if (lhsPair.type.isScalar() && rhsPair.type.isUnknown()) {
                    rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, lhsPair.type);
                } else if (lhsPair.type.isUnknown() && rhsPair.type.isScalar()) {
                    lhsPair = this.analyzeExprFwd(lhs, inEnv, rhsPair.type);
                    rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, rhsPair.type);
                } else if (lhs.isVar() && lhsPair.type.isUnknown() && rhs.isVar() && rhsPair.type.isUnknown()) {
                    TypeEnv env = NewTypeInference.envPutType(rhsPair.env, lhs.getQualifiedName(), JSType.TOP_SCALAR);
                    env = NewTypeInference.envPutType(rhsPair.env, rhs.getQualifiedName(), JSType.TOP_SCALAR);
                    return new EnvTypePair(env, JSType.BOOLEAN);
                }
                JSType lhsType = lhsPair.type;
                JSType rhsType = rhsPair.type;
                if (!(lhsType.isSubtypeOf(JSType.TOP_SCALAR) && rhsType.isSubtypeOf(JSType.TOP_SCALAR) && JSType.areCompatibleScalarTypes(lhsType, rhsType))) {
                    this.warnInvalidOperand(expr, exprKind, "matching scalar types", String.valueOf(lhsType.toString()) + ", " + rhsType.toString());
                }
                rhsPair.type = JSType.BOOLEAN;
                return rhsPair;
            }
            case 33: {
                Preconditions.checkState((!NodeUtil.isAssignmentOp(expr.getParent()) || !NodeUtil.isLValue(expr) ? 1 : 0) != 0);
                return this.analyzePropAccessFwd(expr.getFirstChild(), expr.getLastChild().getString(), inEnv, requiredType, specializedType);
            }
            case 98: {
                Node cond = expr.getFirstChild();
                Node thenBranch = cond.getNext();
                Node elseBranch = thenBranch.getNext();
                TypeEnv trueEnv = this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.TOP, (JSType)JSType.TRUE_TYPE).env;
                TypeEnv falseEnv = this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.TOP, (JSType)JSType.FALSE_TYPE).env;
                EnvTypePair thenPair = this.analyzeExprFwd(thenBranch, trueEnv, requiredType, specializedType);
                EnvTypePair elsePair = this.analyzeExprFwd(elseBranch, falseEnv, requiredType, specializedType);
                return EnvTypePair.join(thenPair, elsePair);
            }
            case 30: 
            case 37: {
                String calleeName;
                FunctionType funType;
                Node callee = expr.getFirstChild();
                EnvTypePair calleePair = this.analyzeExprFwd(callee, inEnv, JSType.topFunction());
                JSType calleeType = calleePair.type;
                if (!calleeType.isSubtypeOf(JSType.topFunction())) {
                    this.warnings.add(JSError.make(expr, TypeCheck.NOT_CALLABLE, calleeType.toString()));
                }
                if ((funType = calleeType.getFunType()) == null || funType.isTopFunction()) {
                    return new EnvTypePair(inEnv, requiredType);
                }
                if (funType.isLoose()) {
                    return this.analyzeLooseCallNodeFwd(expr, inEnv, requiredType);
                }
                if (expr.isCall() && funType.isConstructor()) {
                    this.warnings.add(JSError.make(expr, TypeCheck.CONSTRUCTOR_NOT_CALLABLE, funType.toString()));
                    return new EnvTypePair(inEnv, requiredType);
                }
                if (expr.isNew() && !funType.isConstructor()) {
                    this.warnings.add(JSError.make(expr, TypeCheck.NOT_A_CONSTRUCTOR, funType.toString()));
                    return new EnvTypePair(inEnv, requiredType);
                }
                int maxArity = funType.getMaxArity();
                int minArity = funType.getMinArity();
                int numArgs = expr.getChildCount() - 1;
                if (numArgs < minArity || numArgs > maxArity) {
                    this.warnings.add(JSError.make(expr, TypeCheck.WRONG_ARGUMENT_COUNT, "", Integer.toString(numArgs), Integer.toString(minArity), " and at most " + maxArity));
                }
                ArrayList argTypes = Lists.newArrayList();
                TypeEnv tmpEnv = inEnv;
                int i = 0;
                while (i < numArgs) {
                    JSType formalType;
                    JSType jSType = formalType = i < maxArity ? funType.getFormalType(i) : JSType.TOP;
                    if (formalType.isBottom()) {
                        this.warnings.add(JSError.make(expr, CALL_FUNCTION_WITH_BOTTOM_FORMAL, Integer.toString(i)));
                        formalType = JSType.TOP;
                    }
                    Node arg = expr.getChildAtIndex(i + 1);
                    EnvTypePair pair = this.analyzeExprFwd(arg, tmpEnv, formalType);
                    if (!pair.type.isSubtypeOf(formalType)) {
                        this.warnings.add(JSError.make(arg, INVALID_ARGUMENT_TYPE, Integer.toString(i + 1), "", formalType.toString(), pair.type.toString()));
                        pair.type = JSType.UNKNOWN;
                    }
                    if (i < maxArity) {
                        Preconditions.checkState((!pair.type.equals(JSType.topFunction()) ? 1 : 0) != 0);
                        argTypes.add(pair.type);
                    }
                    tmpEnv = pair.env;
                    ++i;
                }
                JSType retType = funType.getReturnType();
                if (callee.isName() && this.currentScope.isKnownFunction(calleeName = callee.getQualifiedName())) {
                    if (this.currentScope.isLocalFunDef(calleeName)) {
                        this.collectTypesForFreeVarsFwd(callee, tmpEnv);
                    } else {
                        DeferredCheck dc;
                        JSType expectedRetType = requiredType;
                        NewTypeInference.println("Updating deferred check with ret: ", expectedRetType, " and args: ", argTypes);
                        if (expr.isCall()) {
                            dc = this.deferredChecks.get(expr);
                            dc.updateReturn(expectedRetType);
                        } else {
                            dc = new DeferredCheck(expr, this.currentScope, this.currentScope.getScope(calleeName));
                            dc.updateReturn(JSType.TOP);
                            this.deferredChecks.put(expr, dc);
                        }
                        dc.updateArgTypes(argTypes);
                    }
                }
                return new EnvTypePair(tmpEnv, retType);
            }
            case 85: {
                return this.analyzeExprFwd(expr.getLastChild(), this.analyzeExprFwd((Node)expr.getFirstChild(), (TypeEnv)inEnv).env, requiredType, specializedType);
            }
            case 26: {
                EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv, JSType.TOP, specializedType.negate());
                pair.type = pair.type.negate().toBoolean();
                return pair;
            }
            case 35: {
                Node receiver = expr.getFirstChild();
                Node index = expr.getLastChild();
                if (index.isString()) {
                    return this.analyzePropAccessFwd(receiver, index.getString(), inEnv, requiredType, specializedType);
                }
                EnvTypePair pair = this.analyzeExprFwd(index, inEnv);
                pair = this.analyzeExprFwd(receiver, pair.env, JSType.TOP_OBJECT);
                pair.type = requiredType;
                return pair;
            }
            case 122: {
                EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                pair.type = JSType.UNDEFINED;
                return pair;
            }
            case 51: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair pair = this.analyzeExprFwd(lhs, inEnv, JSType.NUM_OR_STR);
                if (!pair.type.isSubtypeOf(JSType.NUM_OR_STR)) {
                    this.warnInvalidOperand(lhs, 51, JSType.NUM_OR_STR, pair.type);
                }
                pair = this.analyzeExprFwd(rhs, pair.env, JSType.TOP_OBJECT);
                if (!pair.type.isSubtypeOf(JSType.TOP_OBJECT)) {
                    this.warnInvalidOperand(rhs, 51, "Object", pair.type);
                    pair.type = JSType.BOOLEAN;
                    return pair;
                }
                JSType resultType = JSType.BOOLEAN;
                if (lhs.isString()) {
                    String pname = lhs.getString();
                    if (specializedType.isTruthy()) {
                        pair = this.analyzeExprFwd(rhs, inEnv, JSType.TOP_OBJECT, JSType.TOP_OBJECT.withPropertyRequired(pname));
                        resultType = JSType.TRUE_TYPE;
                    } else if (specializedType.isFalsy()) {
                        pair = this.analyzeExprFwd(rhs, inEnv, JSType.TOP_OBJECT);
                        pair = this.analyzeExprFwd(rhs, inEnv, JSType.TOP_OBJECT, pair.type.withoutProperty(pname));
                        resultType = JSType.FALSE_TYPE;
                    }
                }
                pair.type = resultType;
                return pair;
            }
            case 31: {
                EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 118: {
                Node vdecl = expr.getFirstChild();
                String name = vdecl.getQualifiedName();
                Node rhs = vdecl.getFirstChild();
                TypeEnv env = inEnv;
                if (rhs != null) {
                    env = this.analyzeExprFwd((Node)rhs, (TypeEnv)inEnv).env;
                }
                return new EnvTypePair(NewTypeInference.envPutType(env, name, JSType.STRING), JSType.STRING);
            }
            case 47: {
                return new EnvTypePair(inEnv, this.regexpType);
            }
            case 63: {
                TypeEnv env = inEnv;
                Node arrayElm = expr.getFirstChild();
                while (arrayElm != null) {
                    env = this.analyzeExprFwd((Node)arrayElm, (TypeEnv)env).env;
                    arrayElm = arrayElm.getNext();
                }
                return new EnvTypePair(env, this.arrayType);
            }
        }
        throw new RuntimeException("Unhandled expression type: " + Token.name(expr.getType()));
    }

    private EnvTypePair analyzeNonStrictComparisonFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        int tokenType = expr.getType();
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (tokenType == 12 && specializedType.isTruthy() || tokenType == 13 && specializedType.isFalsy()) {
            if (lhsType.isNullOrUndef()) {
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.TOP, JSType.NULL_OR_UNDEF);
            } else if (rhsType.isNullOrUndef()) {
                lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.TOP, JSType.NULL_OR_UNDEF);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            } else if (!JSType.NULL_OR_UNDEF.isSubtypeOf(lhsType)) {
                rhsType = rhsType.removeType(JSType.NULL).removeType(JSType.UNDEFINED);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.TOP, rhsType);
            } else if (!JSType.NULL_OR_UNDEF.isSubtypeOf(rhsType)) {
                lhsType = lhsType.removeType(JSType.NULL).removeType(JSType.UNDEFINED);
                lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.TOP, lhsType);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            }
        } else if (tokenType == 12 && specializedType.isFalsy() || tokenType == 13 && specializedType.isTruthy()) {
            if (lhsType.isNullOrUndef()) {
                rhsType = rhsType.removeType(JSType.NULL).removeType(JSType.UNDEFINED);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.TOP, rhsType);
            } else if (rhsType.isNullOrUndef()) {
                lhsType = lhsType.removeType(JSType.NULL).removeType(JSType.UNDEFINED);
                lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.TOP, lhsType);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            }
        }
        rhsPair.type = JSType.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzePropAccessFwd(Node receiver, String pname, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        JSType recvSpecType;
        JSType recvReqType;
        Node propAccessNode = receiver.getParent();
        JSType objWithProp = JSType.TOP_OBJECT.withProperty(pname, requiredType);
        if (specializedType.isTruthy() || specializedType.isFalsy()) {
            recvReqType = JSType.TOP;
            recvSpecType = objWithProp;
        } else {
            recvReqType = recvSpecType = objWithProp;
        }
        EnvTypePair pair = this.analyzeExprFwd(receiver, inEnv, recvReqType, recvSpecType);
        JSType recvType = pair.type;
        if (specializedType.isTruthy() || specializedType.isFalsy() ? JSType.BOTTOM.equals(JSType.meet(recvType, JSType.TOP_OBJECT)) : !recvType.isSubtypeOf(JSType.TOP_OBJECT)) {
            this.warnings.add(JSError.make(receiver, PROPERTY_ACCESS_ON_NONOBJECT, pname, recvType.toString()));
            return new EnvTypePair(pair.env, requiredType);
        }
        JSType resultType = recvType.getProp(pname);
        if (!specializedType.isTruthy() && !specializedType.isFalsy()) {
            if (!recvType.mayHaveProp(pname)) {
                this.warnings.add(JSError.make(propAccessNode, TypeCheck.INEXISTENT_PROPERTY, pname, recvType.toString()));
                resultType = JSType.UNKNOWN;
            } else if (!recvType.hasProp(pname)) {
                this.warnings.add(JSError.make(propAccessNode, POSSIBLY_INEXISTENT_PROPERTY, pname, recvType.toString()));
            }
        }
        return new EnvTypePair(pair.env, resultType);
    }

    private static TypeEnv updateLvalueTypeInEnv(TypeEnv env, Node lvalue, String qname, JSType type) {
        if (lvalue.isName()) {
            return NewTypeInference.envPutType(env, lvalue.getQualifiedName(), type);
        }
        Preconditions.checkState((lvalue.isGetProp() || lvalue.isGetElem() ? 1 : 0) != 0);
        if (qname != null) {
            String objName = TypeUtils.getQnameRoot(qname);
            String props = TypeUtils.getPropPath(qname);
            JSType objType = NewTypeInference.envGetType(env, objName);
            env = NewTypeInference.envPutType(env, objName, objType.withProperty(props, type));
        }
        return env;
    }

    private void collectTypesForFreeVarsFwd(Node callee, TypeEnv env) {
        GlobalTypeInfo.Scope calleeScope = this.currentScope.getScope(callee.getQualifiedName());
        for (String freeVar : calleeScope.getOuterVars()) {
            FunctionType summary = this.summaries.get(calleeScope).getFunType();
            JSType outerType = NewTypeInference.envGetType(env, freeVar);
            JSType innerType = summary.getOuterVarPrecondition(freeVar);
            if (outerType == null || !JSType.meet(outerType, innerType).isBottom()) continue;
            this.warnings.add(JSError.make(callee, CROSS_SCOPE_GOTCHA, freeVar, outerType.toString(), innerType.toString()));
        }
    }

    private TypeEnv collectTypesForFreeVarsBwd(Node callee, TypeEnv env) {
        GlobalTypeInfo.Scope calleeScope = this.currentScope.getScope(callee.getQualifiedName());
        Iterator<String> iterator = calleeScope.getOuterVars().iterator();
        while (iterator.hasNext()) {
            String freeVar;
            JSType declType = this.currentScope.getDeclaredTypeOf(freeVar = iterator.next());
            env = NewTypeInference.envPutType(env, freeVar, declType != null ? declType : JSType.UNKNOWN);
        }
        return env;
    }

    private EnvTypePair analyzeLooseCallNodeFwd(Node callNode, TypeEnv inEnv, JSType retType) {
        Preconditions.checkArgument((boolean)callNode.isCall());
        Node callee = callNode.getFirstChild();
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        TypeEnv tmpEnv = inEnv;
        Node arg = callee.getNext();
        while (arg != null) {
            EnvTypePair pair = this.analyzeExprFwd(arg, tmpEnv);
            tmpEnv = pair.env;
            builder.addReqFormal(pair.type);
            arg = arg.getNext();
        }
        JSType looseRetType = retType.isTop() ? JSType.BOTTOM : retType;
        JSType looseFunctionType = builder.addRetType(looseRetType).addLoose().buildType();
        EnvTypePair calleePair = this.analyzeExprFwd(callee, tmpEnv, JSType.topFunction(), looseFunctionType);
        return new EnvTypePair(calleePair.env, retType.isTop() ? JSType.UNKNOWN : retType);
    }

    private EnvTypePair analyzeLooseCallNodeBwd(Node callNode, TypeEnv outEnv, JSType retType) {
        Preconditions.checkArgument((boolean)callNode.isCall());
        Preconditions.checkNotNull((Object)retType);
        Node callee = callNode.getFirstChild();
        TypeEnv tmpEnv = outEnv;
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int i = callNode.getChildCount() - 2;
        while (i >= 0) {
            Node arg = callNode.getChildAtIndex(i + 1);
            tmpEnv = this.analyzeExprBwd((Node)arg, (TypeEnv)tmpEnv).env;
            builder.addReqFormal(JSType.BOTTOM);
            --i;
        }
        JSType looseRetType = retType.isTop() ? JSType.BOTTOM : retType;
        JSType looseFunctionType = builder.addRetType(looseRetType).addLoose().buildType();
        looseFunctionType.getFunType().checkValid();
        NewTypeInference.println("loose function type is ", looseFunctionType);
        EnvTypePair calleePair = this.analyzeExprBwd(callee, tmpEnv, looseFunctionType);
        return new EnvTypePair(calleePair.env, retType.isTop() ? JSType.UNKNOWN : retType);
    }

    private EnvTypePair analyzeExprBwd(Node expr, TypeEnv outEnv) {
        return this.analyzeExprBwd(expr, outEnv, JSType.TOP);
    }

    private EnvTypePair analyzeExprBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Preconditions.checkArgument((requiredType != null && !requiredType.isBottom() ? 1 : 0) != 0);
        int exprKind = expr.getType();
        switch (exprKind) {
            case 124: {
                return new EnvTypePair(outEnv, JSType.UNKNOWN);
            }
            case 105: {
                String fnName = this.symbolTable.getFunInternalName(expr);
                return new EnvTypePair(outEnv, NewTypeInference.envGetType(outEnv, fnName));
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return new EnvTypePair(outEnv, NewTypeInference.scalarValueToType(exprKind));
            }
            case 64: {
                JSType result = JSType.TOP_OBJECT;
                TypeEnv env = outEnv;
                Node key = expr.getLastChild();
                while (key != null) {
                    String pname = NodeUtil.getObjectLitKeyName(key);
                    JSType reqPtype = requiredType.mayHaveProp(pname) ? requiredType.getProp(pname) : JSType.TOP;
                    EnvTypePair pair = this.analyzeExprBwd(key.getLastChild(), env, reqPtype);
                    result = result.withProperty(pname, pair.type);
                    env = pair.env;
                    key = expr.getChildBefore(key);
                }
                return new EnvTypePair(env, result);
            }
            case 42: {
                if (!this.currentScope.hasThis()) {
                    return new EnvTypePair(outEnv, JSType.UNKNOWN);
                }
                JSType thisType = this.currentScope.getDeclaredTypeOf("this");
                return new EnvTypePair(outEnv, thisType);
            }
            case 38: {
                String varName = expr.getQualifiedName();
                if (varName.equals("undefined")) {
                    return new EnvTypePair(outEnv, JSType.UNDEFINED);
                }
                JSType inferredType = NewTypeInference.envGetType(outEnv, varName);
                if (inferredType == null) {
                    inferredType = JSType.TOP;
                }
                JSType preciseType = inferredType.specialize(requiredType);
                if (this.currentScope.isUndeclaredFormal(varName) && requiredType.hasNonScalar()) {
                    preciseType = preciseType.withLoose();
                }
                if (!preciseType.isInhabitable()) {
                    JSType declType = this.currentScope.getDeclaredTypeOf(varName);
                    preciseType = declType == null ? requiredType : declType;
                }
                return EnvTypePair.addBinding(outEnv, varName, preciseType);
            }
            case 27: 
            case 28: 
            case 29: 
            case 102: 
            case 103: {
                return this.analyzeExprBwd(expr.getFirstChild(), outEnv, JSType.NUMBER);
            }
            case 32: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.STRING;
                return pair;
            }
            case 52: {
                TypeEnv env = this.analyzeExprBwd((Node)expr.getLastChild(), (TypeEnv)outEnv, (JSType)JSType.topFunction()).env;
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), env);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                TypeEnv rhsEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)outEnv, (JSType)JSType.NUMBER).env;
                EnvTypePair pair = this.analyzeExprBwd(lhs, rhsEnv, JSType.NUMBER);
                pair.type = JSType.NUMBER;
                return pair;
            }
            case 21: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv, JSType.NUM_OR_STR);
                EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env, JSType.NUM_OR_STR);
                lhsPair.type = JSType.plus(lhsPair.type, rhsPair.type);
                return lhsPair;
            }
            case 100: 
            case 101: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv);
                EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env);
                lhsPair.type = JSType.join(rhsPair.type, lhsPair.type);
                return lhsPair;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                TypeEnv rhsEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)outEnv).env;
                EnvTypePair pair = this.analyzeExprBwd(lhs, rhsEnv);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv);
                EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env);
                JSType meetType = JSType.meet(lhsPair.type, rhsPair.type);
                if (meetType.isBottom()) {
                    lhsPair.type = JSType.BOOLEAN;
                    return lhsPair;
                }
                rhsPair = this.analyzeExprBwd(rhs, outEnv, meetType);
                lhsPair = this.analyzeExprBwd(lhs, rhsPair.env, meetType);
                lhsPair.type = JSType.BOOLEAN;
                return lhsPair;
            }
            case 86: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                LValueResult lvalue = this.analyzeLValueBwd(lhs, outEnv, requiredType, true);
                TypeEnv slicedEnv = lvalue.env;
                JSType rhsReqType = NewTypeInference.specializeWithCorrection(lvalue.type, requiredType);
                EnvTypePair pair = this.analyzeExprBwd(rhs, slicedEnv, rhsReqType);
                pair.env = this.analyzeLValueBwd((Node)lhs, (TypeEnv)pair.env, (JSType)requiredType, (boolean)true).env;
                return pair;
            }
            case 93: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                JSType lhsReqType = NewTypeInference.specializeWithCorrection(requiredType, JSType.NUM_OR_STR);
                LValueResult lvalue = this.analyzeLValueBwd(lhs, outEnv, lhsReqType, false);
                JSType rhsReqType = lvalue.type.equals(JSType.NUMBER) ? JSType.NUMBER : JSType.NUM_OR_STR;
                EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, rhsReqType);
                pair.env = this.analyzeLValueBwd((Node)lhs, (TypeEnv)pair.env, (JSType)lhsReqType, (boolean)false).env;
                return pair;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, JSType.NUMBER);
                LValueResult lvalue = this.analyzeLValueBwd(lhs, pair.env, JSType.NUMBER, false);
                return new EnvTypePair(lvalue.env, JSType.NUMBER);
            }
            case 33: {
                Preconditions.checkState((!NodeUtil.isAssignmentOp(expr.getParent()) || !NodeUtil.isLValue(expr) ? 1 : 0) != 0);
                return this.analyzePropAccessBwd(expr.getFirstChild(), expr.getLastChild().getString(), outEnv, requiredType);
            }
            case 98: {
                Node cond = expr.getFirstChild();
                Node thenBranch = cond.getNext();
                Node elseBranch = thenBranch.getNext();
                EnvTypePair thenPair = this.analyzeExprBwd(thenBranch, outEnv, requiredType);
                EnvTypePair elsePair = this.analyzeExprBwd(elseBranch, outEnv, requiredType);
                return this.analyzeExprBwd(cond, TypeEnv.join(thenPair.env, elsePair.env));
            }
            case 30: 
            case 37: {
                String calleeName;
                Node callee = expr.getFirstChild();
                JSType calleeTypeGeneral = this.analyzeExprBwd((Node)callee, (TypeEnv)outEnv, (JSType)JSType.topFunction()).type;
                FunctionType funType = calleeTypeGeneral.getFunType();
                if (funType == null) {
                    return new EnvTypePair(outEnv, requiredType);
                }
                if (funType.isLoose()) {
                    return this.analyzeLooseCallNodeBwd(expr, outEnv, requiredType);
                }
                if (expr.isCall() && funType.isConstructor() || expr.isNew() && !funType.isConstructor()) {
                    return new EnvTypePair(outEnv, requiredType);
                }
                if (funType.isTopFunction()) {
                    return new EnvTypePair(outEnv, requiredType);
                }
                int arity = funType.getMaxArity();
                TypeEnv tmpEnv = outEnv;
                int i = expr.getChildCount() - 2;
                while (i >= 0) {
                    JSType formalType;
                    JSType jSType = formalType = i < arity ? funType.getFormalType(i) : JSType.TOP;
                    if (formalType.isBottom()) {
                        formalType = JSType.TOP;
                    }
                    Node arg = expr.getChildAtIndex(i + 1);
                    tmpEnv = this.analyzeExprBwd((Node)arg, (TypeEnv)tmpEnv, (JSType)formalType).env;
                    --i;
                }
                if (callee.isName() && this.currentScope.isKnownFunction(calleeName = callee.getQualifiedName())) {
                    if (this.currentScope.isLocalFunDef(calleeName)) {
                        tmpEnv = this.collectTypesForFreeVarsBwd(callee, tmpEnv);
                    } else if (expr.isCall()) {
                        GlobalTypeInfo.Scope s = this.currentScope.getScope(calleeName);
                        JSType expectedRetType = JSType.TOP;
                        if (s.getDeclaredType().getReturnType() == null) {
                            expectedRetType = requiredType;
                        }
                        NewTypeInference.println("Putting deferred check of function: ", calleeName, " with ret: ", expectedRetType);
                        DeferredCheck dc = new DeferredCheck(expr, this.currentScope, s);
                        dc.updateReturn(expectedRetType);
                        this.deferredChecks.put(expr, dc);
                    }
                }
                return new EnvTypePair(tmpEnv, funType.getReturnType());
            }
            case 85: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getLastChild(), outEnv, requiredType);
                pair.env = this.analyzeExprBwd((Node)expr.getFirstChild(), (TypeEnv)pair.env).env;
                return pair;
            }
            case 26: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = pair.type.negate();
                return pair;
            }
            case 35: {
                Node receiver = expr.getFirstChild();
                Node index = expr.getLastChild();
                if (index.isString()) {
                    return this.analyzePropAccessBwd(receiver, index.getString(), outEnv, requiredType);
                }
                EnvTypePair pair = this.analyzeExprBwd(index, outEnv);
                pair = this.analyzeExprBwd(receiver, pair.env, JSType.TOP_OBJECT);
                pair.type = requiredType;
                return pair;
            }
            case 122: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.UNDEFINED;
                return pair;
            }
            case 51: {
                Node lhs = expr.getFirstChild();
                Node rhs = expr.getLastChild();
                EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, JSType.TOP_OBJECT);
                pair = this.analyzeExprBwd(lhs, pair.env, JSType.NUM_OR_STR);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 31: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 118: {
                Node vdecl = expr.getFirstChild();
                String name = vdecl.getQualifiedName();
                Node rhs = vdecl.getFirstChild();
                TypeEnv env = outEnv;
                if (rhs != null) {
                    env = this.analyzeExprBwd((Node)rhs, (TypeEnv)outEnv).env;
                }
                return new EnvTypePair(NewTypeInference.envPutType(env, name, JSType.UNKNOWN), JSType.UNKNOWN);
            }
            case 47: {
                return new EnvTypePair(outEnv, this.regexpType);
            }
            case 63: {
                TypeEnv env = outEnv;
                int i = expr.getChildCount() - 1;
                while (i >= 0) {
                    Node arrayElm = expr.getChildAtIndex(i);
                    env = this.analyzeExprBwd((Node)arrayElm, (TypeEnv)env).env;
                    --i;
                }
                return new EnvTypePair(env, this.arrayType);
            }
        }
        throw new RuntimeException("BWD: Unhandled expression type: " + Token.name(expr.getType()) + " with parent: " + expr.getParent());
    }

    private EnvTypePair analyzePropAccessBwd(Node receiver, String pname, TypeEnv outEnv, JSType requiredType) {
        JSType propAccessType;
        EnvTypePair pair = this.analyzeExprBwd(receiver, outEnv, JSType.TOP_OBJECT.withProperty(pname, requiredType));
        JSType receiverType = pair.type;
        pair.type = propAccessType = receiverType.mayHaveProp(pname) ? receiverType.getProp(pname) : requiredType;
        return pair;
    }

    private static JSType scalarValueToType(int token) {
        switch (token) {
            case 39: {
                return JSType.NUMBER;
            }
            case 40: {
                return JSType.STRING;
            }
            case 44: {
                return JSType.TRUE_TYPE;
            }
            case 43: {
                return JSType.FALSE_TYPE;
            }
            case 41: {
                return JSType.NULL;
            }
        }
        throw new RuntimeException("The token isn't a scalar value " + Token.name(token));
    }

    private void warnInvalidOperand(Node expr, int operatorType, Object expected, Object actual) {
        Preconditions.checkArgument((expected instanceof String || expected instanceof JSType ? 1 : 0) != 0);
        Preconditions.checkArgument((actual instanceof String || actual instanceof JSType ? 1 : 0) != 0);
        this.warnings.add(JSError.make(expr, INVALID_OPERAND_TYPE, Token.name(operatorType), expected.toString(), actual.toString()));
    }

    private static JSType envGetType(TypeEnv env, String qName) {
        if (TypeUtils.isIdentifier(qName)) {
            return env.getType(qName);
        }
        String objName = TypeUtils.getQnameRoot(qName);
        String props = TypeUtils.getPropPath(qName);
        return env.getType(objName).getProp(props);
    }

    private static TypeEnv envPutType(TypeEnv env, String varName, JSType type) {
        Preconditions.checkArgument((boolean)TypeUtils.isIdentifier(varName));
        JSType oldType = env.getType(varName);
        if (oldType != null && oldType.equals(type) && Objects.equal((Object)oldType.getLocation(), (Object)type.getLocation())) {
            return env;
        }
        return env.putType(varName, type);
    }

    private LValueResult analyzeLValueFwd(Node expr, TypeEnv inEnv, JSType type) {
        return this.analyzeLValueFwd(expr, inEnv, type, false);
    }

    private LValueResult analyzeLValueFwd(Node expr, TypeEnv inEnv, JSType type, boolean isRecursiveCall) {
        switch (expr.getType()) {
            case 42: {
                if (this.currentScope.hasThis()) {
                    return new LValueResult(inEnv, NewTypeInference.envGetType(inEnv, "this"), this.currentScope.getDeclaredTypeOf("this"), "this");
                }
                this.warnings.add(JSError.make(expr, CheckGlobalThis.GLOBAL_THIS, new String[0]));
                return new LValueResult(inEnv, JSType.UNKNOWN, null, null);
            }
            case 38: {
                String varName = expr.getQualifiedName();
                JSType varType = NewTypeInference.envGetType(inEnv, varName);
                return new LValueResult(inEnv, varType, this.currentScope.getDeclaredTypeOf(varName), varType.hasNonScalar() ? varName : null);
            }
            case 30: {
                EnvTypePair pair = this.analyzeExprFwd(expr, inEnv, type);
                return new LValueResult(pair.env, pair.type, null, null);
            }
            case 33: {
                Node obj = expr.getFirstChild();
                String pname = expr.getLastChild().getString();
                return this.analyzePropLValFwd(obj, pname, inEnv, type, isRecursiveCall);
            }
            case 35: {
                if (expr.getLastChild().isString()) {
                    Node obj = expr.getFirstChild();
                    String pname = expr.getLastChild().getString();
                    return this.analyzePropLValFwd(obj, pname, inEnv, type, isRecursiveCall);
                }
                return new LValueResult(inEnv, type, null, null);
            }
            case 64: {
                EnvTypePair etPair = this.analyzeExprFwd(expr, inEnv, type);
                return new LValueResult(etPair.env, etPair.type, null, null);
            }
        }
        throw new RuntimeException("analyzeLValueFwd: unknown lhs expression @ node " + expr);
    }

    private LValueResult analyzePropLValFwd(Node obj, String pname, TypeEnv inEnv, JSType type, boolean isRecursiveCall) {
        LValueResult lvalue = this.analyzeLValueFwd(obj, inEnv, JSType.TOP_OBJECT.withProperty(pname, type), true);
        if (!lvalue.type.isSubtypeOf(JSType.TOP_OBJECT)) {
            this.warnings.add(JSError.make(obj, PROPERTY_ACCESS_ON_NONOBJECT, pname, lvalue.type.toString()));
            return new LValueResult(lvalue.env, type, null, null);
        }
        if (isRecursiveCall && !lvalue.type.isUnknown() && lvalue.type.isSubtypeOf(JSType.TOP_OBJECT) && !lvalue.type.mayHaveProp(pname)) {
            this.warnings.add(JSError.make(obj, TypeCheck.INEXISTENT_PROPERTY, pname, lvalue.type.toString()));
            return new LValueResult(lvalue.env, type, null, null);
        }
        return new LValueResult(lvalue.env, lvalue.type.getProp(pname), lvalue.type.getDeclaredProp(pname), lvalue.ptr == null ? null : String.valueOf(lvalue.ptr) + "." + pname);
    }

    private LValueResult analyzeLValueBwd(Node expr, TypeEnv outEnv, JSType type, boolean doSlicing) {
        switch (expr.getType()) {
            case 38: 
            case 42: {
                EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
                String name = expr.getQualifiedName();
                JSType declType = this.currentScope.getDeclaredTypeOf(name);
                if (doSlicing) {
                    pair.env = NewTypeInference.envPutType(pair.env, name, declType != null ? declType : JSType.UNKNOWN);
                }
                return new LValueResult(pair.env, pair.type, declType, pair.type.hasNonScalar() ? name : null);
            }
            case 30: {
                EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
                return new LValueResult(pair.env, pair.type, null, null);
            }
            case 33: {
                Node obj = expr.getFirstChild();
                String pname = expr.getLastChild().getString();
                return this.analyzePropLValBwd(obj, pname, outEnv, type, doSlicing);
            }
            case 35: {
                if (expr.getLastChild().isString()) {
                    Node obj = expr.getFirstChild();
                    String pname = expr.getLastChild().getString();
                    return this.analyzePropLValBwd(obj, pname, outEnv, type, doSlicing);
                }
                return new LValueResult(outEnv, type, null, null);
            }
            case 64: {
                EnvTypePair etPair = this.analyzeExprBwd(expr, outEnv, type);
                return new LValueResult(etPair.env, etPair.type, null, null);
            }
        }
        throw new RuntimeException("analyzeLValueBwd: unknown lhs expression @ node " + expr);
    }

    private LValueResult analyzePropLValBwd(Node obj, String pname, TypeEnv outEnv, JSType type, boolean doSlicing) {
        LValueResult lvalue = this.analyzeLValueBwd(obj, outEnv, JSType.TOP_OBJECT.withProperty(pname, type), false);
        if (lvalue.ptr != null) {
            lvalue.ptr = String.valueOf(lvalue.ptr) + "." + pname;
            if (doSlicing) {
                String objName = TypeUtils.getQnameRoot(lvalue.ptr);
                String props = TypeUtils.getPropPath(lvalue.ptr);
                JSType objType = NewTypeInference.envGetType(lvalue.env, objName);
                JSType propDeclType = lvalue.type.getDeclaredProp(pname);
                JSType slicedObjType = propDeclType == null ? objType.withoutProperty(props) : objType.withDeclaredProperty(props, propDeclType);
                lvalue.env = NewTypeInference.envPutType(lvalue.env, objName, slicedObjType);
            }
        }
        if (lvalue.type.mayHaveProp(pname)) {
            lvalue.type = lvalue.type.getProp(pname);
        }
        return lvalue;
    }

    private static JSType specializeWithCorrection(JSType inferred, JSType required) {
        JSType specializedType = inferred.specialize(required);
        if (!specializedType.isInhabitable()) {
            return required;
        }
        return specializedType;
    }

    Collection<JSError> getWarnings() {
        HashSet allWarnings = Sets.newHashSet(this.warnings);
        allWarnings.addAll(this.symbolTable.getWarnings());
        return allWarnings;
    }

    TypeEnv getInitTypeEnv() {
        return this.getOutEnv((Node)this.cfg.getEntry().getValue());
    }

    TypeEnv getFinalTypeEnv() {
        Node n = (Node)this.cfg.getImplicitReturn().getValue();
        if (this.cfg.getInEdges(n).size() == 0) {
            TypeEnv e = new TypeEnv();
            return NewTypeInference.envPutType(e, RETVAL_ID, JSType.BOTTOM);
        }
        return this.getInEnv(n);
    }

    @VisibleForTesting
    JSType getFinalType(String varName) {
        return this.getFinalTypeEnv().getType(varName);
    }

    @VisibleForTesting
    JSType getFormalType(int argpos) {
        Preconditions.checkState((this.summaries.size() == 1 ? 1 : 0) != 0);
        return this.summaries.values().iterator().next().getFunType().getFormalType(argpos);
    }

    @VisibleForTesting
    JSType getReturnType() {
        Preconditions.checkState((this.summaries.size() == 1 ? 1 : 0) != 0);
        return this.summaries.values().iterator().next().getFunType().getReturnType();
    }

    @VisibleForTesting
    JSType getDeclaredType(String varName) {
        return this.currentScope.getDeclaredTypeOf(varName);
    }

    private static class DeferredCheck {
        final Node callSite;
        final GlobalTypeInfo.Scope callerScope;
        final GlobalTypeInfo.Scope calleeScope;
        JSType expectedRetType;
        List<JSType> argTypes;

        DeferredCheck(Node callSite, GlobalTypeInfo.Scope callerScope, GlobalTypeInfo.Scope calleeScope) {
            this.callSite = callSite;
            this.callerScope = callerScope;
            this.calleeScope = calleeScope;
        }

        void updateReturn(JSType expectedRetType) {
            this.expectedRetType = this.expectedRetType != null ? JSType.meet(this.expectedRetType, expectedRetType) : expectedRetType;
        }

        void updateArgTypes(List<JSType> argTypes) {
            this.argTypes = argTypes;
        }

        private void runCheck(Map<GlobalTypeInfo.Scope, JSType> summaries, Collection<JSError> warnings) {
            FunctionType fnSummary = summaries.get(this.calleeScope).getFunType();
            NewTypeInference.println(new Object[]{"Running deferred check of function: ", this.calleeScope.getReadableName(), " with FunctionSummary of: ", fnSummary, " and callsite ret: ", this.expectedRetType, " args: ", this.argTypes});
            if (!fnSummary.getReturnType().isSubtypeOf(this.expectedRetType)) {
                warnings.add(JSError.make(this.callSite, INVALID_INFERRED_RETURN_TYPE, this.expectedRetType.toString(), fnSummary.getReturnType().toString()));
            }
            int i = 0;
            Node argNode = this.callSite.getFirstChild().getNext();
            for (JSType argType : this.argTypes) {
                JSType formalType = fnSummary.getFormalType(i);
                Preconditions.checkState((!formalType.equals(JSType.topFunction()) ? 1 : 0) != 0);
                if (argNode.isName() && this.callerScope.isKnownFunction(argNode.getQualifiedName())) {
                    String argName = argNode.getQualifiedName();
                    argType = summaries.get(this.callerScope.getScope(argName));
                }
                if (!argType.isSubtypeOf(formalType)) {
                    warnings.add(JSError.make(argNode, INVALID_ARGUMENT_TYPE, Integer.toString(i + 1), this.calleeScope.getReadableName(), formalType.toString(), argType.toString()));
                }
                ++i;
                argNode = argNode.getNext();
            }
        }

        public boolean equals(Object o) {
            Preconditions.checkArgument((boolean)(o instanceof DeferredCheck));
            DeferredCheck dc2 = (DeferredCheck)o;
            return this.callSite == dc2.callSite && this.callerScope == dc2.callerScope && this.calleeScope == dc2.calleeScope && Objects.equal((Object)this.expectedRetType, (Object)dc2.expectedRetType) && Objects.equal(this.argTypes, dc2.argTypes);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.callSite, this.callerScope, this.calleeScope, this.expectedRetType, this.argTypes});
        }
    }

    private static class EnvTypePair {
        TypeEnv env;
        JSType type;

        EnvTypePair(TypeEnv env, JSType type) {
            this.env = env;
            this.type = type;
        }

        static EnvTypePair addBinding(TypeEnv env, String varName, JSType type) {
            return new EnvTypePair(NewTypeInference.envPutType(env, varName, type), type);
        }

        static EnvTypePair join(EnvTypePair p1, EnvTypePair p2) {
            return new EnvTypePair(TypeEnv.join(p1.env, p2.env), JSType.join(p1.type, p2.type));
        }
    }

    class LValueResult {
        TypeEnv env;
        JSType type;
        JSType declType;
        String ptr;

        LValueResult(TypeEnv env, JSType type, JSType declType, String ptr) {
            this.env = env;
            this.type = type;
            this.declType = declType;
            this.ptr = ptr;
        }
    }

    static class TypeEnv {
        private final Map<String, JSType> typeMap = Maps.newHashMap();

        TypeEnv() {
        }

        JSType getType(String n) {
            Preconditions.checkArgument((boolean)TypeUtils.isIdentifier(n));
            return this.typeMap.get(n);
        }

        TypeEnv putType(String n, JSType t) {
            Preconditions.checkArgument((boolean)TypeUtils.isIdentifier(n));
            TypeEnv newEnv = new TypeEnv();
            newEnv.typeMap.putAll(this.typeMap);
            newEnv.typeMap.put(n, t);
            return newEnv;
        }

        static TypeEnv join(TypeEnv e1, TypeEnv e2) {
            JSType otherType;
            TypeEnv newEnv = new TypeEnv();
            for (String n : e1.typeMap.keySet()) {
                otherType = e2.getType(n);
                newEnv.typeMap.put(n, otherType == null ? e1.getType(n) : JSType.join(otherType, e1.getType(n)));
            }
            for (String n : e2.typeMap.keySet()) {
                otherType = e1.getType(n);
                newEnv.typeMap.put(n, otherType == null ? e2.getType(n) : JSType.join(otherType, e2.getType(n)));
            }
            return newEnv;
        }

        Multimap<String, String> getTaints() {
            HashMultimap taints = HashMultimap.create();
            for (Map.Entry<String, JSType> entry : this.typeMap.entrySet()) {
                String formal = entry.getValue().getLocation();
                if (formal == null) continue;
                taints.put((Object)formal, (Object)entry.getKey());
            }
            return taints;
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper(this.getClass());
            for (String key : this.typeMap.keySet()) {
                helper.add(key, (Object)this.getType(key));
            }
            return helper.toString();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TypeEnv)) {
                return false;
            }
            TypeEnv other = (TypeEnv)o;
            return this.typeMap.equals(other.typeMap);
        }

        public int hashCode() {
            return this.typeMap.hashCode();
        }
    }
}

