/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.Token;

public class ObjectPropertyStringPreprocess
implements CompilerPass {
    static final String OBJECT_PROPERTY_STRING = "goog.testing.ObjectPropertyString";
    public static final String EXTERN_OBJECT_PROPERTY_STRING = "JSCompiler_ObjectPropertyString";
    static final DiagnosticType INVALID_NUM_ARGUMENTS_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_NUM_ARGS", "goog.testing.ObjectPropertyString instantiated with \"{0}\" arguments, expected 2.");
    static final DiagnosticType QUALIFIED_NAME_EXPECTED_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_QUALIFIED_NAME_EXPECTED", "goog.testing.ObjectPropertyString instantiated with invalid argument, qualified name expected. Was \"{0}\".");
    static final DiagnosticType STRING_LITERAL_EXPECTED_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_STRING_LITERAL_EXPECTED", "goog.testing.ObjectPropertyString instantiated with invalid argument, string literal expected. Was \"{0}\".");
    private final AbstractCompiler compiler;

    ObjectPropertyStringPreprocess(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.addExternDeclaration(externs, IR.var(IR.name(EXTERN_OBJECT_PROPERTY_STRING)));
        NodeTraversal.traverse(this.compiler, root, new Callback());
    }

    private void addExternDeclaration(Node externs, Node declarationStmt) {
        Node script = externs.getLastChild();
        if (script == null || !script.isScript()) {
            script = IR.script();
            externs.addChildToBack(script);
        }
        script.addChildToBack(declarationStmt);
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (ObjectPropertyStringPreprocess.OBJECT_PROPERTY_STRING.equals(n.getQualifiedName())) {
                Node newName = IR.name(ObjectPropertyStringPreprocess.EXTERN_OBJECT_PROPERTY_STRING);
                newName.copyInformationFrom(n);
                parent.replaceChild(n, newName);
                ObjectPropertyStringPreprocess.this.compiler.reportCodeChange();
                return;
            }
            if (!n.isNew()) {
                return;
            }
            Node objectName = n.getFirstChild();
            if (!ObjectPropertyStringPreprocess.EXTERN_OBJECT_PROPERTY_STRING.equals(objectName.getQualifiedName())) {
                return;
            }
            if (n.getChildCount() != 3) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(n, INVALID_NUM_ARGUMENTS_ERROR, "" + n.getChildCount()));
                return;
            }
            Node firstArgument = objectName.getNext();
            if (!firstArgument.isQualifiedName()) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(firstArgument, QUALIFIED_NAME_EXPECTED_ERROR, Token.name(firstArgument.getType())));
                return;
            }
            Node secondArgument = firstArgument.getNext();
            if (!secondArgument.isString()) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(secondArgument, STRING_LITERAL_EXPECTED_ERROR, Token.name(secondArgument.getType())));
                return;
            }
            Node newFirstArgument = NodeUtil.newQualifiedNameNode(ObjectPropertyStringPreprocess.this.compiler.getCodingConvention(), ObjectPropertyStringPreprocess.this.compiler.getCodingConvention().getGlobalObject()).srcrefTree(firstArgument);
            Node newSecondArgument = NodeUtil.newQualifiedNameNode(ObjectPropertyStringPreprocess.this.compiler.getCodingConvention(), String.valueOf(firstArgument.getQualifiedName()) + "." + firstArgument.getNext().getString()).srcrefTree(secondArgument);
            n.replaceChild(firstArgument, newFirstArgument);
            n.replaceChild(secondArgument, newSecondArgument);
            ObjectPropertyStringPreprocess.this.compiler.reportCodeChange();
        }
    }
}

