/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.RecentChange;
import com.google.gwt.thirdparty.javascript.rhino.Node;

class PeepholeOptimizationsPass
implements CompilerPass {
    private AbstractCompiler compiler;
    private final AbstractPeepholeOptimization[] peepholeOptimizations;
    private boolean retraverseOnChange;
    private RecentChange handler;

    PeepholeOptimizationsPass(AbstractCompiler compiler, AbstractPeepholeOptimization ... optimizations) {
        this.compiler = compiler;
        this.peepholeOptimizations = optimizations;
        this.retraverseOnChange = true;
        this.handler = new RecentChange();
    }

    void setRetraverseOnChange(boolean retraverse) {
        this.retraverseOnChange = retraverse;
    }

    public AbstractCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.compiler.addChangeHandler(this.handler);
        this.beginTraversal();
        NodeTraversal.traverseChangedFunctions(this.compiler, new NodeTraversal.FunctionCallback(){

            @Override
            public void visit(AbstractCompiler compiler, Node root) {
                if (root.isFunction()) {
                    root = root.getLastChild();
                }
                do {
                    PeepholeOptimizationsPass.this.handler.reset();
                    NodeTraversal.traverse(compiler, root, new PeepCallback());
                } while (PeepholeOptimizationsPass.this.retraverseOnChange && PeepholeOptimizationsPass.this.handler.hasCodeChanged());
            }
        });
        this.endTraversal();
        this.compiler.removeChangeHandler(this.handler);
    }

    private void beginTraversal() {
        AbstractPeepholeOptimization[] abstractPeepholeOptimizationArray = this.peepholeOptimizations;
        int n = this.peepholeOptimizations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPeepholeOptimization optimization = abstractPeepholeOptimizationArray[n2];
            optimization.beginTraversal(this.compiler);
            ++n2;
        }
    }

    private void endTraversal() {
        AbstractPeepholeOptimization[] abstractPeepholeOptimizationArray = this.peepholeOptimizations;
        int n = this.peepholeOptimizations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPeepholeOptimization optimization = abstractPeepholeOptimizationArray[n2];
            optimization.endTraversal(this.compiler);
            ++n2;
        }
    }

    private class PeepCallback
    extends NodeTraversal.AbstractShallowCallback {
        private PeepCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node currentNode = n;
            boolean codeChanged = false;
            do {
                codeChanged = false;
                AbstractPeepholeOptimization[] abstractPeepholeOptimizationArray = PeepholeOptimizationsPass.this.peepholeOptimizations;
                int n2 = abstractPeepholeOptimizationArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    AbstractPeepholeOptimization optim = abstractPeepholeOptimizationArray[n3];
                    Node newNode = optim.optimizeSubtree(currentNode);
                    if (newNode != currentNode) {
                        codeChanged = true;
                        currentNode = newNode;
                    }
                    if (currentNode == null) {
                        return;
                    }
                    ++n3;
                }
            } while (codeChanged);
        }
    }
}

