/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.JSDocInfo;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class RemoveTryCatch
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<Node> tryNodesContainingReturnStatements;

    RemoveTryCatch(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.tryNodesContainingReturnStatements = new HashSet<Node>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new RemoveTryCatchCode());
    }

    private class RemoveTryCatchCode
    extends NodeTraversal.AbstractPostOrderCallback {
        private RemoveTryCatchCode() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block0 : switch (n.getType()) {
                case 77: {
                    Node block;
                    Node finallyBlock;
                    JSDocInfo info = n.getJSDocInfo();
                    if (info != null && info.shouldPreserveTry()) {
                        return;
                    }
                    Node tryBlock = n.getFirstChild();
                    Node catchBlock = tryBlock.getNext();
                    Node node = finallyBlock = catchBlock != null ? catchBlock.getNext() : null;
                    if (finallyBlock != null && RemoveTryCatch.this.tryNodesContainingReturnStatements.contains(n)) {
                        return;
                    }
                    if (catchBlock.hasOneChild()) {
                        NodeUtil.redeclareVarsInsideBranch(catchBlock);
                    }
                    n.detachChildren();
                    if (!NodeUtil.isStatementBlock(parent)) {
                        block = IR.block();
                        parent.replaceChild(n, block);
                        block.addChildToFront(tryBlock);
                    } else {
                        parent.replaceChild(n, tryBlock);
                        block = parent;
                    }
                    if (finallyBlock != null) {
                        block.addChildAfter(finallyBlock, tryBlock);
                    }
                    RemoveTryCatch.this.compiler.reportCodeChange();
                    break;
                }
                case 4: {
                    Node anc = parent;
                    while (anc != null && !anc.isFunction()) {
                        if (anc.isTry()) {
                            RemoveTryCatch.this.tryNodesContainingReturnStatements.add(anc);
                            break block0;
                        }
                        anc = anc.getParent();
                    }
                    break;
                }
            }
        }
    }
}

