/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.AnalyzeNameReferences;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NameReferenceGraph;
import com.google.gwt.thirdparty.javascript.jscomp.graph.GraphNode;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.logging.Logger;

class RemoveUnusedNames
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(RemoveUnusedNames.class.getName());
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;

    RemoveUnusedNames(AbstractCompiler compiler, boolean canModifyExterns) {
        this.compiler = compiler;
        this.canModifyExterns = canModifyExterns;
    }

    @Override
    public void process(Node externRoot, Node root) {
        AnalyzeNameReferences analyzer = new AnalyzeNameReferences(this.compiler);
        analyzer.process(externRoot, root);
        this.removeUnusedProperties(analyzer.getGraph());
    }

    private void removeUnusedProperties(NameReferenceGraph graph) {
        for (GraphNode graphNode : graph.getNodes()) {
            NameReferenceGraph.Name name = (NameReferenceGraph.Name)graphNode.getValue();
            AnalyzeNameReferences.NameInfo nameInfo = (AnalyzeNameReferences.NameInfo)graphNode.getAnnotation();
            if (nameInfo != null && nameInfo.isReferenced() || !this.canModifyExterns && name.isExtern()) continue;
            name.remove();
            this.compiler.reportCodeChange();
            logger.fine("Removed unused name" + name);
        }
    }
}

