/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.RenameVars2;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;

class ShadowVariables2
implements CompilerPass {
    private final Multimap<Node, String> scopeUpRefMap = HashMultimap.create();
    private final Multimap<Scope.Var, Node> varToNameUsage = HashMultimap.create();
    private final AbstractCompiler compiler;
    private final SortedSet<RenameVars2.Assignment> varsByFrequency;
    private final Map<String, RenameVars2.Assignment> assignments;
    private final Map<Node, String> oldPseudoNameMap;
    private final Map<Node, String> deltaPseudoNameMap;

    ShadowVariables2(AbstractCompiler compiler, Map<String, RenameVars2.Assignment> assignments, SortedSet<RenameVars2.Assignment> varsByFrequency, Map<Node, String> pseudoNameMap) {
        this.compiler = compiler;
        this.assignments = assignments;
        this.varsByFrequency = varsByFrequency;
        this.oldPseudoNameMap = pseudoNameMap;
        this.deltaPseudoNameMap = Maps.newLinkedHashMap();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherReferenceInfo());
        NodeTraversal.traverse(this.compiler, root, new DoShadowVariables());
        if (this.oldPseudoNameMap != null) {
            this.oldPseudoNameMap.putAll(this.deltaPseudoNameMap);
        }
    }

    private class DoShadowVariables
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private DoShadowVariables() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Scope s = t.getScope();
            if (!s.isLocal()) {
                return;
            }
            if (s.getParent().isGlobal()) {
                return;
            }
            Iterator<Scope.Var> vars = s.getVars();
            while (vars.hasNext()) {
                RenameVars2.Assignment bestShadow;
                Scope.Var var = vars.next();
                if (var.isBleedingFunction() || ShadowVariables2.this.compiler.getCodingConvention().isExported(var.name, s.isLocal()) || (bestShadow = this.findBestShadow(s)) == null) continue;
                RenameVars2.Assignment localAssignment = (RenameVars2.Assignment)ShadowVariables2.this.assignments.get(var.getName());
                if (bestShadow.count < localAssignment.count) continue;
                this.doShadow(localAssignment, bestShadow, var);
                if (ShadowVariables2.this.oldPseudoNameMap == null) continue;
                String targetPseudoName = (String)ShadowVariables2.this.oldPseudoNameMap.get(s.getVar((String)bestShadow.oldName).nameNode);
                for (Node use : ShadowVariables2.this.varToNameUsage.get((Object)var)) {
                    ShadowVariables2.this.deltaPseudoNameMap.put(use, targetPseudoName);
                }
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }

        private RenameVars2.Assignment findBestShadow(Scope curScope) {
            for (RenameVars2.Assignment assignment : ShadowVariables2.this.varsByFrequency) {
                if (!assignment.oldName.startsWith("L ") || ShadowVariables2.this.scopeUpRefMap.get((Object)curScope.getRootNode()).contains(assignment.oldName) || !curScope.isDeclared(assignment.oldName, true)) continue;
                return assignment;
            }
            return null;
        }

        private void doShadow(RenameVars2.Assignment original, RenameVars2.Assignment toShadow, Scope.Var var) {
            Scope s = var.getScope();
            Collection references = ShadowVariables2.this.varToNameUsage.get((Object)var);
            ShadowVariables2.this.varsByFrequency.remove(original);
            ShadowVariables2.this.varsByFrequency.remove(toShadow);
            original.count -= references.size();
            toShadow.count += references.size();
            ShadowVariables2.this.varsByFrequency.add(original);
            ShadowVariables2.this.varsByFrequency.add(toShadow);
            Scope.Var shadowed = s.getVar(toShadow.oldName);
            if (shadowed != null) {
                Scope curScope = s;
                while (curScope != shadowed.scope) {
                    ShadowVariables2.this.scopeUpRefMap.put((Object)curScope.getRootNode(), (Object)toShadow.oldName);
                    curScope = curScope.getParent();
                }
            }
            for (Node n : references) {
                n.setString(toShadow.oldName);
                Node cur = n;
                while (cur != s.getRootNode()) {
                    if (!(cur = cur.getParent()).isFunction()) continue;
                    ShadowVariables2.this.scopeUpRefMap.put((Object)cur, (Object)toShadow.oldName);
                }
            }
        }
    }

    private class GatherReferenceInfo
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherReferenceInfo() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            if (t.inGlobalScope()) {
                return;
            }
            Scope.Var var = t.getScope().getVar(n.getString());
            if (var == null) {
                return;
            }
            if (var.getScope().isGlobal()) {
                return;
            }
            if (var.getScope() != t.getScope()) {
                Scope s = t.getScope();
                while (s != var.getScope() && s.isLocal()) {
                    ShadowVariables2.this.scopeUpRefMap.put((Object)s.getRootNode(), (Object)var.name);
                    s = s.getParent();
                }
            }
            if (var.getScope() == t.getScope()) {
                ShadowVariables2.this.scopeUpRefMap.put((Object)t.getScopeRoot(), (Object)var.name);
            }
            ShadowVariables2.this.varToNameUsage.put((Object)var, (Object)n);
        }
    }
}

