/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.Node;

class SourceInformationAnnotator
extends NodeTraversal.AbstractPostOrderCallback {
    private final String sourceFile;
    private final boolean doSanityChecks;

    public SourceInformationAnnotator(String sourceFile, boolean doSanityChecks) {
        this.sourceFile = sourceFile;
        this.doSanityChecks = doSanityChecks;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.doSanityChecks && this.sourceFile != null) {
            Preconditions.checkState((boolean)this.sourceFile.equals(n.getSourceFileName()));
        }
        switch (n.getType()) {
            case 33: {
                Node propNode = n.getLastChild();
                this.setOriginalName(n, propNode.getString());
                break;
            }
            case 105: {
                String functionName = NodeUtil.getNearestFunctionName(n);
                if (functionName == null) break;
                this.setOriginalName(n, functionName);
                break;
            }
            case 38: {
                this.setOriginalName(n, n.getString());
                break;
            }
            case 64: {
                Node key = n.getFirstChild();
                while (key != null) {
                    if (!key.isQuotedString()) {
                        this.setOriginalName(key, key.getString());
                    }
                    key = key.getNext();
                }
                break;
            }
        }
    }

    void setOriginalName(Node n, String name) {
        if (!name.isEmpty() && n.getProp(40) == null) {
            n.putProp(40, name);
        }
    }
}

