/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.ControlFlowAnalysis;
import com.google.gwt.thirdparty.javascript.jscomp.ControlFlowGraph;
import com.google.gwt.thirdparty.javascript.jscomp.DataFlowAnalysis;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.MemoizedScopeCreator;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.jscomp.TypeInference;
import com.google.gwt.thirdparty.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Map;

class TypeInferencePass
implements CompilerPass {
    static final DiagnosticType DATAFLOW_ERROR = DiagnosticType.warning("JSC_INTERNAL_ERROR_DATAFLOW", "non-monotonic data-flow analysis");
    private final AbstractCompiler compiler;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final Scope topScope;
    private final MemoizedScopeCreator scopeCreator;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;

    TypeInferencePass(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, Scope topScope, MemoizedScopeCreator scopeCreator) {
        this.compiler = compiler;
        this.reverseInterpreter = reverseInterpreter;
        this.topScope = topScope;
        this.scopeCreator = scopeCreator;
        this.assertionFunctionsMap = Maps.newHashMap();
        for (CodingConvention.AssertionFunctionSpec assertionFunction : compiler.getCodingConvention().getAssertionFunctions()) {
            this.assertionFunctionsMap.put(assertionFunction.getFunctionName(), assertionFunction);
        }
    }

    @Override
    public void process(Node externsRoot, Node jsRoot) {
        Node externsAndJs = jsRoot.getParent();
        Preconditions.checkState((externsAndJs != null ? 1 : 0) != 0);
        Preconditions.checkState((externsRoot == null || externsAndJs.hasChild(externsRoot) ? 1 : 0) != 0);
        this.inferAllScopes(externsAndJs);
    }

    void inferAllScopes(Node node) {
        new NodeTraversal(this.compiler, new FirstScopeBuildingCallback(), this.scopeCreator).traverseWithScope(node, this.topScope);
        for (Scope s : this.scopeCreator.getAllMemoizedScopes()) {
            s.resolveTypes();
        }
        new NodeTraversal(this.compiler, new SecondScopeBuildingCallback(), this.scopeCreator).traverseWithScope(node, this.topScope);
    }

    void inferScope(Node n, Scope scope) {
        TypeInference typeInference = new TypeInference(this.compiler, this.computeCfg(n), this.reverseInterpreter, scope, this.assertionFunctionsMap);
        try {
            typeInference.analyze();
            this.compiler.getTypeRegistry().resolveTypesInScope(scope);
        }
        catch (DataFlowAnalysis.MaxIterationsExceededException e) {
            this.compiler.report(JSError.make(n.getSourceFileName(), n, DATAFLOW_ERROR, new String[0]));
        }
    }

    private ControlFlowGraph<Node> computeCfg(Node n) {
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, n);
        return cfa.getCfg();
    }

    private class FirstScopeBuildingCallback
    extends NodeTraversal.AbstractScopedCallback {
        private FirstScopeBuildingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            t.getScope();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    private class SecondScopeBuildingCallback
    extends NodeTraversal.AbstractScopedCallback {
        private SecondScopeBuildingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            TypeInferencePass.this.inferScope(t.getCurrentNode(), t.getScope());
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

