/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.CodePrinter;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Type;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;
import org.json.JSONObject;

abstract class AbstractFuzzer {
    protected FuzzingContext context;

    AbstractFuzzer(FuzzingContext context) {
        this.context = context;
    }

    protected JSONObject getOwnConfig() {
        Preconditions.checkNotNull((Object)this.context.config);
        return this.context.config.optJSONObject(this.getConfigName());
    }

    protected abstract boolean isEnough(int var1);

    protected abstract Node generate(int var1, Set<Type> var2);

    protected Node generate(int budget) {
        return this.generate(budget, this.supportedTypes());
    }

    protected Node[] distribute(int budget, AbstractFuzzer[] fuzzers) {
        Preconditions.checkArgument((fuzzers.length > 0 ? 1 : 0) != 0);
        int numNodes = fuzzers.length;
        int[] subBudgets = new int[numNodes];
        Arrays.fill(subBudgets, 0);
        if (budget > 3 * numNodes) {
            double[] rands = new double[numNodes];
            double sum = 0.0;
            int i = 0;
            while (i < numNodes) {
                rands[i] = this.context.random.nextDouble();
                sum += rands[i];
                ++i;
            }
            i = 0;
            while (i < numNodes) {
                double additionalBudget = (double)budget / sum * rands[i];
                int n = i++;
                subBudgets[n] = (int)((double)subBudgets[n] + additionalBudget);
                budget = (int)((double)budget - additionalBudget);
            }
        }
        while (budget > 0) {
            int n = this.context.random.nextInt(numNodes);
            subBudgets[n] = subBudgets[n] + 1;
            --budget;
        }
        Node[] nodes = new Node[numNodes];
        int i = 0;
        while (i < numNodes) {
            nodes[i] = this.fuzz(fuzzers[i], subBudgets[i]);
            ++i;
        }
        return nodes;
    }

    protected Node fuzz(AbstractFuzzer fuzzer, int budget) {
        return fuzzer.generate(budget);
    }

    protected abstract String getConfigName();

    protected int generateLength(int budget) {
        return this.context.random.nextInt((int)((double)budget * this.getOwnConfig().optDouble("maxLength")) + 1);
    }

    public static String getPrettyCode(Node root) {
        CodePrinter.Builder builder = new CodePrinter.Builder(root);
        builder.setPrettyPrint(true);
        builder.setLineBreak(true);
        return builder.build();
    }

    protected Set<Type> supportedTypes() {
        return Sets.newHashSet((Object[])Type.values());
    }
}

