/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DiscreteDistribution<T> {
    private Random random;
    private List<T> items;
    private List<Double> weights;

    public DiscreteDistribution(Random random, ArrayList<T> items, ArrayList<Double> weights) {
        this.random = random;
        this.items = items;
        this.weights = weights;
        double sum = 0.0;
        for (Double w : weights) {
            Preconditions.checkArgument((w >= 0.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((!Double.isInfinite(w) ? 1 : 0) != 0);
            Preconditions.checkArgument((!Double.isNaN(w) ? 1 : 0) != 0);
            sum += w.doubleValue();
        }
        int i = 0;
        while (i < weights.size()) {
            weights.set(i, weights.get(i) / sum);
            ++i;
        }
    }

    public T nextItem() {
        double randomValue = this.random.nextDouble();
        double sum = 0.0;
        int i = 0;
        while (i < this.weights.size()) {
            if (randomValue < (sum += this.weights.get(i).doubleValue())) {
                return this.items.get(i);
            }
            ++i;
        }
        return null;
    }
}

