/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.CodePrinter;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.DiscreteDistribution;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Expression;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Scope;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.ScopeManager;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Statement;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.StringGenerator;
import com.google.gwt.thirdparty.javascript.rhino.InputId;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Random;

public class Fuzzer {
    private static final int LARGEST_NUMBER = 1000;
    protected final Random random;
    ScopeManager scopeManager;
    private int counter = 0;

    public Fuzzer(Random random) {
        this.random = random;
        this.scopeManager = new ScopeManager(random);
    }

    Node generateExpression(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        ArrayList expressions = Lists.newArrayList();
        ArrayList weights = Lists.newArrayList();
        Expression[] expressionArray = Expression.values();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expr = expressionArray[n2];
            if (!(expr.minBudget > budget || expr == Expression.FUNCTION_CALL && this.scopeManager.getSize() == 0 && budget < 4 || expr == Expression.IDENTIFIER && this.scopeManager.getSize() == 0)) {
                expressions.add(expr);
                weights.add(expr.weight);
            }
            ++n2;
        }
        DiscreteDistribution dd = new DiscreteDistribution(this.random, expressions, weights);
        Expression expr = (Expression)((Object)dd.nextItem());
        switch (expr) {
            case THIS: {
                return this.generateThis(budget);
            }
            case IDENTIFIER: {
                return this.getExistingIdentifier(budget);
            }
            case LITERAL: {
                return this.generateLiteral(budget);
            }
            case FUNCTION_CALL: {
                return this.generateFunctionCall(budget);
            }
            case UNARY_EXPR: {
                return this.generateUnaryExpression(budget);
            }
            case BINARY_EXPR: {
                return this.generateBinaryExpression(budget);
            }
            case FUNCTION_EXPR: {
                return this.generateFunctionExpression(budget);
            }
            case TERNARY_EXPR: {
                return this.generateTernaryExpression(budget);
            }
        }
        return null;
    }

    Node generateThis(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        return new Node(42);
    }

    Node generateLiteral(int budget) {
        int rand = budget > 1 ? this.random.nextInt(7) : (budget == 1 ? this.random.nextInt(6) : -1);
        switch (rand) {
            case 0: {
                return this.generateNullLiteral(budget);
            }
            case 1: {
                return this.generateBooleanLiteral(budget);
            }
            case 2: {
                return this.generateNumericLiteral(budget);
            }
            case 3: {
                return this.generateStringLiteral(budget);
            }
            case 4: {
                return this.generateArrayLiteral(budget);
            }
            case 5: {
                return this.generateObjectLiteral(budget);
            }
            case 6: {
                return this.generateRegularExpressionLiteral(budget);
            }
        }
        return null;
    }

    Node generateNumericLiteral(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        return Node.newNumber(this.random.nextInt(1000));
    }

    Node generateStringLiteral(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        return Node.newString(StringGenerator.getString(this.random));
    }

    Node generateIdentifier(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        String name = null;
        if (this.scopeManager.hasNonLocals() && this.random.nextInt(10) < 1) {
            name = this.scopeManager.getRandomSymbol(true);
        }
        if (name == null) {
            name = "x_" + this.nextNumber();
        }
        this.scopeManager.addSymbol(name);
        return Node.newString(38, name);
    }

    Node getExistingIdentifier(int budget) {
        Preconditions.checkState((this.scopeManager.getSize() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        return Node.newString(38, this.scopeManager.getRandomSymbol(false));
    }

    Node generateNullLiteral(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        return new Node(41);
    }

    Node generateBooleanLiteral(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        return this.random.nextInt(2) == 0 ? new Node(43) : new Node(44);
    }

    Node generateRegularExpressionLiteral(int budget) {
        Preconditions.checkArgument((budget >= 2 ? 1 : 0) != 0);
        if (budget < 3) {
            Node[] children = new Node[]{Node.newString(StringGenerator.getString(this.random))};
            Node node = new Node(47, children);
            return node;
        }
        Node[] children = new Node[]{Node.newString(StringGenerator.getString(this.random)), Node.newString("g")};
        Node node = new Node(47, children);
        return node;
    }

    Node generateObjectLiteral(int budget) {
        int objectLength;
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        Node objectLit = new Node(64);
        int remainingBudget = budget - 1;
        int n = objectLength = remainingBudget < 2 ? 0 : this.random.nextInt(remainingBudget / 2 + 1);
        if (objectLength == 0) {
            return objectLit;
        }
        int[] propertyBudgets = this.distribute(remainingBudget -= objectLength, objectLength, 1);
        int i = 0;
        while (i < objectLength) {
            Node key = this.generatePropertyName();
            Node value = this.generateExpression(propertyBudgets[i]);
            key.addChildrenToFront(value);
            objectLit.addChildToBack(key);
            ++i;
        }
        return objectLit;
    }

    Node generateArrayLiteral(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        Node node = new Node(63);
        int arraySize = this.random.nextInt(budget);
        if (arraySize > 0) {
            int[] itemBudgets = this.distribute(budget - 1, arraySize, 1);
            int i = 0;
            while (i < arraySize) {
                Node item = this.generateExpression(itemBudgets[i]);
                node.addChildToBack(item);
                ++i;
            }
        }
        return node;
    }

    Node generateAssignableExpression(int budget) {
        Preconditions.checkArgument((budget >= 3 || this.scopeManager.getSize() > 0 ? 1 : 0) != 0);
        if (budget < 3) {
            return this.getExistingIdentifier(budget);
        }
        int rand = this.scopeManager.getSize() > 0 ? this.random.nextInt(3) : this.random.nextInt(2);
        switch (rand) {
            case 0: {
                return this.generateGetProp(budget);
            }
            case 1: {
                return this.generateGetElem(budget);
            }
            case 2: {
                return this.getExistingIdentifier(budget);
            }
        }
        return null;
    }

    Node generateGetProp(int budget) {
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        Node left = this.generateExpression(budget - 2);
        Node right = Node.newString(StringGenerator.getPropertyName(this.random));
        return new Node(33, left, right);
    }

    Node generateGetElem(int budget) {
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        int[] subBudgets = this.distribute(budget - 1, 2, 1);
        Node left = this.generateExpression(subBudgets[0]);
        Node right = this.generateExpression(subBudgets[1]);
        return new Node(35, left, right);
    }

    Node generateFunctionCall(int budget) {
        return this.generateFunctionCall(budget, this.random.nextInt(2) == 0);
    }

    Node generateFunctionCall(int budget, boolean isNew) {
        Preconditions.checkArgument((budget >= 2 && this.scopeManager.getSize() > 0 || budget >= 4 ? 1 : 0) != 0);
        int remainingBudget = this.scopeManager.getSize() == 0 ? budget - 3 : budget - 1;
        int numArgs = this.random.nextInt(remainingBudget);
        int[] subBudgets = this.distribute(remainingBudget, numArgs + 1, 1);
        Node target = this.generateCallableExpression(subBudgets[0] + budget - 1 - remainingBudget);
        Node node = isNew ? new Node(30, target) : new Node(37, target);
        int i = 0;
        while (i < numArgs) {
            Node arg = this.generateExpression(subBudgets[i + 1]);
            node.addChildToBack(arg);
            ++i;
        }
        return node;
    }

    private Node generateCallableExpression(int budget) {
        Preconditions.checkArgument((budget >= 3 || this.scopeManager.getSize() > 0 ? 1 : 0) != 0);
        if (budget < 3) {
            return this.generateAssignableExpression(budget);
        }
        if (this.random.nextInt(2) == 0) {
            return this.generateAssignableExpression(budget);
        }
        return this.generateFunctionExpression(budget);
    }

    Node generateUnaryExpression(int budget) {
        Preconditions.checkArgument((budget >= 2 ? 1 : 0) != 0);
        Node node = null;
        int rand = this.scopeManager.getSize() == 0 && budget < 4 ? this.random.nextInt(6) : this.random.nextInt(11);
        switch (rand) {
            case 0: {
                Node target = this.generateExpression(budget - 1);
                node = new Node(122, target);
                break;
            }
            case 1: {
                Node target = this.generateExpression(budget - 1);
                node = new Node(32, target);
                break;
            }
            case 2: {
                Node target = this.generateExpression(budget - 1);
                node = new Node(28, target);
                break;
            }
            case 3: {
                Node target = this.generateExpression(budget - 1);
                node = new Node(29, target);
                break;
            }
            case 4: {
                Node target = this.generateExpression(budget - 1);
                node = new Node(27, target);
                break;
            }
            case 5: {
                Node target = this.generateExpression(budget - 1);
                node = new Node(26, target);
                break;
            }
            case 6: {
                Node target = this.generateAssignableExpression(budget - 1);
                node = new Node(102, target);
                break;
            }
            case 7: {
                Node target = this.generateAssignableExpression(budget - 1);
                node = new Node(103, target);
                break;
            }
            case 8: {
                Node target = this.generateAssignableExpression(budget - 1);
                node = new Node(31, target);
                break;
            }
            case 9: {
                Node target = this.generateAssignableExpression(budget - 1);
                node = new Node(102, target);
                node.putBooleanProp(32, true);
                break;
            }
            case 10: {
                Node target = this.generateAssignableExpression(budget - 1);
                node = new Node(103, target);
                node.putBooleanProp(32, true);
            }
        }
        return node;
    }

    Node generateBinaryExpression(int budget) {
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        ArrayList operators = Lists.newArrayList((Object[])new Integer[]{23, 24, 25, 21, 22, 18, 19, 20, 14, 16, 15, 17, 52, 51, 12, 13, 45, 46, 11, 10, 9, 101, 100, 86, 95, 96, 97, 93, 94, 90, 91, 92, 89, 88, 87});
        int[] subBudgets = this.distribute(budget - 1, 2, 1);
        int firstAssignIndex = operators.indexOf(86);
        int index = subBudgets[0] < 3 && this.scopeManager.getSize() == 0 ? this.random.nextInt(firstAssignIndex) : this.random.nextInt(operators.size());
        Node left = index < firstAssignIndex ? this.generateExpression(subBudgets[0]) : this.generateAssignableExpression(subBudgets[0]);
        Node right = this.generateExpression(subBudgets[1]);
        return new Node((int)((Integer)operators.get(index)), left, right);
    }

    Node generateTernaryExpression(int budget) {
        Preconditions.checkArgument((budget >= 4 ? 1 : 0) != 0);
        int[] subBudgets = this.distribute(budget - 1, 3, 1);
        Node condition = this.generateExpression(subBudgets[0]);
        Node choice1 = this.generateExpression(subBudgets[1]);
        Node choice2 = this.generateExpression(subBudgets[2]);
        return new Node(98, condition, choice1, choice2);
    }

    Node generateFunctionExpression(int budget) {
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        return this.generateFunction(budget, true);
    }

    private Statement decideStatementTypeToGenerate(int budget) {
        ArrayList statements = Lists.newArrayList();
        ArrayList weights = Lists.newArrayList();
        Scope scope = this.scopeManager.localScope();
        Statement[] statementArray = Statement.values();
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement stmt = statementArray[n2];
            if (!(stmt.minBudget > budget || stmt == Statement.RETURN && this.scopeManager.getNumScopes() < 2 || stmt == Statement.BREAK && scope.loopNesting == 0 && scope.switchNesting == 0 || stmt == Statement.CONTINUE && scope.loopNesting == 0)) {
                statements.add(stmt);
                weights.add(stmt.weight);
            }
            ++n2;
        }
        DiscreteDistribution dd = new DiscreteDistribution(this.random, statements, weights);
        return (Statement)((Object)dd.nextItem());
    }

    Node generateStatement(int budget) {
        Statement stmt = this.decideStatementTypeToGenerate(budget);
        return this.generateStatementForType(stmt, budget);
    }

    private Node generateStatementForType(Statement type, int budget) {
        switch (type) {
            case BLOCK: {
                return this.generateBlock(budget);
            }
            case VAR: {
                return this.generateVariableStatement(budget);
            }
            case EMPTY: {
                return this.generateEmptyStatement(budget);
            }
            case EXPR: {
                return this.generateExpressionStatement(budget);
            }
            case IF: {
                return this.generateIfStatement(budget);
            }
            case WHILE: {
                return this.generateWhile(budget);
            }
            case DO_WHILE: {
                return this.generateDoWhile(budget);
            }
            case FOR: {
                return this.generateFor(budget);
            }
            case FOR_IN: {
                return this.generateForIn(budget);
            }
            case CONTINUE: {
                return this.generateContinue(budget);
            }
            case BREAK: {
                return this.generateBreak(budget);
            }
            case RETURN: {
                return this.generateReturn(budget);
            }
            case SWITCH: {
                return this.generateSwitch(budget);
            }
            case LABEL: {
                return this.generateLabelledStatement(budget);
            }
            case THROW: {
                return this.generateThrow(budget);
            }
            case TRY: {
                return this.generateTry(budget);
            }
        }
        throw new RuntimeException("Shouldn never reach this!");
    }

    Node generateBlock(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        Node node = new Node(125);
        int numStmt = this.random.nextInt(budget);
        if (numStmt > 0) {
            int[] stmtBudgets;
            int[] nArray = stmtBudgets = this.distribute(budget - 1, numStmt, 1);
            int n = stmtBudgets.length;
            int n2 = 0;
            while (n2 < n) {
                int b = nArray[n2];
                node.addChildToBack(this.generateStatement(b));
                ++n2;
            }
        }
        return node;
    }

    Node generateVariableStatement(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        Node identifier = this.generateIdentifier(budget);
        Node node = new Node(118, identifier);
        if (budget > 1) {
            Node assn = this.generateExpression(budget - 1);
            identifier.addChildToBack(assn);
        }
        return node;
    }

    Node generateEmptyStatement(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        return new Node(124);
    }

    Node generateExpressionStatement(int budget) {
        Preconditions.checkArgument((budget >= 2 ? 1 : 0) != 0);
        Node expr = this.generateExpression(budget - 1);
        return new Node(130, expr);
    }

    Node generateIfStatement(int budget) {
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        int numComponents = budget == 3 ? 2 : (this.random.nextInt(2) == 0 ? 2 : 3);
        int size = 1;
        int[] componentBudgets = this.distribute(budget - size, numComponents, 1);
        Node condition = this.generateExpression(componentBudgets[0]);
        Node node = new Node(108, condition);
        node.addChildToBack(this.generateBlock(componentBudgets[1]));
        if (numComponents == 3) {
            node.addChildToBack(this.generateBlock(componentBudgets[2]));
        }
        return node;
    }

    Node generateWhile(int budget) {
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        int[] componentBudgets = this.distribute(budget - 1, 2, 1);
        Node expr = this.generateExpression(componentBudgets[0]);
        Scope scope = this.scopeManager.localScope();
        ++scope.loopNesting;
        Node stmt = this.generateBlock(componentBudgets[1]);
        --scope.loopNesting;
        return new Node(113, expr, stmt);
    }

    Node generateDoWhile(int budget) {
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        int[] componentBudgets = this.distribute(budget - 1, 2, 1);
        ++this.scopeManager.localScope().loopNesting;
        Node stmt = this.generateBlock(componentBudgets[0]);
        --this.scopeManager.localScope().loopNesting;
        Node expr = this.generateExpression(componentBudgets[1]);
        return new Node(114, stmt, expr);
    }

    Node generateFor(int budget) {
        Preconditions.checkArgument((budget >= 2 ? 1 : 0) != 0);
        int totalHeaderBudget = (budget - 1) / 3;
        int bodyBudget = budget - 1 - totalHeaderBudget;
        int[] headerBudgets = this.distribute(totalHeaderBudget, 3, 0);
        Node initializer = headerBudgets[0] == 0 ? new Node(124) : (this.random.nextInt(2) == 0 ? this.generateVariableStatement(headerBudgets[0]) : this.generateExpression(headerBudgets[0]));
        Node condition = headerBudgets[1] == 0 ? new Node(124) : this.generateExpression(headerBudgets[1]);
        Node increment = headerBudgets[2] == 0 ? new Node(124) : this.generateExpression(headerBudgets[2]);
        ++this.scopeManager.localScope().loopNesting;
        Node body = this.generateBlock(bodyBudget);
        --this.scopeManager.localScope().loopNesting;
        return new Node(115, initializer, condition, increment, body);
    }

    Node generateForIn(int budget) {
        Preconditions.checkArgument((budget >= 4 ? 1 : 0) != 0);
        ++this.scopeManager.localScope().loopNesting;
        int[] componentBudgets = this.distribute(budget, 3, 1);
        Node iterator = componentBudgets[0] < 3 && this.scopeManager.getSize() == 0 ? this.generateVariableStatement(componentBudgets[0]) : (this.random.nextInt(2) == 0 ? this.generateAssignableExpression(componentBudgets[0]) : this.generateVariableStatement(componentBudgets[0]));
        Node expr = this.generateExpression(componentBudgets[1]);
        Node block = this.generateBlock(componentBudgets[2]);
        --this.scopeManager.localScope().loopNesting;
        return new Node(115, iterator, expr, block);
    }

    Node generateContinue(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        Node node = new Node(117);
        Scope localScope = this.scopeManager.localScope();
        if (localScope.loopLabels.size() > 0 && this.random.nextInt(2) == 0) {
            node.addChildToBack(Node.newString(153, localScope.randomLabelForContinue(this.random)));
        }
        return node;
    }

    Node generateBreak(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        Node node = new Node(116);
        Scope localScope = this.scopeManager.localScope();
        if (localScope.loopLabels.size() + localScope.otherLabels.size() > 0 && this.random.nextInt(2) == 0) {
            node.addChildToBack(Node.newString(153, localScope.randomLabelForBreak(this.random)));
        }
        return node;
    }

    Node generateReturn(int budget) {
        Preconditions.checkArgument((budget >= 1 ? 1 : 0) != 0);
        Node node = new Node(4);
        if (budget > 1) {
            node.addChildToBack(this.generateExpression(budget - 1));
        }
        return node;
    }

    Node generateSwitch(int budget) {
        Preconditions.checkArgument((budget >= 2 ? 1 : 0) != 0);
        ++this.scopeManager.localScope().switchNesting;
        int numCases = budget > 2 ? this.random.nextInt(budget - 2) : 0;
        int[] componentBudgets = this.distribute(budget, numCases + 1, 2);
        Node switchStmt = new Node(110, this.generateExpression(componentBudgets[0] - 1));
        int defaultClauseIndex = -1;
        if (numCases > 1) {
            defaultClauseIndex = this.random.nextInt(numCases + 1);
        }
        int i = 0;
        while (i < numCases) {
            Node clause;
            Node block;
            int remainingBudget = componentBudgets[i + 1] - 1;
            if (i == defaultClauseIndex) {
                block = this.generateBlock(remainingBudget + 1);
                clause = new Node(112);
            } else {
                int exprBudget = remainingBudget / 3;
                if (exprBudget == 0) {
                    exprBudget = 1;
                }
                int blockBudget = remainingBudget - exprBudget + 1;
                block = this.generateBlock(blockBudget);
                clause = new Node(111, this.generateExpression(exprBudget));
            }
            block.setIsSyntheticBlock(true);
            clause.addChildrenToBack(block);
            switchStmt.addChildToBack(clause);
            ++i;
        }
        --this.scopeManager.localScope().switchNesting;
        return switchStmt;
    }

    Node generateLabelledStatement(int budget) {
        ArrayList<String> currentLabels;
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        String labelName = "x_" + this.nextNumber();
        Node name = Node.newString(153, labelName);
        Node node = new Node(126, name);
        Statement stmtType = this.decideStatementTypeToGenerate(budget - 2);
        Scope localScope = this.scopeManager.localScope();
        switch (stmtType) {
            case WHILE: 
            case DO_WHILE: 
            case FOR: 
            case FOR_IN: {
                currentLabels = localScope.loopLabels;
                break;
            }
            default: {
                currentLabels = localScope.otherLabels;
            }
        }
        currentLabels.add(labelName);
        node.addChildToBack(this.generateStatementForType(stmtType, budget - 2));
        currentLabels.remove(labelName);
        return node;
    }

    Node generateThrow(int budget) {
        Preconditions.checkArgument((budget >= 2 ? 1 : 0) != 0);
        return new Node(49, this.generateExpression(budget - 1));
    }

    Node generateTry(int budget) {
        Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
        int bodyBudget = (budget - 1) / 2;
        Node tryStmt = new Node(77, this.generateBlock(bodyBudget));
        int[] catchAndFinallyBudgets = this.distribute(budget - 1 - bodyBudget, 2, 0);
        Node catchBlock = new Node(125);
        if (catchAndFinallyBudgets[0] > 3) {
            Node param = this.generateIdentifier(1);
            catchBlock.addChildToBack(new Node(120, param, this.generateBlock(catchAndFinallyBudgets[0] - 1)));
            this.scopeManager.removeSymbol(param.getQualifiedName());
        } else {
            catchAndFinallyBudgets[1] = budget - 1 - bodyBudget;
        }
        tryStmt.addChildToBack(catchBlock);
        if (catchAndFinallyBudgets[1] > 0) {
            tryStmt.addChildToBack(this.generateBlock(catchAndFinallyBudgets[1]));
        }
        return tryStmt;
    }

    private Node generateFunction(int budget, boolean isExpression) {
        int remainingBudget;
        Node name;
        if (isExpression) {
            Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
            this.scopeManager.addFunctionScope();
            if (budget >= 4 && this.random.nextInt(2) == 0) {
                name = this.generateIdentifier(1);
                remainingBudget = budget - 4;
            } else {
                name = Node.newString(38, "");
                remainingBudget = budget - 3;
            }
        } else {
            Preconditions.checkArgument((budget >= 4 ? 1 : 0) != 0);
            name = this.generateIdentifier(1);
            remainingBudget = budget - 4;
            this.scopeManager.addFunctionScope();
        }
        Node paramList = new Node(83);
        Node body = new Node(125);
        int numComponents = this.random.nextInt(remainingBudget + 1);
        if (numComponents > 0) {
            int[] componentBudgets = this.distribute(remainingBudget + 1, numComponents, 1);
            componentBudgets[0] = componentBudgets[0] - 1;
            int i = 0;
            while (i < componentBudgets[0]) {
                paramList.addChildToBack(this.generateIdentifier(1));
                ++i;
            }
            i = 1;
            while (i < numComponents) {
                body.addChildToBack(this.generateSourceElement(componentBudgets[i]));
                ++i;
            }
        }
        this.scopeManager.removeScope();
        Node function = new Node(105, name, paramList, body);
        return function;
    }

    Node generateFunctionDeclaration(int budget) {
        return this.generateFunction(budget, false);
    }

    Node generateSourceElement(int budget) {
        if (budget < 4) {
            return this.generateStatement(budget);
        }
        if (this.random.nextInt(2) == 0) {
            return this.generateStatement(budget);
        }
        return this.generateFunctionDeclaration(budget);
    }

    Node[] generateProgram(int budget) {
        int numElements = this.random.nextInt(budget) / 5 + 1;
        if (numElements > 0) {
            int[] elemBudgets = this.distribute(budget, numElements, 1);
            Node[] elements = new Node[numElements];
            int i = 0;
            while (i < numElements) {
                elements[i] = this.generateSourceElement(elemBudgets[i]);
                ++i;
            }
            return elements;
        }
        return new Node[]{this.generateEmptyStatement(budget)};
    }

    private Node generatePropertyName() {
        String name = this.random.nextInt(2) == 0 ? StringGenerator.getPropertyName(this.random) : String.valueOf(this.random.nextInt(1000));
        Node node = Node.newString(154, name);
        return node;
    }

    public static String getPrettyCode(Node root) {
        CodePrinter.Builder builder = new CodePrinter.Builder(root);
        builder.setPrettyPrint(true);
        builder.setLineBreak(true);
        return builder.build();
    }

    public static Node buildScript(Node ast) {
        return Fuzzer.buildScript(new Node[]{ast});
    }

    public static Node buildScript(Node[] elements) {
        Node script = new Node(132, elements);
        InputId inputId = new InputId("fuzzedInput");
        script.setInputId(inputId);
        script.setSourceFileForTesting(inputId.getIdName());
        return script;
    }

    int[] distribute(int budget, int n, int min) {
        int[] subBudgets = new int[n];
        int i = 0;
        while (i < n) {
            subBudgets[i] = min;
            ++i;
        }
        if ((budget -= n * min) > 3 * n) {
            double[] rands = new double[n];
            double sum = 0.0;
            int i2 = 0;
            while (i2 < n) {
                rands[i2] = this.random.nextDouble();
                sum += rands[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < n) {
                double additionalBudget = (double)budget / sum * rands[i2];
                int n2 = i2++;
                subBudgets[n2] = (int)((double)subBudgets[n2] + additionalBudget);
                budget = (int)((double)budget - additionalBudget);
            }
        }
        while (budget > 0) {
            int n3 = this.random.nextInt(n);
            subBudgets[n3] = subBudgets[n3] + 1;
            --budget;
        }
        return subBudgets;
    }

    private int nextNumber() {
        return this.counter++;
    }
}

