/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Type;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;

class ObjectFuzzer
extends AbstractFuzzer {
    ObjectFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        int objectLength;
        Node objectLit = new Node(64);
        int remainingBudget = budget - 1;
        if (remainingBudget < 0) {
            remainingBudget = 0;
        }
        if ((objectLength = this.generateLength(remainingBudget / 2)) == 0) {
            return objectLit;
        }
        Object[] fuzzers = new ExpressionFuzzer[objectLength];
        Arrays.fill(fuzzers, new ExpressionFuzzer(this.context));
        Node[] values = this.distribute(remainingBudget -= objectLength, (AbstractFuzzer[])fuzzers);
        int i = 0;
        while (i < objectLength) {
            String name = this.context.random.nextInt(2) == 0 ? this.context.snGenerator.getPropertyName() : String.valueOf(this.context.snGenerator.getRandomNumber());
            Node key = Node.newString(154, name);
            key.addChildrenToFront(values[i]);
            objectLit.addChildToBack(key);
            ++i;
        }
        return objectLit;
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 1;
    }

    @Override
    protected String getConfigName() {
        return "object";
    }

    @Override
    protected Set<Type> supportedTypes() {
        return Sets.newHashSet((Object[])new Type[]{Type.OBJECT});
    }
}

