/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.jsonml;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonML;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonMLException;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonMLUtil;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagAttr;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagType;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.Validator;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Reader {
    static final DiagnosticType JSONML_SYNTAX = DiagnosticType.error("JSONML_SYNTAX", "Syntax error: {0}");
    private JsonML rootElement;
    private String sourceName;
    private ErrorReporter errorReporter;
    private final Set<String> ALLOWED_DIRECTIVES = Sets.newHashSet((Object[])new String[]{"use strict"});
    private int nodeIndex;
    private boolean insertExprResultState = true;

    public void setRootElement(JsonML rootElement) {
        this.rootElement = rootElement;
    }

    public Node parse(AbstractCompiler compiler) throws JsonMLException {
        if (compiler == null) {
            return null;
        }
        Reader reader = this;
        reader.getClass();
        this.errorReporter = reader.new ErrorReporter(compiler);
        Node root = IR.block();
        this.nodeIndex = -1;
        Preconditions.checkState((this.rootElement.getType() == TagType.Program ? 1 : 0) != 0);
        this.transformElement(this.rootElement, root);
        return root.removeFirstChild();
    }

    private <T> T getOptionalAttribute(JsonML element, TagAttr attr, Class<T> type) throws JsonMLException {
        return this.getAttribute(element, attr, type, true);
    }

    private <T> T getAttribute(JsonML element, TagAttr attr, Class<T> type) throws JsonMLException {
        return this.getAttribute(element, attr, type, false);
    }

    private <T> T getAttribute(JsonML element, TagAttr attr, Class<T> type, boolean optional) throws JsonMLException {
        Object value = element.getAttribute(attr);
        if (value == null) {
            if (type == null || optional) {
                return null;
            }
            throw new JsonMLException("Missing " + attr.name() + " attribute for " + element.getType().name() + " element.");
        }
        if (type.equals(Double.class)) {
            if (value instanceof Number) {
                return type.cast(((Number)value).doubleValue());
            }
            if (value instanceof String) {
                return type.cast(Double.valueOf((String)value));
            }
            throw new JsonMLException("Wrong type of " + attr.name() + " attribute. " + "Received: " + value.getClass() + ". Expected: " + type.getName());
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new JsonMLException("Wrong type of " + attr.name() + "attribute. " + "Received: " + value.getClass() + ". Expected: " + type.getName());
    }

    private Object getObjectAttribute(JsonML element, TagAttr attr) throws JsonMLException {
        return this.getAttribute(element, attr, Object.class);
    }

    private String getStringAttribute(JsonML element, TagAttr attr) throws JsonMLException {
        return this.getAttribute(element, attr, String.class);
    }

    private void validate(JsonML element) throws JsonMLException {
        String errorMessage = Validator.validate(element);
        if (errorMessage != null) {
            this.errorReporter.report(element, new String[]{errorMessage});
        }
    }

    private void transformElement(JsonML element, Node parent) throws JsonMLException {
        ++this.nodeIndex;
        this.validate(element);
        if (this.insertExprResultState && JsonMLUtil.isExpression(element)) {
            this.transformExpr(element, parent);
            return;
        }
        switch (element.getType()) {
            case ArrayExpr: {
                this.transformArrayExpr(element, parent);
                break;
            }
            case AssignExpr: {
                this.transformAssignExpr(element, parent);
                break;
            }
            case BinaryExpr: {
                this.transformBinaryExpr(element, parent);
                break;
            }
            case BlockStmt: {
                this.transformBlock(element, parent);
                break;
            }
            case BreakStmt: {
                this.transformBreakStmt(element, parent);
                break;
            }
            case CallExpr: {
                this.transformCallExpr(element, parent);
                break;
            }
            case Case: {
                this.transformCase(element, parent);
                break;
            }
            case CatchClause: {
                this.transformCatchClause(element, parent);
                break;
            }
            case ConditionalExpr: {
                this.transformConditionalExpr(element, parent);
                break;
            }
            case ContinueStmt: {
                this.transformContinueStmt(element, parent);
                break;
            }
            case CountExpr: {
                this.transformCountExpr(element, parent);
                break;
            }
            case DataProp: {
                this.transformDataProp(element, parent);
                break;
            }
            case GetterProp: {
                this.transformGetterProp(element, parent);
                break;
            }
            case SetterProp: {
                this.transformSetterProp(element, parent);
                break;
            }
            case DefaultCase: {
                this.transformDefaultCase(element, parent);
                break;
            }
            case DeleteExpr: {
                this.transformDeleteExpr(element, parent);
                break;
            }
            case DoWhileStmt: {
                this.transformDoWhileStmt(element, parent);
                break;
            }
            case Empty: {
                this.transformEmpty(element, parent);
                break;
            }
            case EmptyStmt: {
                this.transformEmptyStmt(element, parent);
                break;
            }
            case EvalExpr: {
                this.transformEvalExpr(element, parent);
                break;
            }
            case ForInStmt: {
                this.transformForInStmt(element, parent);
                break;
            }
            case ForStmt: {
                this.transformForStmt(element, parent);
                break;
            }
            case FunctionDecl: {
                this.transformFunctionDecl(element, parent);
                break;
            }
            case FunctionExpr: {
                this.transformFunctionExpr(element, parent);
                break;
            }
            case IdExpr: {
                this.transformIdExpr(element, parent);
                break;
            }
            case IdPatt: {
                this.transformIdPatt(element, parent);
                break;
            }
            case IfStmt: {
                this.transformIfStmt(element, parent);
                break;
            }
            case InitPatt: {
                this.transformInitPatt(element, parent);
                break;
            }
            case InvokeExpr: {
                this.transformInvokeExpr(element, parent);
                break;
            }
            case LabelledStmt: {
                this.transformLabelledStmt(element, parent);
                break;
            }
            case LiteralExpr: {
                this.transformLiteralExpr(element, parent);
                break;
            }
            case LogicalAndExpr: {
                this.transformLogicalAndExpr(element, parent);
                break;
            }
            case LogicalOrExpr: {
                this.transformLogicalOrExpr(element, parent);
                break;
            }
            case MemberExpr: {
                this.transformMemberExpr(element, parent);
                break;
            }
            case NewExpr: {
                this.transformNewExpr(element, parent);
                break;
            }
            case ObjectExpr: {
                this.transformObjectExpr(element, parent);
                break;
            }
            case ParamDecl: {
                this.transformParamDecl(element, parent);
                break;
            }
            case Program: {
                this.transformProgram(element, parent);
                break;
            }
            case PrologueDecl: {
                this.transformPrologueDecl(element, parent);
                break;
            }
            case RegExpExpr: {
                this.transformRegExpExpr(element, parent);
                break;
            }
            case ReturnStmt: {
                this.transformReturnStmt(element, parent);
                break;
            }
            case SwitchStmt: {
                this.transformSwitchStmt(element, parent);
                break;
            }
            case ThisExpr: {
                this.transformThisExpr(element, parent);
                break;
            }
            case ThrowStmt: {
                this.transformThrowStmt(element, parent);
                break;
            }
            case TryStmt: {
                this.transformTryStmt(element, parent);
                break;
            }
            case TypeofExpr: {
                this.transformTypeofExpr(element, parent);
                break;
            }
            case UnaryExpr: {
                this.transformUnaryExpr(element, parent);
                break;
            }
            case VarDecl: {
                this.transformVarDecl(element, parent);
                break;
            }
            case WhileStmt: {
                this.transformWhileStmt(element, parent);
                break;
            }
            case WithStmt: {
                this.transformWithStmt(element, parent);
            }
        }
    }

    private void transformAllChildren(JsonML element, Node parent, boolean newState) throws JsonMLException {
        this.transformElements(element.getChildren(), parent, newState);
    }

    private void transformAllChildren(JsonML element, Node parent) throws JsonMLException {
        this.transformElements(element.getChildren(), parent);
    }

    private void transformAllChildrenFromIndex(JsonML element, Node parent, int fromIndex, boolean newState) throws JsonMLException {
        this.transformElements(element.getChildren().subList(fromIndex, element.childrenSize()), parent, newState);
    }

    private void transformElements(List<JsonML> elements, Node parent, boolean newState) throws JsonMLException {
        boolean oldState = this.insertExprResultState;
        this.insertExprResultState = newState;
        this.transformElements(elements, parent);
        this.insertExprResultState = oldState;
    }

    private void transformElements(List<JsonML> elements, Node parent) throws JsonMLException {
        for (JsonML element : elements) {
            this.transformElement(element, parent);
        }
    }

    private boolean transformExpr(JsonML element, Node parent) throws JsonMLException {
        boolean result = false;
        if (this.insertExprResultState) {
            Node node = new Node(130);
            parent.addChildToBack(node);
            this.insertExprResultState = false;
            --this.nodeIndex;
            this.transformElement(element, node);
            this.insertExprResultState = true;
            result = true;
        }
        return result;
    }

    private void transformForLoop(JsonML element, Node parent, int childno) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        this.insertExprResultState = false;
        Node node = this.createNode(115, element);
        parent.addChildToBack(node);
        int i = 0;
        while (i < childno) {
            JsonML child = element.getChild(i);
            if (child.getType() == TagType.EmptyStmt || child.getType() == TagType.Empty) {
                ++this.nodeIndex;
                node.addChildToBack(IR.empty());
            } else {
                this.transformElement(child, node);
            }
            ++i;
        }
        this.transformPotentiallyUnwrappedBlock(element.getChild(childno), node);
        this.insertExprResultState = true;
    }

    private void transformJumpStmt(JsonML element, Node parent, int type) throws JsonMLException {
        Node node = this.createNode(type, element);
        parent.addChildToBack(node);
        String label = this.getOptionalAttribute(element, TagAttr.LABEL, String.class);
        if (label != null) {
            node.addChildToBack(IR.labelName(label));
        }
    }

    private void transformLogicalExpr(JsonML element, Node parent, int type) throws JsonMLException {
        this.transformTwoArgumentExpr(element, parent, type);
    }

    private void transformTwoArgumentExpr(JsonML element, Node parent, int type) throws JsonMLException {
        Node node = this.createNode(type, element);
        parent.addChildToBack(node);
        this.transformAllChildren(element, node);
    }

    private void transformPotentiallyUnwrappedBlock(JsonML element, Node parent) throws JsonMLException {
        if (element.getType() == TagType.EmptyStmt || element.getType() == TagType.Empty) {
            ++this.nodeIndex;
            Node block = IR.block();
            parent.addChildToBack(block);
            block.putBooleanProp(39, true);
        } else if (element.getType() != TagType.BlockStmt) {
            Node block = IR.block();
            parent.addChildToBack(block);
            boolean state = this.insertExprResultState;
            this.insertExprResultState = true;
            this.transformElement(element, block);
            this.insertExprResultState = state;
        } else {
            ++this.nodeIndex;
            this.transformBlock(element, parent);
        }
    }

    private void transformArrayExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(63, element);
        parent.addChildToBack(node);
        for (JsonML child : element.getChildren()) {
            this.transformElement(child, node);
        }
    }

    private void transformAssignExpr(JsonML element, Node parent) throws JsonMLException {
        String op = this.getStringAttribute(element, TagAttr.OP);
        int type = Operator.getNodeTypeForAssignOp(op);
        this.transformTwoArgumentExpr(element, parent, type);
    }

    private void transformBinaryExpr(JsonML element, Node parent) throws JsonMLException {
        String op = this.getStringAttribute(element, TagAttr.OP);
        int type = Operator.getNodeTypeForBinaryOp(op);
        this.transformTwoArgumentExpr(element, parent, type);
    }

    private void transformBlock(JsonML element, Node parent) throws JsonMLException {
        this.transformBlock(element, parent, 0, element.childrenSize());
    }

    private void transformBlock(JsonML element, Node parent, int start) throws JsonMLException {
        this.transformBlock(element, parent, start, element.childrenSize());
    }

    private void transformBlock(JsonML element, Node parent, int start, int end) throws JsonMLException {
        Node node = this.createNode(125, element);
        parent.addChildToBack(node);
        this.transformElements(element.getChildren(start, end), node, true);
    }

    private void transformBreakStmt(JsonML element, Node parent) throws JsonMLException {
        this.transformJumpStmt(element, parent, 116);
    }

    private void transformCallExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(37, element);
        parent.addChildToBack(node);
        this.transformAllChildren(element, node);
        Node first = node.getFirstChild();
        if (first.getType() != 33 && first.getType() != 35) {
            node.putBooleanProp(50, true);
        }
    }

    private void transformCase(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(111, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        this.transformElement(child, node);
        Node block = IR.block();
        block.setIsSyntheticBlock(true);
        node.addChildToBack(block);
        this.transformAllChildrenFromIndex(element, block, 1, true);
    }

    private void transformCatchClause(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(120, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        this.transformElement(child, node);
        child = element.getChild(1);
        this.transformElement(child, node);
    }

    private void transformConditionalExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(98, element);
        parent.addChildToBack(node);
        this.transformAllChildren(element, node);
    }

    private void transformContinueStmt(JsonML element, Node parent) throws JsonMLException {
        this.transformJumpStmt(element, parent, 117);
    }

    private void transformCountExpr(JsonML element, Node parent) throws JsonMLException {
        String op = this.getStringAttribute(element, TagAttr.OP);
        int type = Operator.getNodeTypeForCountOp(op);
        Boolean isPrefix = this.getAttribute(element, TagAttr.IS_PREFIX, Boolean.class);
        Node node = this.createNode(type, element);
        node.putIntProp(32, isPrefix != false ? 0 : 1);
        parent.addChildToBack(node);
        this.transformElement(element.getChild(0), node);
    }

    private void transformDataProp(JsonML element, Node parent) throws JsonMLException {
        Object name = this.getObjectAttribute(element, TagAttr.NAME);
        Node node = null;
        if (name instanceof Number) {
            node = IR.stringKey(Reader.getStringValue(((Number)name).doubleValue()));
        } else if (name instanceof String) {
            node = IR.stringKey((String)name);
        } else {
            throw new IllegalStateException("The name of the property has invalid type.");
        }
        this.setPosition(node);
        parent.addChildToBack(node);
        this.transformElement(element.getChild(0), node);
    }

    private static String getStringValue(double value) {
        long longValue = (long)value;
        if ((double)longValue == value) {
            return Long.toString(longValue);
        }
        return Double.toString(value);
    }

    private void transformGetterProp(JsonML element, Node parent) throws JsonMLException {
        this.transformProp(147, element, parent);
    }

    private void transformSetterProp(JsonML element, Node parent) throws JsonMLException {
        this.transformProp(148, element, parent);
    }

    private void transformProp(int tokenType, JsonML element, Node parent) throws JsonMLException {
        Object name = this.getObjectAttribute(element, TagAttr.NAME);
        Node node = null;
        if (name instanceof Number) {
            throw new IllegalStateException("Not yet supported.");
        }
        if (!(name instanceof String)) {
            throw new IllegalStateException("The name of the property has invalid type.");
        }
        node = Node.newString(tokenType, (String)name);
        this.setPosition(node);
        parent.addChildToBack(node);
        this.transformElement(element.getChild(0), node);
    }

    private void transformDefaultCase(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(112, element);
        parent.addChildToBack(node);
        Node block = IR.block();
        block.setIsSyntheticBlock(true);
        node.addChildToBack(block);
        this.transformAllChildren(element, block, true);
    }

    private void transformDeleteExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(31, element);
        parent.addChildToBack(node);
        this.transformElement(element.getChild(0), node);
    }

    private void transformDoWhileStmt(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        this.insertExprResultState = false;
        Node node = this.createNode(114, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        this.transformPotentiallyUnwrappedBlock(child, node);
        child = element.getChild(1);
        this.transformElement(child, node);
        this.insertExprResultState = true;
    }

    private void transformEmpty(JsonML element, Node parent) {
        switch (parent.getType()) {
            case 63: {
                parent.addChildToBack(IR.empty());
                break;
            }
            case 105: {
                parent.addChildToBack(IR.name(""));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Empty element.");
            }
        }
    }

    private void transformEmptyStmt(JsonML element, Node parent) {
        Preconditions.checkState((parent.getType() == 125 || parent.getType() == 132 ? 1 : 0) != 0);
        parent.addChildToBack(IR.empty());
    }

    private void transformEvalExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(37, element);
        node.putBooleanProp(50, true);
        parent.addChildToBack(node);
        Node child = IR.name("eval");
        child.putBooleanProp(49, true);
        node.addChildToBack(child);
        this.transformAllChildren(element, node);
    }

    private void transformForInStmt(JsonML element, Node parent) throws JsonMLException {
        this.transformForLoop(element, parent, 2);
    }

    private void transformForStmt(JsonML element, Node parent) throws JsonMLException {
        this.transformForLoop(element, parent, 3);
    }

    private void transformFunction(JsonML element, Node parent, boolean needsName) throws JsonMLException {
        Node node = this.createNode(105, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        String name = "";
        this.transformElement(element.getChild(0), node);
        this.transformElement(element.getChild(1), node);
        this.transformBlock(element, node, 2);
    }

    private void transformFunctionDecl(JsonML element, Node parent) throws JsonMLException {
        this.transformFunction(element, parent, true);
    }

    private void transformFunctionExpr(JsonML element, Node parent) throws JsonMLException {
        this.transformFunction(element, parent, false);
    }

    private void transformIdExpr(JsonML element, Node parent) throws JsonMLException {
        String name = this.getStringAttribute(element, TagAttr.NAME);
        Node node = IR.name(name);
        this.setPosition(node);
        parent.addChildToBack(node);
    }

    private void transformInitPatt(JsonML element, Node parent) throws JsonMLException {
        JsonML child = element.getChild(0);
        ++this.nodeIndex;
        Node node = IR.name(this.getAttribute(child, TagAttr.NAME, String.class));
        this.setPosition(node);
        parent.addChildToBack(node);
        child = element.getChild(1);
        this.transformElement(child, node);
    }

    private void transformIdPatt(JsonML element, Node parent) throws JsonMLException {
        Node node = IR.name(this.getStringAttribute(element, TagAttr.NAME));
        this.setPosition(node);
        parent.addChildToBack(node);
    }

    private void transformIfStmt(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        this.insertExprResultState = false;
        Node node = this.createNode(108, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        this.transformElement(child, node);
        child = element.getChild(1);
        this.transformPotentiallyUnwrappedBlock(child, node);
        child = element.getChild(2);
        if (child.getType() != TagType.EmptyStmt && child.getType() != TagType.Empty) {
            this.transformPotentiallyUnwrappedBlock(child, node);
        } else {
            ++this.nodeIndex;
        }
        this.insertExprResultState = true;
    }

    private void transformInvokeExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(37, element);
        parent.addChildToBack(node);
        this.transformMemberExpr(element, node);
        this.transformElements(element.getChildren(2, element.childrenSize()), node);
    }

    private void transformLabelledStmt(JsonML element, Node parent) throws JsonMLException {
        String label = this.getStringAttribute(element, TagAttr.LABEL);
        Node node = this.createNode(126, element);
        node.addChildToBack(IR.labelName(label));
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        if (child.getType() == TagType.EmptyStmt) {
            ++this.nodeIndex;
            node.addChildToBack(IR.empty());
        } else {
            this.transformElement(element.getChild(0), node);
        }
    }

    private void transformLiteralExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = null;
        Type type = Type.get(this.getStringAttribute(element, TagAttr.TYPE));
        switch (type) {
            case BOOLEAN: {
                Boolean value = this.getAttribute(element, TagAttr.VALUE, Boolean.class);
                if (value.booleanValue()) {
                    node = IR.trueNode();
                    break;
                }
                node = IR.falseNode();
                break;
            }
            case NULL: {
                this.getAttribute(element, TagAttr.VALUE, null);
                node = IR.nullNode();
                break;
            }
            case NUMBER: {
                Double value = this.getAttribute(element, TagAttr.VALUE, Double.class);
                node = IR.number(value);
                break;
            }
            case STRING: {
                String value = this.getStringAttribute(element, TagAttr.VALUE);
                node = IR.string(value);
                break;
            }
            default: {
                throw new JsonMLException("Unrecognized type attribute.");
            }
        }
        this.setPosition(node);
        parent.addChildToBack(node);
    }

    private void transformLogicalAndExpr(JsonML element, Node parent) throws JsonMLException {
        this.transformLogicalExpr(element, parent, 101);
    }

    private void transformLogicalOrExpr(JsonML element, Node parent) throws JsonMLException {
        this.transformLogicalExpr(element, parent, 100);
    }

    private void transformMemberExpr(JsonML element, Node parent) throws JsonMLException {
        int type;
        String op = this.getAttribute(element, TagAttr.OP, String.class);
        if (op.equals(".")) {
            type = 33;
        } else if (op.equals("[]")) {
            type = 35;
        } else {
            throw new JsonMLException("Invalid OP argument: " + op);
        }
        Node node = this.createNode(type, element);
        parent.addChildToBack(node);
        this.transformElement(element.getChild(0), node);
        this.transformElement(element.getChild(1), node);
    }

    private void transformNewExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(30, element);
        parent.addChildToBack(node);
        this.transformAllChildren(element, node);
    }

    private void transformObjectExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(64, element);
        parent.addChildToBack(node);
        this.transformAllChildren(element, node);
    }

    private void transformParamDecl(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(83, element);
        parent.addChildToBack(node);
        this.transformAllChildren(element, node);
    }

    private void transformProgram(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkNotNull((Object)parent);
        this.insertExprResultState = true;
        Node script = IR.script();
        parent.addChildToBack(script);
        for (JsonML child : element.getChildren()) {
            this.transformElement(child, script);
        }
    }

    private void transformPrologueDecl(JsonML element, Node parent) throws JsonMLException {
        String directive = this.getStringAttribute(element, TagAttr.DIRECTIVE);
        if (this.ALLOWED_DIRECTIVES.contains(directive)) {
            HashSet directives = parent.getDirectives();
            if (directives == null) {
                directives = Sets.newHashSet();
            }
            directives.add(directive);
            parent.setDirectives(directives);
        } else {
            Node node = IR.exprResult(IR.string(directive));
            parent.addChildToBack(node);
        }
    }

    private void transformRegExpExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(47, element);
        parent.addChildToBack(node);
        String body = this.getStringAttribute(element, TagAttr.BODY);
        node.addChildToBack(IR.string(body));
        String flags = this.getStringAttribute(element, TagAttr.FLAGS);
        if (!flags.equals("")) {
            node.addChildToBack(IR.string(flags));
        }
    }

    private void transformReturnStmt(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        Node node = this.createNode(4, element);
        parent.addChildToBack(node);
        if (element.hasChildren()) {
            this.insertExprResultState = false;
            this.transformElement(element.getChild(0), node);
            this.insertExprResultState = true;
        }
    }

    private void transformSwitchStmt(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        this.insertExprResultState = false;
        Node node = this.createNode(110, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        this.transformElement(child, node);
        int i = 1;
        while (i < element.childrenSize()) {
            child = element.getChild(i);
            this.transformElement(child, node);
            ++i;
        }
        this.insertExprResultState = true;
    }

    private void transformThisExpr(JsonML element, Node parent) throws JsonMLException {
        parent.addChildToBack(this.createNode(42, element));
    }

    private void transformThrowStmt(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        Node node = this.createNode(49, element);
        parent.addChildToBack(node);
        this.insertExprResultState = false;
        this.transformElement(element.getChild(0), node);
        this.insertExprResultState = true;
    }

    private void transformTryStmt(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        Node node = this.createNode(77, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        this.transformElement(child, node);
        Node block = IR.block();
        node.addChildToBack(block);
        child = element.getChild(1);
        if (child.getType() == TagType.CatchClause) {
            this.transformElement(child, block);
        } else {
            ++this.nodeIndex;
        }
        if (element.childrenSize() == 3) {
            child = element.getChild(2);
            this.transformElement(child, node);
        }
    }

    private void transformTypeofExpr(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(32, element);
        parent.addChildToBack(node);
        this.transformElement(element.getChild(0), node);
    }

    private void transformUnaryExpr(JsonML element, Node parent) throws JsonMLException {
        String op = this.getStringAttribute(element, TagAttr.OP);
        int type = Operator.getNodeTypeForUnaryOp(op);
        Node node = this.createNode(type, element);
        parent.addChildToBack(node);
        this.transformAllChildren(element, node);
    }

    private void transformVarDecl(JsonML element, Node parent) throws JsonMLException {
        Node node = this.createNode(118, element);
        parent.addChildToBack(node);
        this.transformAllChildren(element, node, false);
    }

    private void transformWhileStmt(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        this.insertExprResultState = false;
        Node node = this.createNode(113, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        this.transformElement(child, node);
        child = element.getChild(1);
        this.transformPotentiallyUnwrappedBlock(child, node);
        this.insertExprResultState = true;
    }

    private void transformWithStmt(JsonML element, Node parent) throws JsonMLException {
        Preconditions.checkState((boolean)this.insertExprResultState);
        this.insertExprResultState = false;
        Node node = this.createNode(119, element);
        parent.addChildToBack(node);
        JsonML child = element.getChild(0);
        this.transformElement(child, node);
        child = element.getChild(1);
        this.transformPotentiallyUnwrappedBlock(child, node);
        this.insertExprResultState = true;
    }

    private Node createNode(int type, JsonML element) {
        return new Node(type, this.nodeIndex, -1);
    }

    private void setPosition(Node node) {
        node.setLineno(this.nodeIndex);
    }

    private class ErrorReporter {
        private AbstractCompiler compiler;

        ErrorReporter(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        private void report(JsonML element, String ... arguments) throws JsonMLException {
            this.report(JSONML_SYNTAX, element, arguments);
        }

        private void report(DiagnosticType type, JsonML element, String ... arguments) throws JsonMLException {
            int lineno = Reader.this.nodeIndex;
            int charno = -1;
            this.report(JSError.make(Reader.this.sourceName, lineno, charno, type, arguments));
        }

        private void report(JSError error) throws JsonMLException {
            this.report(error, true);
        }

        private void report(JSError error, boolean terminal2) throws JsonMLException {
            this.compiler.report(error);
            if (terminal2) {
                throw new JsonMLException();
            }
        }
    }

    private static enum Operator {
        ASSIGN("="),
        ASSIGN_BITOR("|="),
        ASSIGN_BITXOR("^="),
        ASSIGN_BITAND("&="),
        ASSIGN_LSH("<<="),
        ASSIGN_RSH(">>="),
        ASSIGN_URSH(">>>="),
        ASSIGN_ADD("+="),
        ASSIGN_SUB("-="),
        ASSIGN_MUL("*="),
        ASSIGN_DIV("/="),
        ASSIGN_MOD("%="),
        BITOR("|"),
        BITXOR("^"),
        BITAND("&"),
        EQ("=="),
        NE("!="),
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">="),
        LSH("<<"),
        RSH(">>"),
        URSH(">>>"),
        ADD("+"),
        SUB("-"),
        MUL("*"),
        DIV("/"),
        MOD("%"),
        SHEQ("==="),
        SHNE("!=="),
        COMMA(","),
        INSTANCEOF("instanceof"),
        IN("in"),
        DEC("--"),
        INC("++"),
        NOT("!"),
        BITNOT("~"),
        POS("+_unary"),
        NEG("-_unary"),
        VOID("void");

        private final String name;
        private static Map<String, Operator> lookup;

        static {
            lookup = Maps.newHashMap();
            Operator[] operatorArray = Operator.values();
            int n = operatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operator op = operatorArray[n2];
                lookup.put(op.getName(), op);
                ++n2;
            }
        }

        private String getName() {
            return this.name;
        }

        private Operator(String name) {
            this.name = name;
        }

        private static Operator get(String name) {
            return lookup.get(name);
        }

        private static int getNodeTypeForAssignOp(String name) {
            int type;
            Operator op = Operator.get(name);
            if (op == null) {
                return -1;
            }
            switch (op) {
                case ASSIGN: {
                    type = 86;
                    break;
                }
                case ASSIGN_BITOR: {
                    type = 87;
                    break;
                }
                case ASSIGN_BITXOR: {
                    type = 88;
                    break;
                }
                case ASSIGN_BITAND: {
                    type = 89;
                    break;
                }
                case ASSIGN_LSH: {
                    type = 90;
                    break;
                }
                case ASSIGN_RSH: {
                    type = 91;
                    break;
                }
                case ASSIGN_URSH: {
                    type = 92;
                    break;
                }
                case ASSIGN_ADD: {
                    type = 93;
                    break;
                }
                case ASSIGN_SUB: {
                    type = 94;
                    break;
                }
                case ASSIGN_MUL: {
                    type = 95;
                    break;
                }
                case ASSIGN_DIV: {
                    type = 96;
                    break;
                }
                case ASSIGN_MOD: {
                    type = 97;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type of assign expression.");
                }
            }
            return type;
        }

        private static int getNodeTypeForBinaryOp(String name) {
            int type;
            Operator op = Operator.get(name);
            switch (op) {
                case BITOR: {
                    type = 9;
                    break;
                }
                case BITXOR: {
                    type = 10;
                    break;
                }
                case BITAND: {
                    type = 11;
                    break;
                }
                case EQ: {
                    type = 12;
                    break;
                }
                case NE: {
                    type = 13;
                    break;
                }
                case LT: {
                    type = 14;
                    break;
                }
                case LE: {
                    type = 15;
                    break;
                }
                case GT: {
                    type = 16;
                    break;
                }
                case GE: {
                    type = 17;
                    break;
                }
                case LSH: {
                    type = 18;
                    break;
                }
                case RSH: {
                    type = 19;
                    break;
                }
                case URSH: {
                    type = 20;
                    break;
                }
                case ADD: {
                    type = 21;
                    break;
                }
                case SUB: {
                    type = 22;
                    break;
                }
                case MUL: {
                    type = 23;
                    break;
                }
                case DIV: {
                    type = 24;
                    break;
                }
                case MOD: {
                    type = 25;
                    break;
                }
                case SHEQ: {
                    type = 45;
                    break;
                }
                case SHNE: {
                    type = 46;
                    break;
                }
                case COMMA: {
                    type = 85;
                    break;
                }
                case INSTANCEOF: {
                    type = 52;
                    break;
                }
                case IN: {
                    type = 51;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type of binary expression.");
                }
            }
            return type;
        }

        private static int getNodeTypeForCountOp(String name) {
            int type;
            Operator op = Operator.get(name);
            if (op == null) {
                return -1;
            }
            switch (op) {
                case DEC: {
                    type = 103;
                    break;
                }
                case INC: {
                    type = 102;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type of count expression.");
                }
            }
            return type;
        }

        private static int getNodeTypeForUnaryOp(String name) {
            int type;
            String realName = new String(name);
            if (name.equals("+") || name.equals("-")) {
                realName = String.valueOf(realName) + "_unary";
            }
            Operator op = Operator.get(realName);
            switch (op) {
                case NOT: {
                    type = 26;
                    break;
                }
                case BITNOT: {
                    type = 27;
                    break;
                }
                case POS: {
                    type = 28;
                    break;
                }
                case NEG: {
                    type = 29;
                    break;
                }
                case VOID: {
                    type = 122;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type of unary expression.");
                }
            }
            return type;
        }
    }

    private static enum Type {
        BOOLEAN("boolean"),
        NULL("null"),
        NUMBER("number"),
        STRING("string");

        private final String name;
        private static Map<String, Type> lookup;

        static {
            lookup = new HashMap<String, Type>();
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                lookup.put(type.getName(), type);
                ++n2;
            }
        }

        private String getName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }

        private static Type get(String name) {
            return lookup.get(name);
        }
    }
}

