/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.jsonml;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.CheckLevel;
import com.google.gwt.thirdparty.javascript.jscomp.Compiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerInput;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerOptions;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.JSModule;
import com.google.gwt.thirdparty.javascript.jscomp.Result;
import com.google.gwt.thirdparty.javascript.jscomp.SourceAst;
import com.google.gwt.thirdparty.javascript.jscomp.VariableRenamingPolicy;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonML;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonMLAst;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonMLError;
import java.util.ArrayList;
import java.util.List;

public class SecureCompiler {
    private static final String COMPILATION_UNCOMPLETED_MSG = "No compilation has been completed yet.";
    private static final String COMPILATION_UNSUCCESSFUL_MSG = "The last compilation was not successful.";
    private static final String COMPILATION_ALREADY_COMPLETED_MSG = "This instance has already compiled one source.";
    private Compiler compiler = new Compiler();
    private CompilerOptions options = this.getSecureCompilerOptions();
    private JsonMLAst sourceAst;
    private Report report;

    public JsonML getJsonML() {
        Preconditions.checkState((this.report != null ? 1 : 0) != 0, (Object)COMPILATION_UNCOMPLETED_MSG);
        Preconditions.checkState((boolean)this.report.success, (Object)COMPILATION_UNSUCCESSFUL_MSG);
        return this.sourceAst.convertToJsonML();
    }

    public String getString() {
        Preconditions.checkState((this.report != null ? 1 : 0) != 0, (Object)COMPILATION_UNCOMPLETED_MSG);
        Preconditions.checkState((boolean)this.report.success, (Object)COMPILATION_UNSUCCESSFUL_MSG);
        return this.compiler.toSource();
    }

    public Report getReport() {
        Preconditions.checkState((this.report != null ? 1 : 0) != 0, (Object)COMPILATION_UNCOMPLETED_MSG);
        return this.report;
    }

    public void compile(JsonML source) {
        if (this.report != null) {
            throw new IllegalStateException(COMPILATION_ALREADY_COMPLETED_MSG);
        }
        this.sourceAst = new JsonMLAst(source);
        CompilerInput input = new CompilerInput((SourceAst)this.sourceAst, "[[jsonmlsource]]", false);
        JSModule module = new JSModule("[[jsonmlmodule]]");
        module.add(input);
        Result result = this.compiler.compileModules(ImmutableList.of(), (List<JSModule>)ImmutableList.of((Object)module), this.options);
        this.report = this.generateReport(result);
    }

    private CompilerOptions getSecureCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.variableRenaming = VariableRenamingPolicy.OFF;
        options.setInlineVariables(CompilerOptions.Reach.LOCAL_ONLY);
        options.inlineLocalFunctions = true;
        options.checkGlobalThisLevel = CheckLevel.OFF;
        options.coalesceVariableNames = true;
        options.deadAssignmentElimination = true;
        options.collapseVariableDeclarations = true;
        options.convertToDottedProperties = true;
        options.labelRenaming = true;
        options.removeDeadCode = true;
        options.optimizeArgumentsArray = true;
        options.removeUnusedVars = false;
        options.removeUnusedLocalVars = true;
        return options;
    }

    public void enableFoldConstant() {
        this.options.foldConstants = true;
    }

    Report generateReport(Result result) {
        if (result == null) {
            return null;
        }
        ArrayList errors = Lists.newArrayList();
        JSError[] jSErrorArray = result.errors;
        int n = result.errors.length;
        int n2 = 0;
        while (n2 < n) {
            JSError error = jSErrorArray[n2];
            errors.add(JsonMLError.make(error, this.sourceAst));
            ++n2;
        }
        ArrayList warnings = Lists.newArrayList();
        JSError[] jSErrorArray2 = result.warnings;
        int n3 = result.warnings.length;
        n = 0;
        while (n < n3) {
            JSError warning = jSErrorArray2[n];
            warnings.add(JsonMLError.make(warning, this.sourceAst));
            ++n;
        }
        return new Report(errors.toArray(new JsonMLError[0]), warnings.toArray(new JsonMLError[0]));
    }

    public class Report {
        private final boolean success;
        private final JsonMLError[] errors;
        private final JsonMLError[] warnings;

        private Report(JsonMLError[] errors, JsonMLError[] warnings) {
            this.success = errors.length == 0;
            this.errors = errors;
            this.warnings = warnings;
        }

        public boolean isSuccessful() {
            return this.success;
        }

        public JsonMLError[] getErrors() {
            return this.errors;
        }

        public JsonMLError[] getWarnings() {
            return this.warnings;
        }
    }
}

