/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.jsonml;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonML;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagAttr;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagType;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Iterator;
import java.util.Set;

public class Writer {
    public JsonML processAst(Node root) {
        Preconditions.checkNotNull((Object)root);
        Preconditions.checkArgument((root.getType() == 125 || root.getType() == 132 ? 1 : 0) != 0);
        JsonML rootElement = new JsonML(TagType.BlockStmt);
        if (root.getType() == 132) {
            this.processNode(root, rootElement);
            return rootElement.getChild(0);
        }
        Node child = root.getFirstChild();
        while (child != null) {
            this.processNode(child, rootElement);
            child = child.getNext();
        }
        return rootElement.getChild(0);
    }

    private void processNode(Node node, JsonML currentParent) {
        switch (node.getType()) {
            case 4: {
                this.processReturn(node, currentParent);
                break;
            }
            case 9: {
                this.processBinaryExpr(node, currentParent, "|");
                break;
            }
            case 10: {
                this.processBinaryExpr(node, currentParent, "^");
                break;
            }
            case 11: {
                this.processBinaryExpr(node, currentParent, "&");
                break;
            }
            case 12: {
                this.processBinaryExpr(node, currentParent, "==");
                break;
            }
            case 13: {
                this.processBinaryExpr(node, currentParent, "!=");
                break;
            }
            case 14: {
                this.processBinaryExpr(node, currentParent, "<");
                break;
            }
            case 15: {
                this.processBinaryExpr(node, currentParent, "<=");
                break;
            }
            case 16: {
                this.processBinaryExpr(node, currentParent, ">");
                break;
            }
            case 17: {
                this.processBinaryExpr(node, currentParent, ">=");
                break;
            }
            case 18: {
                this.processBinaryExpr(node, currentParent, "<<");
                break;
            }
            case 19: {
                this.processBinaryExpr(node, currentParent, ">>");
                break;
            }
            case 20: {
                this.processBinaryExpr(node, currentParent, ">>>");
                break;
            }
            case 21: {
                this.processBinaryExpr(node, currentParent, "+");
                break;
            }
            case 22: {
                this.processBinaryExpr(node, currentParent, "-");
                break;
            }
            case 23: {
                this.processBinaryExpr(node, currentParent, "*");
                break;
            }
            case 24: {
                this.processBinaryExpr(node, currentParent, "/");
                break;
            }
            case 25: {
                this.processBinaryExpr(node, currentParent, "%");
                break;
            }
            case 26: {
                this.processUnaryExpr(node, currentParent, "!");
                break;
            }
            case 27: {
                this.processUnaryExpr(node, currentParent, "~");
                break;
            }
            case 28: {
                this.processUnaryExpr(node, currentParent, "+");
                break;
            }
            case 29: {
                this.processUnaryExpr(node, currentParent, "-");
                break;
            }
            case 30: {
                this.processNew(node, currentParent, TagType.NewExpr);
                break;
            }
            case 31: {
                this.processOneArgExpr(node, currentParent, TagType.DeleteExpr);
                break;
            }
            case 32: {
                this.processOneArgExpr(node, currentParent, TagType.TypeofExpr);
                break;
            }
            case 33: {
                this.processMemberExpr(node, currentParent, ".");
                break;
            }
            case 35: {
                this.processMemberExpr(node, currentParent, "[]");
                break;
            }
            case 37: {
                this.processCall(node, currentParent);
                break;
            }
            case 38: {
                this.processName(node, currentParent);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                this.processLiteral(node, currentParent);
                break;
            }
            case 42: {
                this.processThis(node, currentParent);
                break;
            }
            case 45: {
                this.processBinaryExpr(node, currentParent, "===");
                break;
            }
            case 46: {
                this.processBinaryExpr(node, currentParent, "!==");
                break;
            }
            case 47: {
                this.processRegExp(node, currentParent);
                break;
            }
            case 49: {
                this.processThrow(node, currentParent);
                break;
            }
            case 51: {
                this.processBinaryExpr(node, currentParent, "in");
                break;
            }
            case 52: {
                this.processBinaryExpr(node, currentParent, "instanceof");
                break;
            }
            case 63: {
                this.processArrayLiteral(node, currentParent);
                break;
            }
            case 64: {
                this.processObjectLiteral(node, currentParent);
                break;
            }
            case 77: {
                this.processTry(node, currentParent);
                break;
            }
            case 85: {
                this.processBinaryExpr(node, currentParent, ",");
                break;
            }
            case 86: {
                this.processAssignExpr(node, currentParent, "=");
                break;
            }
            case 87: {
                this.processAssignExpr(node, currentParent, "|=");
                break;
            }
            case 88: {
                this.processAssignExpr(node, currentParent, "^=");
                break;
            }
            case 89: {
                this.processAssignExpr(node, currentParent, "&=");
                break;
            }
            case 90: {
                this.processAssignExpr(node, currentParent, "<<=");
                break;
            }
            case 91: {
                this.processAssignExpr(node, currentParent, ">>=");
                break;
            }
            case 92: {
                this.processAssignExpr(node, currentParent, ">>>=");
                break;
            }
            case 93: {
                this.processAssignExpr(node, currentParent, "+=");
                break;
            }
            case 94: {
                this.processAssignExpr(node, currentParent, "-=");
                break;
            }
            case 95: {
                this.processAssignExpr(node, currentParent, "*=");
                break;
            }
            case 96: {
                this.processAssignExpr(node, currentParent, "/=");
                break;
            }
            case 97: {
                this.processAssignExpr(node, currentParent, "%=");
                break;
            }
            case 98: {
                this.processHook(node, currentParent);
                break;
            }
            case 100: {
                this.processLogicalExpr(node, currentParent, "||");
                break;
            }
            case 101: {
                this.processLogicalExpr(node, currentParent, "&&");
                break;
            }
            case 102: {
                this.processIncrDecrExpr(node, currentParent, "++");
                break;
            }
            case 103: {
                this.processIncrDecrExpr(node, currentParent, "--");
                break;
            }
            case 105: {
                this.processFunction(node, currentParent);
                break;
            }
            case 108: {
                this.processIf(node, currentParent);
                break;
            }
            case 110: {
                this.processSwitch(node, currentParent);
                break;
            }
            case 111: {
                this.processCase(node, currentParent, TagType.Case);
                break;
            }
            case 112: {
                this.processCase(node, currentParent, TagType.DefaultCase);
                break;
            }
            case 113: {
                this.processLoop(node, currentParent, TagType.WhileStmt);
                break;
            }
            case 114: {
                this.processLoop(node, currentParent, TagType.DoWhileStmt);
                break;
            }
            case 115: {
                this.processForLoop(node, currentParent);
                break;
            }
            case 116: {
                this.processJmp(node, currentParent, TagType.BreakStmt);
                break;
            }
            case 117: {
                this.processJmp(node, currentParent, TagType.ContinueStmt);
                break;
            }
            case 118: {
                this.processVar(node, currentParent);
                break;
            }
            case 119: {
                this.processWith(node, currentParent);
                break;
            }
            case 120: {
                this.processCatch(node, currentParent);
                break;
            }
            case 122: {
                this.processUnaryExpr(node, currentParent, "void");
                break;
            }
            case 124: {
                this.processEmpty(node, currentParent);
                break;
            }
            case 125: {
                this.processBlock(node, currentParent);
                break;
            }
            case 126: {
                this.processLabel(node, currentParent);
                break;
            }
            case 130: {
                this.processExprResult(node, currentParent);
                break;
            }
            case 132: {
                this.processScript(node, currentParent);
            }
        }
    }

    private void processAssignExpr(Node node, JsonML currentParent, String op) {
        this.processTwoArgExpr(node, currentParent, TagType.AssignExpr, op);
    }

    private void processArrayLiteral(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.ArrayExpr);
        currentParent.appendChild(element);
        Iterator<Node> it = node.children().iterator();
        while (it.hasNext()) {
            this.processNode(it.next(), element);
        }
    }

    private void processBinaryExpr(Node node, JsonML currentParent, String op) {
        this.processTwoArgExpr(node, currentParent, TagType.BinaryExpr, op);
    }

    private void processBlock(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.BlockStmt);
        if (currentParent != null) {
            currentParent.appendChild(element);
        }
        this.processDirectives(node, element);
        for (Node child : node.children()) {
            this.processNode(child, element);
        }
    }

    private void processCall(Node node, JsonML currentParent) {
        JsonML element;
        Iterator<Node> it = node.children().iterator();
        Node child = it.next();
        switch (child.getType()) {
            case 33: 
            case 35: {
                element = new JsonML(TagType.InvokeExpr);
                element.setAttribute(TagAttr.OP, child.getType() == 33 ? "." : "[]");
                currentParent.appendChild(element);
                Node grandchild = child.getFirstChild();
                this.processNode(grandchild, element);
                this.processNode(grandchild.getNext(), element);
                break;
            }
            case 38: {
                if (child.getString().equals("eval")) {
                    element = new JsonML(TagType.EvalExpr);
                } else {
                    element = new JsonML(TagType.IdExpr);
                    element.setAttribute(TagAttr.NAME, child.getString());
                    element = new JsonML(TagType.CallExpr, element);
                }
                currentParent.appendChild(element);
                break;
            }
            default: {
                element = new JsonML(TagType.CallExpr);
                currentParent.appendChild(element);
                this.processNode(child, element);
                break;
            }
        }
        while (it.hasNext()) {
            this.processNode(it.next(), element);
        }
    }

    private void processCase(Node node, JsonML currentParent, TagType type) {
        JsonML element = new JsonML(type);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        if (type == TagType.Case) {
            this.processNode(child, element);
            child = child.getNext();
        }
        Preconditions.checkNotNull((Object)child);
        Preconditions.checkState((child.getType() == 125 ? 1 : 0) != 0);
        child = child.getFirstChild();
        while (child != null) {
            this.processNode(child, element);
            child = child.getNext();
        }
    }

    private void processCatch(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.CatchClause);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        JsonML patt = new JsonML(TagType.IdPatt);
        patt.setAttribute(TagAttr.NAME, child.getString());
        element.appendChild(patt);
        child = child.getNext();
        this.processNode(child, element);
    }

    private void processEmpty(Node node, JsonML currentParent) {
        if (currentParent.getType() == TagType.ArrayExpr) {
            currentParent.appendChild(new JsonML(TagType.Empty));
        } else {
            currentParent.appendChild(new JsonML(TagType.EmptyStmt));
        }
    }

    private void processExprResult(Node node, JsonML currentParent) {
        this.processNode(node.getFirstChild(), currentParent);
    }

    private void processForLoop(Node node, JsonML currentParent) {
        if (NodeUtil.isForIn(node)) {
            this.processLoop(node, currentParent, TagType.ForInStmt);
        } else {
            this.processLoop(node, currentParent, TagType.ForStmt);
        }
    }

    private void processFunction(Node node, JsonML currentParent) {
        JsonML element = NodeUtil.isFunctionDeclaration(node) ? new JsonML(TagType.FunctionDecl) : new JsonML(TagType.FunctionExpr);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        String name = child.getString();
        if (!name.equals("")) {
            JsonML nameElement = new JsonML(TagType.IdPatt);
            nameElement.setAttribute(TagAttr.NAME, name);
            element.appendChild(nameElement);
        } else {
            element.appendChild(new JsonML(TagType.Empty));
        }
        child = child.getNext();
        JsonML params = new JsonML(TagType.ParamDecl);
        element.appendChild(params);
        Iterator<Node> it = child.children().iterator();
        while (it.hasNext()) {
            JsonML param = new JsonML(TagType.IdPatt);
            Node nameNode = it.next();
            param.setAttribute(TagAttr.NAME, nameNode.getString());
            params.appendChild(param);
        }
        child = child.getNext();
        this.processDirectives(child, element);
        it = child.children().iterator();
        while (it.hasNext()) {
            this.processNode(it.next(), element);
        }
    }

    private void processHook(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.ConditionalExpr);
        currentParent.appendChild(element);
        this.processChildren(node, element);
    }

    private void processIf(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.IfStmt);
        currentParent.appendChild(element);
        Iterator<Node> it = node.children().iterator();
        while (it.hasNext()) {
            this.processNode(it.next(), element);
        }
        int childCount = node.getChildCount();
        Preconditions.checkState((childCount >= 2 ? 1 : 0) != 0);
        if (childCount < 3) {
            element.appendChild(new JsonML(TagType.EmptyStmt));
        }
    }

    private void processIncrDecrExpr(Node node, JsonML currentParent, String op) {
        JsonML element = new JsonML(TagType.CountExpr);
        currentParent.appendChild(element);
        if (op.equals("++")) {
            element.setAttribute(TagAttr.OP, "++");
        } else {
            element.setAttribute(TagAttr.OP, "--");
        }
        if (node.getIntProp(32) == 1) {
            element.setAttribute(TagAttr.IS_PREFIX, false);
        } else {
            element.setAttribute(TagAttr.IS_PREFIX, true);
        }
        this.processNode(node.getFirstChild(), element);
    }

    private void processJmp(Node node, JsonML currentParent, TagType type) {
        JsonML element = new JsonML(type);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        if (child != null) {
            element.setAttribute(TagAttr.LABEL, child.getString());
        }
    }

    private void processLabel(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.LabelledStmt);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        element.setAttribute(TagAttr.LABEL, child.getString());
        child = child.getNext();
        this.processNode(child, element);
    }

    private void processLiteral(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.LiteralExpr);
        switch (node.getType()) {
            case 39: {
                element.setAttribute(TagAttr.TYPE, "number");
                element.setAttribute(TagAttr.VALUE, node.getDouble());
                break;
            }
            case 40: {
                element.setAttribute(TagAttr.TYPE, "string");
                element.setAttribute(TagAttr.VALUE, node.getString());
                break;
            }
            case 41: {
                element.setAttribute(TagAttr.TYPE, "null");
                element.setAttribute(TagAttr.VALUE, null);
                break;
            }
            case 44: {
                element.setAttribute(TagAttr.TYPE, "boolean");
                element.setAttribute(TagAttr.VALUE, true);
                break;
            }
            case 43: {
                element.setAttribute(TagAttr.TYPE, "boolean");
                element.setAttribute(TagAttr.VALUE, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type of node.");
            }
        }
        currentParent.appendChild(element);
    }

    private void processLogicalExpr(Node node, JsonML currentParent, String op) {
        if (op.equals("||")) {
            this.processTwoArgExpr(node, currentParent, TagType.LogicalOrExpr);
        } else if (op.endsWith("&&")) {
            this.processTwoArgExpr(node, currentParent, TagType.LogicalAndExpr);
        } else {
            throw new IllegalArgumentException("Unsupported value of op argument.");
        }
    }

    private void processLoop(Node node, JsonML currentParent, TagType type) {
        JsonML element = new JsonML(type);
        currentParent.appendChild(element);
        this.processChildren(node, element);
    }

    private void processMemberExpr(Node node, JsonML currentParent, String op) {
        JsonML element = new JsonML(TagType.MemberExpr);
        element.setAttribute(TagAttr.OP, op);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        this.processNode(child, element);
        this.processNode(child.getNext(), element);
    }

    private void processName(Node node, JsonML currentParent) {
        Preconditions.checkState((!node.hasChildren() ? 1 : 0) != 0);
        JsonML element = new JsonML(TagType.IdExpr);
        element.setAttribute(TagAttr.NAME, node.getString());
        currentParent.appendChild(element);
    }

    private void processNew(Node node, JsonML currentParent, TagType type) {
        JsonML element = new JsonML(type);
        currentParent.appendChild(element);
        this.processChildren(node, element);
    }

    private void processObjectLiteral(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.ObjectExpr);
        currentParent.appendChild(element);
        for (Node key : node.children()) {
            String name;
            JsonML item;
            Node value = key.getFirstChild();
            switch (key.getType()) {
                case 154: {
                    item = new JsonML(TagType.DataProp);
                    name = key.getString();
                    break;
                }
                case 147: {
                    item = new JsonML(TagType.GetterProp);
                    name = key.getString();
                    break;
                }
                case 148: {
                    item = new JsonML(TagType.SetterProp);
                    name = key.getString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal type of node.");
                }
            }
            item.setAttribute(TagAttr.NAME, name);
            this.processNode(value, item);
            element.appendChild(item);
        }
    }

    private void processRegExp(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.RegExpExpr);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        element.setAttribute(TagAttr.BODY, child.getString());
        String flags = "";
        child = child.getNext();
        if (child != null) {
            flags = child.getString();
        }
        element.setAttribute(TagAttr.FLAGS, flags);
    }

    private void processSwitch(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.SwitchStmt);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        this.processNode(child, element);
        Node c = child.getNext();
        while (c != null) {
            this.processNode(c, element);
            c = c.getNext();
        }
    }

    private void processThis(Node node, JsonML currentParent) {
        currentParent.appendChild(new JsonML(TagType.ThisExpr));
    }

    private void processThrow(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.ThrowStmt);
        currentParent.appendChild(element);
        this.processNode(node.getFirstChild(), element);
    }

    private void processTry(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.TryStmt);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        this.processNode(child, element);
        child = child.getNext();
        if (child.hasChildren()) {
            this.processNode(child.getFirstChild(), element);
        } else {
            element.appendChild(new JsonML(TagType.Empty));
        }
        child = child.getNext();
        if (child != null) {
            this.processNode(child, element);
        }
    }

    private void processTwoArgExpr(Node node, JsonML currentParent, TagType type) {
        this.processTwoArgExpr(node, currentParent, type, null);
    }

    private void processTwoArgExpr(Node node, JsonML currentParent, TagType type, String op) {
        JsonML element = new JsonML(type);
        if (op != null) {
            element.setAttribute(TagAttr.OP, op);
        }
        currentParent.appendChild(element);
        Preconditions.checkState((node.getChildCount() == 2 ? 1 : 0) != 0);
        Node child = node.getFirstChild();
        this.processNode(child, element);
        this.processNode(child.getNext(), element);
    }

    private void processUnaryExpr(Node node, JsonML currentParent, String op) {
        JsonML element = new JsonML(TagType.UnaryExpr);
        element.setAttribute(TagAttr.OP, op);
        currentParent.appendChild(element);
        this.processNode(node.getFirstChild(), element);
    }

    private void processVar(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.VarDecl);
        currentParent.appendChild(element);
        for (Node child : node.children()) {
            JsonML id = new JsonML(TagType.IdPatt);
            id.setAttribute(TagAttr.NAME, child.getString());
            if (child.hasChildren()) {
                JsonML patt = new JsonML(TagType.InitPatt);
                element.appendChild(patt);
                patt.appendChild(id);
                this.processNode(child.getFirstChild(), patt);
                continue;
            }
            element.appendChild(id);
        }
    }

    private void processReturn(Node currentNode, JsonML currentParent) {
        JsonML element = new JsonML(TagType.ReturnStmt);
        currentParent.appendChild(element);
        if (currentNode.hasChildren()) {
            this.processNode(currentNode.getFirstChild(), element);
        }
    }

    private void processScript(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.Program);
        currentParent.appendChild(element);
        this.processDirectives(node, element);
        this.processChildren(node, element);
    }

    private void processWith(Node node, JsonML currentParent) {
        JsonML element = new JsonML(TagType.WithStmt);
        currentParent.appendChild(element);
        Node child = node.getFirstChild();
        this.processNode(child, element);
        child = child.getNext();
        this.processNode(child, element);
    }

    private void processChildren(Node node, JsonML currentParent) {
        for (Node child : node.children()) {
            this.processNode(child, currentParent);
        }
    }

    private void processDirectives(Node node, JsonML currentParent) {
        Set<String> directives = node.getDirectives();
        if (directives == null) {
            return;
        }
        for (String directive : directives) {
            JsonML element = new JsonML(TagType.PrologueDecl);
            element.setAttribute(TagAttr.DIRECTIVE, directive);
            element.setAttribute(TagAttr.VALUE, directive);
            currentParent.appendChild(element);
        }
    }

    private void processOneArgExpr(Node node, JsonML currentParent, TagType type) {
        JsonML element = new JsonML(type);
        currentParent.appendChild(element);
        this.processNode(node.getFirstChild(), element);
    }
}

