/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.newtypes;

import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.NominalType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.ObjectType;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class JSType {
    private static final int BOTTOM_MASK = 0;
    private static final int STRING_MASK = 1;
    private static final int NUMBER_MASK = 2;
    private static final int UNDEFINED_MASK = 4;
    private static final int TRUE_MASK = 8;
    private static final int FALSE_MASK = 16;
    private static final int NULL_MASK = 32;
    private static final int NON_SCALAR_MASK = 64;
    private static final int END_MASK = 128;
    private static final int TRUTHY_MASK = 256;
    private static final int FALSY_MASK = 512;
    private static final int UNKNOWN_MASK = Integer.MAX_VALUE;
    private static final int TOP_MASK = -1;
    private static final int BOOLEAN_MASK = 24;
    private static final int TOP_SCALAR_MASK = 63;
    private final int type;
    private final ImmutableSet<ObjectType> objs;
    private final String location;
    public static final JSType BOOLEAN = new JSType(24);
    public static final JSType BOTTOM = new JSType(0);
    public static final JSType FALSE_TYPE = new JSType(16);
    public static final JSType FALSY = new JSType(512);
    public static final JSType NULL = new JSType(32);
    public static final JSType NUMBER = new JSType(2);
    public static final JSType STRING = new JSType(1);
    public static final JSType TOP = new JSType(-1);
    public static final JSType TOP_SCALAR = new JSType(63);
    public static final JSType TRUE_TYPE = new JSType(8);
    public static final JSType TRUTHY = new JSType(256);
    public static final JSType UNDEFINED = new JSType(4);
    public static final JSType UNKNOWN = new JSType(Integer.MAX_VALUE);
    public static final JSType TOP_OBJECT = JSType.fromObjectType(ObjectType.TOP_OBJECT);
    private static JSType TOP_FUNCTION = null;
    public static final JSType NULL_OR_UNDEF = new JSType(36);
    public static final JSType NUM_OR_STR = new JSType(3);
    private static final JSType TOP_MINUS_NULL = new JSType(95, null, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.TOP_OBJECT));
    private static final JSType TOP_MINUS_UNDEF = new JSType(123, null, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.TOP_OBJECT));

    private JSType(int type, String location, ImmutableSet<ObjectType> objs) {
        this.location = location;
        if (objs == null) {
            this.type = type;
            this.objs = null;
        } else if (objs.size() == 0) {
            this.type = type & 0xFFFFFFBF;
            this.objs = null;
        } else {
            this.type = type | 0x40;
            this.objs = objs;
        }
        Preconditions.checkState((boolean)this.isValidType());
    }

    private JSType(int type) {
        this(type, null, null);
    }

    public static JSType fromFunctionType(FunctionType fn) {
        return new JSType(64, null, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.fromFunction(fn)));
    }

    public static JSType fromObjectType(ObjectType obj) {
        return new JSType(64, null, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)obj));
    }

    boolean isValidType() {
        return this.isUnknown() || this.isTop() || (this.type & 0x40) != 0 && !this.objs.isEmpty() || (this.type & 0x40) == 0 && this.objs == null;
    }

    public static JSType topFunction() {
        if (TOP_FUNCTION == null) {
            TOP_FUNCTION = JSType.fromFunctionType(FunctionType.TOP_FUNCTION);
        }
        return TOP_FUNCTION;
    }

    public boolean isTop() {
        return -1 == this.type;
    }

    public boolean isBottom() {
        return this.type == 0;
    }

    public boolean isUnknown() {
        return Integer.MAX_VALUE == this.type;
    }

    public boolean isTrue() {
        return 8 == this.type;
    }

    public boolean isFalse() {
        return 16 == this.type;
    }

    public boolean isTruthy() {
        return 256 == this.type || 8 == this.type;
    }

    public boolean isFalsy() {
        return 512 == this.type || 16 == this.type;
    }

    public boolean isBoolean() {
        return (this.type & 0xFFFFFFE7) == 0 && (this.type & 0x18) != 0;
    }

    public boolean isNullOrUndef() {
        int mask = 36;
        return this.type != 0 && (this.type | mask) == mask;
    }

    public boolean isScalar() {
        return this.type == 2 || this.type == 1 || this.type == 32 || this.type == 4 || this.isBoolean();
    }

    public boolean isInhabitable() {
        if (this.isBottom()) {
            return false;
        }
        if (this.objs == null) {
            return true;
        }
        for (ObjectType obj : this.objs) {
            if (obj.isInhabitable()) continue;
            return false;
        }
        return true;
    }

    public boolean hasNonScalar() {
        return this.objs != null;
    }

    public static boolean areCompatibleScalarTypes(JSType lhs, JSType rhs) {
        Preconditions.checkArgument((lhs.isSubtypeOf(TOP_SCALAR) || rhs.isSubtypeOf(TOP_SCALAR) ? 1 : 0) != 0);
        return lhs.isBottom() || rhs.isBottom() || lhs.isUnknown() || rhs.isUnknown() || lhs.isBoolean() && rhs.isBoolean() || lhs.equals(rhs);
    }

    public static JSType join(JSType lhs, JSType rhs) {
        if (lhs.isTop() || rhs.isTop()) {
            return TOP;
        }
        if (lhs.isUnknown() || rhs.isUnknown()) {
            return UNKNOWN;
        }
        return new JSType(lhs.type | rhs.type, Objects.equal((Object)lhs.location, (Object)rhs.location) ? lhs.location : null, ObjectType.joinSets(lhs.objs, rhs.objs));
    }

    public JSType specialize(JSType other) {
        if (other.isTop() || other.isUnknown()) {
            return this;
        }
        if (other.isTruthy()) {
            return this.makeTruthy();
        }
        if (other.isFalsy()) {
            return this.makeFalsy();
        }
        if (this.isTop() || this.isUnknown()) {
            return other.withLocation(this.location);
        }
        return new JSType(this.type & other.type, this.location, ObjectType.specializeSet(this.objs, other.objs));
    }

    private JSType makeTruthy() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        return new JSType(this.type & 0xFFFFFFDF & 0xFFFFFFEF & 0xFFFFFFFB, this.location, this.objs);
    }

    private JSType makeFalsy() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        return new JSType(this.type & 0xFFFFFFF7 & 0xFFFFFFBF, this.location, null);
    }

    public static JSType meet(JSType lhs, JSType rhs) {
        if (lhs.isTop()) {
            return rhs;
        }
        if (rhs.isTop()) {
            return lhs;
        }
        if (lhs.isUnknown()) {
            return rhs;
        }
        if (rhs.isUnknown()) {
            return lhs;
        }
        return new JSType(lhs.type & rhs.type, null, ObjectType.meetSets(lhs.objs, rhs.objs));
    }

    public static JSType plus(JSType lhs, JSType rhs) {
        int newtype = (lhs.type | rhs.type) & 1;
        if ((lhs.type & 0xFFFFFFFE) != 0 && (rhs.type & 0xFFFFFFFE) != 0) {
            newtype |= 2;
        }
        return new JSType(newtype);
    }

    public JSType negate() {
        if (this.isTruthy()) {
            return FALSY;
        }
        if (this.isFalsy()) {
            return TRUTHY;
        }
        return this;
    }

    public JSType toBoolean() {
        if (this.isTruthy()) {
            return TRUE_TYPE;
        }
        if (this.isFalsy()) {
            return FALSE_TYPE;
        }
        return BOOLEAN;
    }

    public boolean isSubtypeOf(JSType other) {
        if (this.isUnknown() || other.isUnknown() || other.isTop()) {
            return true;
        }
        if ((this.type | other.type) != other.type) {
            return false;
        }
        if (this.objs == null) {
            return true;
        }
        return ObjectType.isUnionSubtype(this.objs, other.objs);
    }

    public JSType removeType(JSType other) {
        if ((this.isTop() || this.isUnknown()) && other.equals(NULL)) {
            return TOP_MINUS_NULL;
        }
        if ((this.isTop() || this.isUnknown()) && other.equals(UNDEFINED)) {
            return TOP_MINUS_UNDEF;
        }
        if (other.equals(NULL) || other.equals(UNDEFINED)) {
            return new JSType(this.type & ~other.type, this.location, this.objs);
        }
        if (this.objs == null) {
            return this;
        }
        Preconditions.checkState(((other.type & 0xFFFFFFBF) == 0 && other.objs.size() == 1 ? 1 : 0) != 0);
        NominalType otherKlass = ((ObjectType)Iterables.getOnlyElement(other.objs)).getClassType();
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : this.objs) {
            if (Objects.equal((Object)obj.getClassType(), (Object)otherKlass)) continue;
            newObjs.add((Object)obj);
        }
        return new JSType(this.type, this.location, (ImmutableSet<ObjectType>)newObjs.build());
    }

    public JSType withLocation(String location) {
        return new JSType(this.type, location, this.objs);
    }

    public String getLocation() {
        return this.location;
    }

    public FunctionType getFunTypeIfSingletonObj() {
        if (this.type != 64 || this.objs.size() > 1) {
            return null;
        }
        return ((ObjectType)Iterables.getOnlyElement(this.objs)).getFunType();
    }

    public FunctionType getFunType() {
        if (this.objs == null) {
            return null;
        }
        Preconditions.checkState((this.objs.size() == 1 ? 1 : 0) != 0);
        return ((ObjectType)Iterables.getOnlyElement(this.objs)).getFunType();
    }

    NominalType getClassTypeIfUnique() {
        if (this.objs == null || this.objs.size() > 1) {
            return null;
        }
        return ((ObjectType)Iterables.getOnlyElement(this.objs)).getClassType();
    }

    public JSType withLoose() {
        Preconditions.checkNotNull(this.objs);
        return new JSType(this.type, this.location, ObjectType.withLooseObjects(this.objs));
    }

    public JSType getProp(String qName) {
        if (this.isUnknown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((this.objs != null ? 1 : 0) != 0);
        JSType ptype = BOTTOM;
        for (ObjectType o : this.objs) {
            if (!o.mayHaveProp(qName)) continue;
            ptype = JSType.join(ptype, o.getProp(qName));
        }
        if (ptype.isBottom()) {
            return null;
        }
        return ptype;
    }

    public boolean mayHaveProp(String qName) {
        if (this.objs == null) {
            return false;
        }
        for (ObjectType o : this.objs) {
            if (!o.mayHaveProp(qName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProp(String qName) {
        if (this.objs == null) {
            return false;
        }
        for (ObjectType o : this.objs) {
            if (o.hasProp(qName)) continue;
            return false;
        }
        return true;
    }

    public JSType getDeclaredProp(String qName) {
        if (this.isUnknown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((this.objs != null ? 1 : 0) != 0);
        JSType ptype = BOTTOM;
        for (ObjectType o : this.objs) {
            JSType declType = o.getDeclaredProp(qName);
            if (declType == null) continue;
            ptype = JSType.join(ptype, declType);
        }
        return ptype.isBottom() ? null : ptype;
    }

    public JSType withoutProperty(String qname) {
        return this.objs == null ? this : new JSType(this.type, this.location, ObjectType.withoutProperty(this.objs, qname));
    }

    public JSType withProperty(String qname, JSType type) {
        if (this.isUnknown()) {
            return this;
        }
        Preconditions.checkState((this.objs != null ? 1 : 0) != 0);
        return new JSType(this.type, this.location, ObjectType.withProperty(this.objs, qname, type));
    }

    public JSType withDeclaredProperty(String qname, JSType type) {
        Preconditions.checkState((this.objs != null && this.location == null ? 1 : 0) != 0);
        return new JSType(this.type, null, ObjectType.withDeclaredProperty(this.objs, qname, type));
    }

    public JSType withPropertyRequired(String qname) {
        return this.isUnknown() || this.objs == null ? this : new JSType(this.type, this.location, ObjectType.withPropertyRequired(this.objs, qname));
    }

    public String toString() {
        return String.valueOf(this.typeToString()) + JSType.locationPostfix(this.location);
    }

    private String typeToString() {
        switch (this.type) {
            case -1: 
            case 0: 
            case 0x7FFFFFFF: {
                return JSType.tagToString(this.type, null);
            }
        }
        int tags = this.type;
        TreeSet types = Sets.newTreeSet();
        int mask = 1;
        while (mask != 128) {
            if ((tags & mask) != 0) {
                types.add(JSType.tagToString(mask, this.objs));
                tags &= ~mask;
            }
            mask <<= 1;
        }
        if (tags == 0) {
            return Joiner.on((String)"|").join((Iterable)types);
        }
        return "Unrecognized type: " + tags;
    }

    private static String locationPostfix(String location) {
        if (location == null) {
            return "";
        }
        return "@" + location;
    }

    private static String tagToString(int tag, Set<ObjectType> objs) {
        switch (tag) {
            case 8: 
            case 16: {
                return "boolean";
            }
            case 0: {
                return "bottom";
            }
            case 1: {
                return "string";
            }
            case 64: {
                HashSet strReps = Sets.newHashSet();
                for (ObjectType obj : objs) {
                    strReps.add(obj.toString());
                }
                return Joiner.on((String)"|").join((Iterable)strReps);
            }
            case 32: {
                return "null";
            }
            case 2: {
                return "number";
            }
            case -1: {
                return "top";
            }
            case 4: {
                return "undefined";
            }
            case 0x7FFFFFFF: {
                return "unknown";
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(o instanceof JSType));
        JSType t2 = (JSType)o;
        return this.type == t2.type && Objects.equal(this.objs, t2.objs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.objs});
    }
}

