/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.newtypes;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.NominalType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.ObjectType;
import com.google.gwt.thirdparty.javascript.rhino.JSDocInfo;
import com.google.gwt.thirdparty.javascript.rhino.JSTypeExpression;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.SimpleErrorReporter;
import com.google.gwt.thirdparty.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JSTypeCreatorFromJSDoc {
    private SimpleErrorReporter reporter = new SimpleErrorReporter();

    public JSType getNodeTypeDeclaration(JSDocInfo jsdoc, DeclaredTypeRegistry registry) {
        if (jsdoc == null) {
            return null;
        }
        return this.getTypeFromJSTypeExpression(jsdoc.getType(), registry);
    }

    public Set<String> getWarnings() {
        HashSet warnings = Sets.newHashSet();
        if (this.reporter.warnings() != null) {
            warnings.addAll(this.reporter.warnings());
        }
        return warnings;
    }

    public JSType getTypeFromJSTypeExpression(JSTypeExpression expr, DeclaredTypeRegistry registry) {
        if (expr == null) {
            return null;
        }
        JSType result = this.getTypeFromNode(expr.getRootNode(), registry);
        return result;
    }

    JSType getTypeFromNode(Node n, DeclaredTypeRegistry registry) {
        try {
            return this.getTypeFromNodeHelper(n, registry);
        }
        catch (UnknownTypeException e) {
            this.warn("Unknown type", n);
            return null;
        }
    }

    private JSType getTypeFromNodeHelper(Node n, DeclaredTypeRegistry registry) throws UnknownTypeException {
        Preconditions.checkNotNull((Object)n);
        switch (n.getType()) {
            case 309: {
                HashMap fields = Maps.newHashMap();
                Node fieldTypeNode = n.getFirstChild().getFirstChild();
                while (fieldTypeNode != null) {
                    Preconditions.checkState((fieldTypeNode.getType() == 310 ? 1 : 0) != 0);
                    Node fieldNameNode = fieldTypeNode.getFirstChild();
                    String fieldName = fieldNameNode.getString();
                    if (fieldName.startsWith("'") || fieldName.startsWith("\"")) {
                        fieldName = fieldName.substring(1, fieldName.length() - 1);
                    }
                    JSType fieldType = this.getTypeFromNodeHelper(fieldTypeNode.getLastChild(), registry);
                    fields.put(fieldName, fieldType);
                    fieldTypeNode = fieldTypeNode.getNext();
                }
                return JSType.fromObjectType(ObjectType.fromProperties(fields));
            }
            case 124: {
                return JSType.UNKNOWN;
            }
            case 122: {
                return JSType.UNDEFINED;
            }
            case 40: {
                String typeName = n.getString();
                if (typeName.equals("boolean")) {
                    return JSType.BOOLEAN;
                }
                if (typeName.equals("null")) {
                    return JSType.NULL;
                }
                if (typeName.equals("number")) {
                    return JSType.NUMBER;
                }
                if (typeName.equals("string")) {
                    return JSType.STRING;
                }
                if (typeName.equals("undefined")) {
                    return JSType.UNDEFINED;
                }
                JSType namedType = registry.getNominalTypeAsJstype(typeName);
                if (namedType != null) {
                    return namedType;
                }
                throw new UnknownTypeException("Unhandled type: " + typeName);
            }
            case 301: {
                JSType union = JSType.BOTTOM;
                Node child = n.getFirstChild();
                while (child != null) {
                    union = JSType.join(union, this.getTypeFromNodeHelper(child, registry));
                    child = child.getNext();
                }
                return union;
            }
            case 306: {
                return this.getTypeFromNodeHelper(n.getFirstChild(), registry).removeType(JSType.NULL);
            }
            case 304: {
                Node child = n.getFirstChild();
                if (child == null) {
                    return JSType.UNKNOWN;
                }
                return JSType.join(JSType.NULL, this.getTypeFromNodeHelper(child, registry));
            }
            case 302: {
                return JSType.TOP;
            }
            case 105: {
                FunctionTypeBuilder builder = new FunctionTypeBuilder();
                Node child = n.getFirstChild();
                if (child.getType() == 42) {
                    builder.addReceiverType(this.getClassType(child.getFirstChild(), registry));
                    child = child.getNext();
                } else if (child.getType() == 30) {
                    builder.addClass(this.getClassType(child.getFirstChild(), registry));
                    child = child.getNext();
                }
                if (child.getType() == 83) {
                    Node arg = child.getFirstChild();
                    while (arg != null) {
                        try {
                            switch (arg.getType()) {
                                case 307: {
                                    builder.addOptFormal(this.getTypeFromNodeHelper(arg.getFirstChild(), registry));
                                    break;
                                }
                                case 305: {
                                    builder.addRestFormals(this.getTypeFromNodeHelper(arg.getFirstChild(), registry));
                                    break;
                                }
                                default: {
                                    builder.addReqFormal(this.getTypeFromNodeHelper(arg, registry));
                                    break;
                                }
                            }
                        }
                        catch (IllegalStateException e) {
                            this.warn("Wrong parameter order: required parameters are first, then optional, then varargs", n);
                        }
                        arg = arg.getNext();
                    }
                    child = child.getNext();
                }
                builder.addRetType(this.getTypeFromNodeHelper(child, registry));
                return builder.buildType();
            }
        }
        throw new IllegalArgumentException("Unsupported type exp: " + Token.name(n.getType()) + " " + n.toStringTree());
    }

    public boolean hasKnownType(Node n, DeclaredTypeRegistry registry) {
        try {
            this.getTypeFromNodeHelper(n, registry);
        }
        catch (UnknownTypeException e) {
            return false;
        }
        return true;
    }

    public NominalType getClassType(Node n, DeclaredTypeRegistry registry) {
        JSType wrappedClass = this.getTypeFromNode(n, registry);
        if (wrappedClass == null) {
            return null;
        }
        return wrappedClass.getClassTypeIfUnique();
    }

    public ImmutableSet<NominalType> getImplementedInterfaces(JSDocInfo jsdoc, DeclaredTypeRegistry registry) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JSTypeExpression texp : jsdoc.getImplementedInterfaces()) {
            Node expRoot = texp.getRootNode();
            if (this.hasKnownType(expRoot, registry)) {
                builder.add((Object)this.getClassType(expRoot, registry));
                continue;
            }
            this.warn("Cannot implement unknown type", expRoot);
        }
        return builder.build();
    }

    public ImmutableSet<NominalType> getExtendedInterfaces(JSDocInfo jsdoc, DeclaredTypeRegistry registry) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JSTypeExpression texp : jsdoc.getExtendedInterfaces()) {
            builder.add((Object)this.getClassType(texp.getRootNode(), registry));
        }
        return builder.build();
    }

    public FunctionTypeBuilder getFunctionType(JSDocInfo jsdoc, Node funNode, DeclaredTypeRegistry registry) {
        try {
            if (jsdoc != null && jsdoc.getType() != null) {
                Node jsdocNode = jsdoc.getType().getRootNode();
                if (jsdocNode.getType() == 105) {
                    return this.getFunTypeFromAtTypeJsdoc(jsdoc, funNode, registry);
                }
                this.warn("The function is annotated with a non-function jsdoc. Ignoring jsdoc.", funNode);
            }
            return this.getFunTypeFromTypicalFunctionJsdoc(jsdoc, funNode, registry, false);
        }
        catch (IllegalStateException e) {
            this.warn("Wrong parameter order: required parameters are first, then optional, then varargs. Ignoring jsdoc.", funNode);
            return this.getFunTypeFromTypicalFunctionJsdoc(null, funNode, registry, true);
        }
    }

    private FunctionTypeBuilder getFunTypeFromAtTypeJsdoc(JSDocInfo jsdoc, Node funNode, DeclaredTypeRegistry registry) {
        Node paramType;
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Node childJsdoc = jsdoc.getType().getRootNode().getFirstChild();
        Node param = funNode.getFirstChild().getNext().getFirstChild();
        boolean warnedForMissingTypes = false;
        boolean warnedForInlineJsdoc = false;
        if (childJsdoc.getType() == 42) {
            builder.addReceiverType(this.getClassType(childJsdoc.getFirstChild(), registry));
            childJsdoc = childJsdoc.getNext();
        } else if (childJsdoc.getType() == 30) {
            builder.addClass(this.getClassType(childJsdoc.getFirstChild(), registry));
            childJsdoc = childJsdoc.getNext();
        }
        if (childJsdoc.getType() == 83) {
            paramType = childJsdoc.getFirstChild();
            childJsdoc = childJsdoc.getNext();
        } else {
            paramType = null;
        }
        while (param != null) {
            if (paramType == null) {
                if (!warnedForMissingTypes) {
                    this.warn("The function has more formal parameters than the types declared in the JSDoc", funNode);
                    warnedForMissingTypes = true;
                }
                builder.addOptFormal(null);
            } else {
                if (!warnedForInlineJsdoc && param.getJSDocInfo() != null) {
                    this.warn("The function cannot have both an @type jsdoc and inline jsdocs. Ignoring inline jsdocs.", param);
                    warnedForInlineJsdoc = true;
                }
                switch (paramType.getType()) {
                    case 307: {
                        builder.addOptFormal(this.getTypeFromNode(paramType.getFirstChild(), registry));
                        break;
                    }
                    case 305: {
                        if (warnedForMissingTypes) break;
                        this.warn("The function has more formal parameters than the types declared in the JSDoc", funNode);
                        warnedForMissingTypes = true;
                        builder.addOptFormal(null);
                        break;
                    }
                    default: {
                        builder.addReqFormal(this.getTypeFromNode(paramType, registry));
                    }
                }
                paramType = paramType.getNext();
            }
            param = param.getNext();
        }
        if (paramType != null) {
            if (paramType.getType() == 305) {
                builder.addRestFormals(this.getTypeFromNode(paramType.getFirstChild(), registry));
            } else {
                this.warn("The function has fewer formal parameters than the types declared in the JSDoc", funNode);
            }
        }
        if (!warnedForInlineJsdoc && funNode.getFirstChild().getJSDocInfo() != null) {
            this.warn("The function cannot have both an @type jsdoc and inline jsdocs. Ignoring the inline return jsdoc.", funNode);
        }
        if (jsdoc.getReturnType() != null) {
            this.warn("The function cannot have both an @type jsdoc and @return jsdoc. Ignoring @return jsdoc.", funNode);
        }
        builder.addRetType(this.getTypeFromNode(childJsdoc, registry));
        return builder;
    }

    private FunctionTypeBuilder getFunTypeFromTypicalFunctionJsdoc(JSDocInfo jsdoc, Node funNode, DeclaredTypeRegistry registry, boolean ignoreJsdoc) {
        JSTypeExpression retTypeExp;
        Preconditions.checkArgument((!ignoreJsdoc || jsdoc == null ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Node params = funNode.getFirstChild().getNext();
        Node param = params.getFirstChild();
        while (param != null) {
            Node jsdocNode;
            String pname = param.getQualifiedName();
            JSType inlineParamType = ignoreJsdoc ? null : this.getNodeTypeDeclaration(param.getJSDocInfo(), registry);
            boolean isRequired = true;
            boolean isRestFormals = false;
            JSTypeExpression texp = jsdoc == null ? null : jsdoc.getParameterType(pname);
            Node node = jsdocNode = texp == null ? null : texp.getRootNode();
            if (jsdocNode != null && jsdocNode.getType() == 307) {
                isRequired = false;
                jsdocNode = jsdocNode.getFirstChild();
            } else if (jsdocNode != null && jsdocNode.getType() == 305) {
                isRequired = false;
                isRestFormals = true;
                jsdocNode = jsdocNode.getFirstChild();
            }
            JSType fnParamType = null;
            if (jsdocNode != null) {
                fnParamType = this.getTypeFromNode(jsdocNode, registry);
            }
            if (inlineParamType != null) {
                builder.addReqFormal(inlineParamType);
                if (fnParamType != null) {
                    this.warn("Found two JsDoc comments for formal parameter " + pname, param);
                }
            } else if (isRequired) {
                builder.addReqFormal(fnParamType);
            } else if (isRestFormals) {
                builder.addRestFormals(fnParamType);
            } else {
                builder.addOptFormal(fnParamType);
            }
            param = param.getNext();
        }
        JSDocInfo inlineRetJsdoc = ignoreJsdoc ? null : funNode.getFirstChild().getJSDocInfo();
        JSTypeExpression jSTypeExpression = retTypeExp = jsdoc == null ? null : jsdoc.getReturnType();
        if (inlineRetJsdoc != null) {
            builder.addRetType(this.getNodeTypeDeclaration(inlineRetJsdoc, registry));
            if (retTypeExp != null) {
                this.warn("Found two JsDoc comments for the return type", funNode);
            }
        } else {
            builder.addRetType(this.getTypeFromJSTypeExpression(retTypeExp, registry));
        }
        return builder;
    }

    void warn(String msg, Node faultyNode) {
        this.reporter.warning(msg, faultyNode.getSourceFileName(), faultyNode.getLineno(), faultyNode.getCharno());
    }

    public static class UnknownTypeException
    extends Exception {
        UnknownTypeException(String cause) {
            super(cause);
        }
    }
}

