/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.newtypes;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.ObjectType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.Property;
import java.util.Map;

public class NominalType {
    final String name;
    private Map<String, Property> classProps = Maps.newHashMap();
    private Map<String, Property> protoProps = Maps.newHashMap();
    private Map<String, Property> ctorProps = Maps.newHashMap();
    boolean isFinalized = false;
    private NominalType superClass = null;
    private ImmutableSet<NominalType> interfaces = null;
    private final boolean isInterface;
    private ImmutableSet<String> allProps = null;

    private NominalType(String name, boolean isInterface) {
        this.name = name;
        this.isInterface = isInterface;
    }

    public static NominalType makeClass(String name) {
        return new NominalType(name, false);
    }

    public static NominalType makeInterface(String name) {
        return new NominalType(name, true);
    }

    public boolean isClass() {
        return !this.isInterface;
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }

    public void addSuperClass(NominalType superClass) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        Preconditions.checkState((this.superClass == null ? 1 : 0) != 0);
        this.superClass = superClass;
    }

    public void addInterfaces(ImmutableSet<NominalType> interfaces) {
        Preconditions.checkState((this.interfaces == null ? 1 : 0) != 0);
        this.interfaces = interfaces;
    }

    public NominalType getSuperClass() {
        return this.superClass;
    }

    public ImmutableSet<NominalType> getInterfaces() {
        return this.interfaces;
    }

    private Property getOwnProp(String pname) {
        Property p = this.classProps.get(pname);
        if (p != null) {
            return p;
        }
        return this.protoProps.get(pname);
    }

    Property getPropFromClass(String pname) {
        Preconditions.checkState((!this.isInterface ? 1 : 0) != 0);
        Property p = this.getOwnProp(pname);
        if (p != null) {
            return p;
        }
        if (this.superClass != null && (p = this.superClass.getPropFromClass(pname)) != null) {
            return p;
        }
        return null;
    }

    Property getPropFromInterface(String pname) {
        Preconditions.checkState((boolean)this.isInterface);
        Property p = this.protoProps.get(pname);
        if (p != null) {
            return p;
        }
        if (this.interfaces != null) {
            for (NominalType interf : this.interfaces) {
                p = interf.getPropFromInterface(pname);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    private Property getProp(String pname) {
        if (this.isInterface) {
            return this.getPropFromInterface(pname);
        }
        return this.getPropFromClass(pname);
    }

    public boolean mayHaveOwnProp(String pname) {
        return this.getOwnProp(pname) != null;
    }

    public boolean mayHaveProp(String pname) {
        return this.getProp(pname) != null;
    }

    public JSType getPropDeclaredType(String pname) {
        Property p = this.getProp(pname);
        if (p == null) {
            return null;
        }
        if (p.getDeclaredType() == null && this.superClass != null) {
            return this.superClass.getPropDeclaredType(pname);
        }
        return p.getDeclaredType();
    }

    boolean isSubclassOf(NominalType other) {
        if (other.equals(this)) {
            return true;
        }
        if (this.superClass == null) {
            return false;
        }
        return this.superClass.isSubclassOf(other);
    }

    static NominalType pickSuperclass(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.isSubclassOf(c2)) {
            return c2;
        }
        Preconditions.checkState((boolean)c2.isSubclassOf(c1));
        return c1;
    }

    static NominalType pickSubclass(NominalType c1, NominalType c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isSubclassOf(c2)) {
            return c1;
        }
        Preconditions.checkState((boolean)c2.isSubclassOf(c1));
        return c2;
    }

    public ImmutableSet<String> getAllPropsOfInterface() {
        Preconditions.checkState((boolean)this.isInterface);
        if (this.allProps == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.interfaces != null) {
                for (NominalType interf : this.interfaces) {
                    builder.addAll(interf.getAllPropsOfInterface());
                }
            }
            this.allProps = builder.addAll(this.protoProps.keySet()).build();
        }
        return this.allProps;
    }

    public ImmutableSet<String> getAllPropsOfClass() {
        Preconditions.checkState((!this.isInterface ? 1 : 0) != 0);
        if (this.allProps == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.superClass != null) {
                builder.addAll(this.superClass.getAllPropsOfClass());
            }
            this.allProps = builder.addAll(this.classProps.keySet()).addAll(this.protoProps.keySet()).build();
        }
        return this.allProps;
    }

    public void addClassProperty(String pname, JSType type) {
        this.classProps.put(pname, new Property(type, type, false));
        if (this.protoProps.containsKey(pname)) {
            this.addProtoProperty(pname, type);
        }
    }

    public void addUndeclaredClassProperty(String pname) {
        if (this.mayHaveProp(pname)) {
            return;
        }
        this.classProps.put(pname, new Property(JSType.UNKNOWN, null, false));
    }

    public void addProtoProperty(String pname, JSType type) {
        if (this.classProps.containsKey(pname) && this.classProps.get(pname).getDeclaredType() == null) {
            this.classProps.remove(pname);
        }
        this.protoProps.put(pname, new Property(type, type, false));
    }

    public void addUndeclaredProtoProperty(String pname) {
        if (!this.protoProps.containsKey(pname) || this.protoProps.get(pname).getDeclaredType() == null) {
            this.protoProps.put(pname, new Property(JSType.UNKNOWN, null, false));
        }
    }

    private JSType createProtoObject() {
        return JSType.fromObjectType(ObjectType.makeObjectType(this.superClass, this.protoProps, null, false));
    }

    public boolean mayHaveCtorProp(String pname) {
        return this.ctorProps.containsKey(pname);
    }

    public void addCtorProperty(String pname, JSType type) {
        this.ctorProps.put(pname, new Property(type, type, false));
    }

    public void addUndeclaredCtorProperty(String pname) {
        if (this.ctorProps.containsKey(pname)) {
            return;
        }
        this.ctorProps.put(pname, new Property(JSType.UNKNOWN, null, false));
    }

    public JSType getCtorPropDeclaredType(String pname) {
        Property p = this.ctorProps.get(pname);
        Preconditions.checkState((p != null ? 1 : 0) != 0);
        return p.getDeclaredType();
    }

    JSType createConstructorObject(FunctionType ctorFn) {
        return JSType.fromObjectType(ObjectType.makeObjectType(null, this.ctorProps, ctorFn, ctorFn.isLoose()));
    }

    public NominalType finalizeNominalType() {
        this.classProps = ImmutableMap.copyOf(this.classProps);
        this.protoProps = ImmutableMap.copyOf(this.protoProps);
        this.addCtorProperty("prototype", this.createProtoObject());
        this.ctorProps = ImmutableMap.copyOf(this.ctorProps);
        this.isFinalized = true;
        return this;
    }

    public String toString() {
        return this.name;
    }
}

