/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.newtypes;

import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.NominalType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.Property;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.TypeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ObjectType {
    private final NominalType klass;
    private final FunctionType fn;
    private final boolean isLoose;
    private final ImmutableMap<String, Property> props;
    static final ObjectType TOP_OBJECT = ObjectType.makeObjectType(null, null, null, false);

    private ObjectType(NominalType klass, ImmutableMap<String, Property> props, FunctionType fn, boolean isLoose) {
        this.klass = klass;
        this.props = props;
        this.fn = fn;
        this.isLoose = isLoose;
    }

    static ObjectType makeObjectType(NominalType klass, Map<String, Property> props, FunctionType fn, boolean isLoose) {
        if (props == null) {
            props = ImmutableMap.of();
        }
        return new ObjectType(klass, (ImmutableMap<String, Property>)ImmutableMap.copyOf((Map)props), fn, isLoose);
    }

    static ObjectType fromFunction(FunctionType fn) {
        return ObjectType.makeObjectType(null, null, fn, fn.isLoose());
    }

    public static ObjectType fromClass(NominalType cl) {
        return ObjectType.makeObjectType(cl, null, null, false);
    }

    static ObjectType fromProperties(Map<String, JSType> props) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String propName : props.keySet()) {
            JSType propType = props.get(propName);
            builder.put((Object)propName, (Object)new Property(propType, propType, false));
        }
        return ObjectType.makeObjectType(null, (Map<String, Property>)builder.build(), null, false);
    }

    boolean isInhabitable() {
        for (String pname : this.props.keySet()) {
            if (((Property)this.props.get((Object)pname)).getType().isInhabitable()) continue;
            return false;
        }
        return true;
    }

    static ImmutableSet<ObjectType> withLooseObjects(Set<ObjectType> objs) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withLoose());
        }
        return newObjs.build();
    }

    private ObjectType withLoose() {
        if (this.klass != null) {
            return this;
        }
        FunctionType fn = this.fn == null ? null : this.fn.withLoose();
        HashMap newProps = Maps.newHashMap();
        for (String pname : this.props.keySet()) {
            newProps.put(pname, ((Property)this.props.get((Object)pname)).withRequired());
        }
        return ObjectType.makeObjectType(this.klass, newProps, fn, true);
    }

    static ImmutableSet<ObjectType> withoutProperty(Set<ObjectType> objs, String qname) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withProperty(qname, null));
        }
        return newObjs.build();
    }

    private ObjectType withPropertyHelper(String qname, JSType type, boolean isDeclared) {
        HashMap newProps = Maps.newHashMap(this.props);
        if (TypeUtils.isIdentifier(qname)) {
            if (type == null) {
                newProps.remove(qname);
            } else {
                newProps.put(qname, new Property(type, isDeclared ? type : null, false));
            }
        } else {
            String objName = qname.substring(0, qname.indexOf(46));
            String innerProps = qname.substring(qname.indexOf(46) + 1);
            if (!this.props.containsKey((Object)objName)) {
                Preconditions.checkState((boolean)this.mayHaveProp(objName));
                newProps.put(objName, this.getLeftmostProp(objName));
            }
            Property objProp = (Property)newProps.get(objName);
            newProps.put(objName, new Property(objProp.getType().withProperty(innerProps, type), objProp.getDeclaredType(), objProp.isOptional()));
        }
        return ObjectType.makeObjectType(this.klass, newProps, this.fn, this.isLoose);
    }

    ObjectType withProperty(String qname, JSType type) {
        return this.withPropertyHelper(qname, type, false);
    }

    static ImmutableSet<ObjectType> withProperty(Set<ObjectType> objs, String qname, JSType type) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withProperty(qname, type));
        }
        return newObjs.build();
    }

    static ImmutableSet<ObjectType> withDeclaredProperty(Set<ObjectType> objs, String qname, JSType type) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withPropertyHelper(qname, type, true));
        }
        return newObjs.build();
    }

    private ObjectType withPropertyRequired(String qname) {
        Preconditions.checkArgument((boolean)TypeUtils.isIdentifier(qname));
        HashMap newProps = Maps.newHashMap(this.props);
        Property oldProp = (Property)this.props.get((Object)qname);
        Property newProp = oldProp == null ? new Property(JSType.UNKNOWN, null, false) : new Property(oldProp.getType(), oldProp.getDeclaredType(), false);
        newProps.put(qname, newProp);
        return ObjectType.makeObjectType(this.klass, newProps, this.fn, this.isLoose);
    }

    static ImmutableSet<ObjectType> withPropertyRequired(Set<ObjectType> objs, String qname) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withPropertyRequired(qname));
        }
        return newObjs.build();
    }

    private static Map<String, Property> meetPropsHelper(boolean specializeProps1, Map<String, Property> props1, Map<String, Property> props2) {
        HashMap newProps = Maps.newHashMap();
        for (String pname : props1.keySet()) {
            if (props2.containsKey(pname)) continue;
            newProps.put(pname, props1.get(pname));
        }
        for (String pname : props2.keySet()) {
            Property prop2 = props2.get(pname);
            if (props1.containsKey(pname)) {
                newProps.put(pname, specializeProps1 ? props1.get(pname).specialize(prop2) : Property.meet(props1.get(pname), prop2));
                continue;
            }
            newProps.put(pname, prop2);
        }
        return newProps;
    }

    private static Map<String, Property> joinProps(Map<String, Property> props1, Map<String, Property> props2) {
        HashMap newProps = Maps.newHashMap();
        for (String pname : props1.keySet()) {
            if (props2.containsKey(pname)) continue;
            newProps.put(pname, props1.get(pname).withOptional());
        }
        for (String pname : props2.keySet()) {
            Property prop2 = props2.get(pname);
            if (props1.containsKey(pname)) {
                newProps.put(pname, Property.join(props1.get(pname), prop2));
                continue;
            }
            newProps.put(pname, prop2.withOptional());
        }
        return newProps;
    }

    private static Map<String, Property> joinPropsLoosely(Map<String, Property> props1, Map<String, Property> props2) {
        HashMap newProps = Maps.newHashMap();
        for (String pname : props1.keySet()) {
            if (props2.containsKey(pname)) continue;
            newProps.put(pname, props1.get(pname).withRequired());
        }
        for (String pname : props2.keySet()) {
            Property prop2 = props2.get(pname);
            if (props1.containsKey(pname)) {
                newProps.put(pname, Property.join(props1.get(pname), prop2).withRequired());
                continue;
            }
            newProps.put(pname, prop2.withRequired());
        }
        return newProps;
    }

    static boolean isUnionSubtype(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        for (ObjectType obj1 : objs1) {
            boolean foundSupertype = false;
            for (ObjectType obj2 : objs2) {
                if (!obj1.isSubtypeOf(obj2)) continue;
                foundSupertype = true;
                break;
            }
            if (foundSupertype) continue;
            return false;
        }
        return true;
    }

    boolean isSubtypeOf(ObjectType obj2) {
        if (this.isLoose || obj2.isLoose) {
            return this.isLooseSubtypeOf(obj2);
        }
        for (String pname : obj2.props.keySet()) {
            Property prop2 = (Property)obj2.props.get((Object)pname);
            Property prop1 = this.getLeftmostProp(pname);
            if (!(prop2.isOptional() ? prop1 != null && !prop1.getType().isSubtypeOf(prop2.getType()) : prop1 == null || prop1.isOptional() || !prop1.getType().isSubtypeOf(prop2.getType()))) continue;
            return false;
        }
        if (this.klass == null && obj2.klass != null || this.klass != null && obj2.klass != null && !this.klass.isSubclassOf(obj2.klass)) {
            return false;
        }
        if (obj2.fn == null) {
            return true;
        }
        if (this.fn == null) {
            return false;
        }
        return this.fn.isSubtypeOf(obj2.fn);
    }

    boolean isLooseSubtypeOf(ObjectType obj2) {
        if (obj2 == TOP_OBJECT) {
            return true;
        }
        for (String pname : obj2.props.keySet()) {
            if (!this.props.containsKey((Object)pname) || ((Property)this.props.get((Object)pname)).getType().isSubtypeOf(((Property)obj2.props.get((Object)pname)).getType())) continue;
            return false;
        }
        if (obj2.fn == null) {
            return true;
        }
        if (this.fn == null) {
            return false;
        }
        return this.fn.isLooseSubtypeOf(obj2.fn);
    }

    ObjectType specialize(ObjectType obj2) {
        Preconditions.checkState((boolean)ObjectType.areRelatedClasses(this.klass, obj2.klass));
        return ObjectType.makeObjectType(NominalType.pickSubclass(this.klass, obj2.klass), ObjectType.meetPropsHelper(true, this.props, obj2.props), this.fn == null ? null : this.fn.specialize(obj2.fn), this.isLoose || obj2.isLoose);
    }

    static ObjectType meet(ObjectType obj1, ObjectType obj2) {
        Preconditions.checkState((boolean)ObjectType.areRelatedClasses(obj1.klass, obj2.klass));
        return ObjectType.makeObjectType(NominalType.pickSubclass(obj1.klass, obj2.klass), ObjectType.meetPropsHelper(false, obj1.props, obj2.props), FunctionType.meet(obj1.fn, obj2.fn), obj1.isLoose || obj2.isLoose);
    }

    static ObjectType join(ObjectType obj1, ObjectType obj2) {
        Preconditions.checkState((boolean)ObjectType.areRelatedClasses(obj1.klass, obj2.klass));
        return ObjectType.makeObjectType(NominalType.pickSuperclass(obj1.klass, obj2.klass), obj1.isLoose || obj2.isLoose ? ObjectType.joinPropsLoosely(obj1.props, obj2.props) : ObjectType.joinProps(obj1.props, obj2.props), FunctionType.join(obj1.fn, obj2.fn), obj1.isLoose || obj2.isLoose);
    }

    static ImmutableSet<ObjectType> joinSets(ImmutableSet<ObjectType> objs1, ImmutableSet<ObjectType> objs2) {
        if (objs1 == null) {
            return objs2;
        }
        if (objs2 == null) {
            return objs1;
        }
        HashSet newObjs = Sets.newHashSet(objs1);
        for (ObjectType obj2 : objs2) {
            boolean addedObj2 = false;
            for (ObjectType obj1 : objs1) {
                NominalType klass1 = obj1.klass;
                NominalType klass2 = obj2.klass;
                if (!ObjectType.areRelatedClasses(klass1, klass2)) continue;
                if (klass2 == null && klass1 != null && !obj1.isSubtypeOf(obj2) || klass1 == null && klass2 != null && !obj2.isSubtypeOf(obj1)) break;
                newObjs.remove(obj1);
                newObjs.add(ObjectType.join(obj1, obj2));
                addedObj2 = true;
                break;
            }
            if (addedObj2) continue;
            newObjs.add(obj2);
        }
        return ImmutableSet.copyOf((Collection)newObjs);
    }

    private static boolean areRelatedClasses(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return true;
        }
        return c1.isSubclassOf(c2) || c2.isSubclassOf(c1);
    }

    static ImmutableSet<ObjectType> meetSetsHelper(boolean specializeObjs1, Set<ObjectType> objs1, Set<ObjectType> objs2) {
        if (objs1 == null || objs2 == null) {
            return null;
        }
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        block0: for (ObjectType obj2 : objs2) {
            for (ObjectType obj1 : objs1) {
                if (!ObjectType.areRelatedClasses(obj1.klass, obj2.klass)) continue;
                newObjs.add((Object)(specializeObjs1 ? obj1.specialize(obj2) : ObjectType.meet(obj1, obj2)));
                continue block0;
            }
        }
        return newObjs.build();
    }

    static ImmutableSet<ObjectType> meetSets(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        return ObjectType.meetSetsHelper(false, objs1, objs2);
    }

    static ImmutableSet<ObjectType> specializeSet(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        return ObjectType.meetSetsHelper(true, objs1, objs2);
    }

    FunctionType getFunType() {
        return this.fn;
    }

    JSType getProp(String qname) {
        Property p = this.getLeftmostProp(qname);
        if (TypeUtils.isIdentifier(qname)) {
            return p == null ? JSType.UNDEFINED : p.getType();
        }
        Preconditions.checkState((p != null ? 1 : 0) != 0);
        return p.getType().getProp(TypeUtils.getPropPath(qname));
    }

    NominalType getClassType() {
        return this.klass;
    }

    boolean mayHaveProp(String qname) {
        Property p = this.getLeftmostProp(qname);
        return p != null && (TypeUtils.isIdentifier(qname) || p.getType().mayHaveProp(TypeUtils.getPropPath(qname)));
    }

    boolean hasProp(String pname) {
        Preconditions.checkArgument((boolean)TypeUtils.isIdentifier(pname));
        Property p = this.getLeftmostProp(pname);
        return p != null && !p.isOptional();
    }

    public JSType getDeclaredProp(String pname) {
        Preconditions.checkArgument((boolean)TypeUtils.isIdentifier(pname));
        Property p = this.getLeftmostProp(pname);
        if (p == null) {
            return null;
        }
        return p.isDeclared() ? p.getDeclaredType() : null;
    }

    private Property getLeftmostProp(String qname) {
        String objName = TypeUtils.getQnameRoot(qname);
        Property p = (Property)this.props.get((Object)objName);
        if (p == null && this.klass != null) {
            p = this.klass.getPropFromClass(objName);
        }
        return p;
    }

    public String toString() {
        if (this.props.isEmpty() && this.fn != null) {
            return this.fn.toString();
        }
        TreeSet propStrings = Sets.newTreeSet();
        for (String pname : this.props.keySet()) {
            propStrings.add(String.valueOf(pname) + " : " + ((Property)this.props.get((Object)pname)).toString());
        }
        String result = this.klass == null ? "" : this.klass.name;
        result = String.valueOf(result) + (this.klass != null && propStrings.isEmpty() ? "" : "{" + Joiner.on((String)", ").join((Iterable)propStrings) + "}");
        result = String.valueOf(result) + (this.isLoose ? " (loose)" : "");
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(o instanceof ObjectType));
        ObjectType obj2 = (ObjectType)o;
        return Objects.equal((Object)this.fn, (Object)obj2.fn) && Objects.equal((Object)this.klass, (Object)obj2.klass) && Objects.equal(this.props, obj2.props);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fn, this.props, this.klass});
    }
}

