/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.newtypes;

import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;

class Property {
    private final JSType inferredType;
    private final JSType declaredType;
    private boolean isOptional;

    Property(JSType inferredType, JSType declaredType, boolean isOptional) {
        this.inferredType = inferredType;
        this.declaredType = declaredType;
        this.isOptional = isOptional;
    }

    boolean isOptional() {
        return this.isOptional;
    }

    boolean isDeclared() {
        return this.declaredType != null;
    }

    JSType getType() {
        return this.inferredType;
    }

    JSType getDeclaredType() {
        return this.declaredType;
    }

    Property withOptional() {
        return new Property(this.inferredType, this.declaredType, true);
    }

    Property withRequired() {
        return new Property(this.inferredType, this.declaredType, false);
    }

    Property specialize(Property other) {
        return new Property(this.inferredType.specialize(other.inferredType), this.declaredType, this.isOptional && other.isOptional);
    }

    static Property meet(Property p1, Property p2) {
        return new Property(JSType.meet(p1.inferredType, p2.inferredType), null, p1.isOptional && p2.isOptional);
    }

    static Property join(Property p1, Property p2) {
        JSType p1decl = p1.declaredType;
        JSType p2decl = p2.declaredType;
        JSType declType = p1decl == null || p2decl == null ? null : (p1decl.equals(p2decl) ? p1decl : null);
        return new Property(JSType.join(p1.inferredType, p2.inferredType), declType, p1.isOptional || p2.isOptional);
    }

    public String toString() {
        return String.valueOf(this.inferredType.toString()) + (this.isOptional ? "=" : "");
    }

    public boolean equals(Object o) {
        Preconditions.checkArgument((boolean)(o instanceof Property));
        Property p2 = (Property)o;
        return this.inferredType.equals(p2.inferredType) && this.isOptional == p2.isOptional;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.inferredType, this.isOptional});
    }
}

