/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.codegeneration;

import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.Keywords;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.ParseTreeVisitor;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.Token;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.TokenType;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.AwaitStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ClassExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FieldDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForEachStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportPathTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinResolveListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinResolveTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ModuleDefinitionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectPatternFieldTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.RequiresMemberTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SpreadPatternElementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.TraitDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.YieldStatementTree;
import java.util.List;

public final class ParseTreeWriter
extends ParseTreeVisitor {
    private final StringBuilder result;
    private StringBuilder currentLine;
    private String currentLineComment;
    private static final String NEW_LINE = "\n";
    private int indentDepth;
    private final boolean PRETTY_PRINT = true;
    private final boolean SHOW_LINE_NUMBERS;
    private final ParseTree HIGHLIGHTED;

    private ParseTreeWriter(ParseTree highlighted, boolean showLineNumbers) {
        this.SHOW_LINE_NUMBERS = showLineNumbers;
        this.result = new StringBuilder();
        this.indentDepth = 0;
        this.currentLine = new StringBuilder();
        this.currentLineComment = null;
        this.HIGHLIGHTED = highlighted;
    }

    public static String write(ParseTree tree) {
        return ParseTreeWriter.write(tree, null, true);
    }

    public static String write(ParseTree tree, boolean showLineNumbers) {
        return ParseTreeWriter.write(tree, null, showLineNumbers);
    }

    public static String write(ParseTree tree, ParseTree highlighted, boolean showLineNumbers) {
        ParseTreeWriter writer = new ParseTreeWriter(highlighted, showLineNumbers);
        writer.visitAny(tree);
        if (writer.currentLine.length() > 0) {
            writer.writeln();
        }
        return writer.result.toString();
    }

    @Override
    protected void visitAny(ParseTree tree) {
        if (tree != null && tree == this.HIGHLIGHTED) {
            this.write("\u001b[41m");
        }
        if (tree != null && tree.location != null && tree.location.start != null && this.SHOW_LINE_NUMBERS) {
            this.currentLineComment = "Line: " + (tree.location.start.line + 1);
        }
        super.visitAny(tree);
        if (tree != null && tree == this.HIGHLIGHTED) {
            this.write("\u001b[0m");
        }
    }

    @Override
    protected void visit(ArgumentListTree tree) {
        this.write(TokenType.OPEN_PAREN);
        this.writeList((List<? extends ParseTree>)tree.arguments, TokenType.COMMA, false);
        this.write(TokenType.CLOSE_PAREN);
    }

    @Override
    protected void visit(ArrayLiteralExpressionTree tree) {
        this.write(TokenType.OPEN_SQUARE);
        this.writeList((List<? extends ParseTree>)tree.elements, TokenType.COMMA, false);
        this.write(TokenType.CLOSE_SQUARE);
    }

    @Override
    public void visit(ArrayPatternTree tree) {
        this.write(TokenType.OPEN_SQUARE);
        this.writeList((List<? extends ParseTree>)tree.elements, TokenType.COMMA, false);
        this.write(TokenType.CLOSE_SQUARE);
    }

    @Override
    public void visit(AwaitStatementTree tree) {
        this.write(TokenType.AWAIT);
        if (tree.identifier != null) {
            this.write(tree.identifier);
            this.write(TokenType.EQUAL);
        }
        this.visitAny(tree.expression);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(BinaryOperatorTree tree) {
        this.visitAny(tree.left);
        this.write(tree.operator);
        this.visitAny(tree.right);
    }

    @Override
    protected void visit(BlockTree tree) {
        this.write(TokenType.OPEN_CURLY);
        this.writelnList((List<? extends ParseTree>)tree.statements);
        this.write(TokenType.CLOSE_CURLY);
    }

    @Override
    protected void visit(BreakStatementTree tree) {
        this.write(TokenType.BREAK);
        if (tree.name != null) {
            this.write(tree.name);
        }
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(CallExpressionTree tree) {
        this.visitAny(tree.operand);
        this.visitAny(tree.arguments);
    }

    @Override
    protected void visit(CaseClauseTree tree) {
        this.write(TokenType.CASE);
        this.visitAny(tree.expression);
        this.write(TokenType.COLON);
        ++this.indentDepth;
        this.writelnList((List<? extends ParseTree>)tree.statements);
        --this.indentDepth;
    }

    @Override
    protected void visit(CatchTree tree) {
        this.write(TokenType.CATCH);
        this.write(TokenType.OPEN_PAREN);
        this.write(tree.exceptionName);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.catchBody);
    }

    @Override
    protected void visit(ClassDeclarationTree tree) {
        this.write(TokenType.CLASS);
        this.write(tree.name);
        if (tree.superClass != null) {
            this.write(TokenType.COLON);
            this.visitAny(tree.superClass);
        }
        this.write(TokenType.OPEN_CURLY);
        this.writelnList((List<? extends ParseTree>)tree.elements);
        this.write(TokenType.CLOSE_CURLY);
    }

    @Override
    protected void visit(ClassExpressionTree tree) {
        this.write(TokenType.CLASS);
    }

    @Override
    protected void visit(CommaExpressionTree tree) {
        this.writeList((List<? extends ParseTree>)tree.expressions, TokenType.COMMA, false);
    }

    @Override
    protected void visit(ConditionalExpressionTree tree) {
        this.visitAny(tree.condition);
        this.write(TokenType.QUESTION);
        this.visitAny(tree.left);
        this.write(TokenType.COLON);
        this.visitAny(tree.right);
    }

    @Override
    protected void visit(ContinueStatementTree tree) {
        this.write(TokenType.CONTINUE);
        if (tree.name != null) {
            this.write(tree.name);
        }
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(DebuggerStatementTree tree) {
        this.write(TokenType.DEBUGGER);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(DefaultClauseTree tree) {
        this.write(TokenType.DEFAULT);
        this.write(TokenType.COLON);
        ++this.indentDepth;
        this.writelnList((List<? extends ParseTree>)tree.statements);
        --this.indentDepth;
    }

    @Override
    protected void visit(DefaultParameterTree tree) {
        this.visitAny(tree.identifier);
        this.write(TokenType.EQUAL);
        this.visitAny(tree.expression);
    }

    @Override
    protected void visit(DoWhileStatementTree tree) {
        this.write(TokenType.DO);
        this.visitAny(tree.body);
        this.write(TokenType.WHILE);
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.condition);
        this.write(TokenType.CLOSE_PAREN);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(EmptyStatementTree tree) {
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(ExportDeclarationTree tree) {
        this.write(TokenType.EXPORT);
        this.visitAny(tree.declaration);
    }

    @Override
    protected void visit(ExpressionStatementTree tree) {
        this.visitAny(tree.expression);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(FieldDeclarationTree tree) {
        if (tree.isStatic) {
            this.write(TokenType.STATIC);
        }
        if (tree.isConst) {
            this.write(TokenType.CONST);
        }
        this.writeList((List<? extends ParseTree>)tree.declarations, TokenType.COMMA, false);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(FinallyTree tree) {
        this.write(TokenType.FINALLY);
        this.visitAny(tree.block);
    }

    @Override
    protected void visit(ForEachStatementTree tree) {
        this.write(TokenType.FOR);
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.initializer);
        this.write(TokenType.COLON);
        this.visitAny(tree.collection);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.body);
    }

    @Override
    protected void visit(ForInStatementTree tree) {
        this.write(TokenType.FOR);
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.initializer);
        this.write(TokenType.IN);
        this.visitAny(tree.collection);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.body);
    }

    @Override
    protected void visit(ForStatementTree tree) {
        this.write(TokenType.FOR);
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.initializer);
        this.write(TokenType.SEMI_COLON);
        this.visitAny(tree.condition);
        this.write(TokenType.SEMI_COLON);
        this.visitAny(tree.increment);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.body);
    }

    @Override
    protected void visit(FormalParameterListTree tree) {
        boolean first = true;
        for (ParseTree parameter : tree.parameters) {
            if (first) {
                first = false;
            } else {
                this.write(TokenType.COMMA);
            }
            this.visitAny(parameter);
        }
    }

    @Override
    protected void visit(FunctionDeclarationTree tree) {
        if (tree.isStatic) {
            this.write(TokenType.STATIC);
        }
        this.write(Keywords.FUNCTION);
        if (tree.name != null) {
            this.write(tree.name);
        }
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.formalParameterList);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.functionBody);
    }

    @Override
    protected void visit(GetAccessorTree tree) {
        if (tree.isStatic) {
            this.write(TokenType.STATIC);
        }
        this.write("get");
        this.write(tree.propertyName);
        this.write(TokenType.OPEN_PAREN);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.body);
    }

    @Override
    protected void visit(IdentifierExpressionTree tree) {
        this.write(tree.identifierToken);
    }

    @Override
    protected void visit(IfStatementTree tree) {
        this.write(TokenType.IF);
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.condition);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.ifClause);
        if (tree.elseClause != null) {
            this.write(TokenType.ELSE);
            this.visitAny(tree.elseClause);
        }
    }

    @Override
    protected void visit(ImportDeclarationTree tree) {
        this.write(TokenType.IMPORT);
        this.writeList((List<? extends ParseTree>)tree.importPathList, TokenType.COMMA, false);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(ImportPathTree tree) {
        this.writeTokenList((List<? extends Token>)tree.qualifiedPath, TokenType.PERIOD, false);
        switch (tree.kind) {
            case ALL: {
                this.write(TokenType.PERIOD);
                this.write(TokenType.STAR);
                break;
            }
            case NONE: {
                break;
            }
            case SET: {
                this.write(TokenType.PERIOD);
                this.write(TokenType.OPEN_CURLY);
                this.writeList((List<? extends ParseTree>)tree.importSpecifierSet, TokenType.COMMA, false);
                this.write(TokenType.CLOSE_CURLY);
            }
        }
    }

    @Override
    protected void visit(ImportSpecifierTree tree) {
        this.write(tree.importedName);
        if (tree.destinationName != null) {
            this.write(TokenType.COLON);
            this.write(tree.destinationName);
        }
    }

    @Override
    protected void visit(LabelledStatementTree tree) {
        this.write(tree.name);
        this.write(TokenType.COLON);
        this.visitAny(tree.statement);
    }

    @Override
    protected void visit(LiteralExpressionTree tree) {
        this.write(tree.literalToken);
    }

    @Override
    protected void visit(MemberExpressionTree tree) {
        this.visitAny(tree.operand);
        this.write(TokenType.PERIOD);
        this.write(tree.memberName);
    }

    @Override
    protected void visit(MemberLookupExpressionTree tree) {
        this.visitAny(tree.operand);
        this.write(TokenType.OPEN_SQUARE);
        this.visitAny(tree.memberExpression);
        this.write(TokenType.CLOSE_SQUARE);
    }

    @Override
    protected void visit(MissingPrimaryExpressionTree tree) {
        this.write("MissingPrimaryExpressionTree");
    }

    @Override
    protected void visit(MixinTree tree) {
        this.write("mixin");
        this.write(tree.name);
        this.visitAny(tree.mixinResolves);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(MixinResolveTree tree) {
        this.write(tree.from);
        this.write(TokenType.COLON);
        this.write(tree.to);
    }

    @Override
    protected void visit(MixinResolveListTree tree) {
        this.write(TokenType.OPEN_CURLY);
        this.writeList((List<? extends ParseTree>)tree.resolves, TokenType.COMMA, false);
        this.write(TokenType.CLOSE_CURLY);
    }

    @Override
    protected void visit(ModuleDefinitionTree tree) {
        this.write("module");
        this.write(tree.name);
        this.write(TokenType.OPEN_CURLY);
        this.writeln();
        this.writeList((List<? extends ParseTree>)tree.elements, null, true);
        this.write(TokenType.CLOSE_CURLY);
        this.writeln();
    }

    @Override
    protected void visit(NewExpressionTree tree) {
        this.write(TokenType.NEW);
        this.visitAny(tree.operand);
        this.visitAny(tree.arguments);
    }

    @Override
    protected void visit(NullTree tree) {
    }

    @Override
    protected void visit(ObjectLiteralExpressionTree tree) {
        this.write(TokenType.OPEN_CURLY);
        if (tree.propertyNameAndValues.size() > 1) {
            this.writeln();
        }
        this.writelnList((List<? extends ParseTree>)tree.propertyNameAndValues, TokenType.COMMA);
        if (tree.propertyNameAndValues.size() > 1) {
            this.writeln();
        }
        this.write(TokenType.CLOSE_CURLY);
    }

    @Override
    protected void visit(ObjectPatternTree tree) {
        this.write(TokenType.OPEN_CURLY);
        this.writelnList((List<? extends ParseTree>)tree.fields, TokenType.COMMA);
        this.write(TokenType.CLOSE_CURLY);
    }

    @Override
    protected void visit(ObjectPatternFieldTree tree) {
        this.write(tree.identifier);
        if (tree.element != null) {
            this.write(TokenType.COLON);
            this.visitAny(tree.element);
        }
    }

    @Override
    protected void visit(ParenExpressionTree tree) {
        this.write(TokenType.OPEN_PAREN);
        super.visit(tree);
        this.write(TokenType.CLOSE_PAREN);
    }

    @Override
    protected void visit(PostfixExpressionTree tree) {
        this.visitAny(tree.operand);
        this.write(tree.operator);
    }

    @Override
    protected void visit(ProgramTree tree) {
        this.writelnList((List<? extends ParseTree>)tree.sourceElements);
    }

    @Override
    protected void visit(PropertyNameAssignmentTree tree) {
        this.write(tree.name);
        this.write(TokenType.COLON);
        this.visitAny(tree.value);
    }

    @Override
    protected void visit(RequiresMemberTree tree) {
        this.write("requires");
        this.write(tree.name);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(ReturnStatementTree tree) {
        this.write(TokenType.RETURN);
        this.visitAny(tree.expression);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(RestParameterTree tree) {
        this.write(TokenType.SPREAD);
        this.write(tree.identifier);
    }

    @Override
    protected void visit(SetAccessorTree tree) {
        if (tree.isStatic) {
            this.write(TokenType.STATIC);
        }
        this.write("set");
        this.write(tree.propertyName);
        this.write(TokenType.OPEN_PAREN);
        this.write(tree.parameter);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.body);
    }

    @Override
    protected void visit(SpreadExpressionTree tree) {
        this.write(TokenType.SPREAD);
        this.visitAny(tree.expression);
    }

    @Override
    protected void visit(SpreadPatternElementTree tree) {
        this.write(TokenType.SPREAD);
        this.visitAny(tree.lvalue);
    }

    @Override
    protected void visit(SuperExpressionTree tree) {
        this.write(TokenType.SUPER);
    }

    @Override
    protected void visit(SwitchStatementTree tree) {
        this.write(TokenType.SWITCH);
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.expression);
        this.write(TokenType.CLOSE_PAREN);
        this.write(TokenType.OPEN_CURLY);
        this.writelnList((List<? extends ParseTree>)tree.caseClauses);
        this.write(TokenType.CLOSE_CURLY);
    }

    @Override
    protected void visit(ThisExpressionTree tree) {
        this.write(TokenType.THIS);
    }

    @Override
    protected void visit(TraitDeclarationTree tree) {
        this.write("trait");
        this.write(tree.name);
        this.write(TokenType.OPEN_CURLY);
        this.visitList((List<? extends ParseTree>)tree.elements);
        this.write(TokenType.CLOSE_CURLY);
    }

    @Override
    protected void visit(ThrowStatementTree tree) {
        this.write(TokenType.THROW);
        this.visitAny(tree.value);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(TryStatementTree tree) {
        this.write(TokenType.TRY);
        this.visitAny(tree.body);
        this.visitAny(tree.catchBlock);
        this.visitAny(tree.finallyBlock);
    }

    @Override
    protected void visit(UnaryExpressionTree tree) {
        this.write(tree.operator);
        this.visitAny(tree.operand);
    }

    @Override
    protected void visit(VariableDeclarationListTree tree) {
        this.write(tree.declarationType);
        this.writeList((List<? extends ParseTree>)tree.declarations, TokenType.COMMA, false);
    }

    @Override
    protected void visit(VariableDeclarationTree tree) {
        this.visitAny(tree.lvalue);
        if (tree.initializer != null) {
            this.write(TokenType.EQUAL);
            this.visitAny(tree.initializer);
        }
    }

    @Override
    protected void visit(VariableStatementTree tree) {
        super.visit(tree);
        this.write(TokenType.SEMI_COLON);
    }

    @Override
    protected void visit(WhileStatementTree tree) {
        this.write(TokenType.WHILE);
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.condition);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.body);
    }

    @Override
    protected void visit(WithStatementTree tree) {
        this.write(TokenType.WITH);
        this.write(TokenType.OPEN_PAREN);
        this.visitAny(tree.expression);
        this.write(TokenType.CLOSE_PAREN);
        this.visitAny(tree.body);
    }

    @Override
    protected void visit(YieldStatementTree tree) {
        this.write(TokenType.YIELD);
        this.visitAny(tree.expression);
        this.write(TokenType.SEMI_COLON);
    }

    private void writelnList(List<? extends ParseTree> list) {
        if (!list.isEmpty()) {
            this.writeln();
        }
        this.writelnList(list, null);
        if (!list.isEmpty()) {
            this.writeln();
        }
    }

    private void writelnList(List<? extends ParseTree> list, TokenType delimiter) {
        this.writeList(list, delimiter, true);
    }

    private void writeln() {
        if (this.currentLineComment != null) {
            while (this.currentLine.length() < 80) {
                this.currentLine.append(' ');
            }
            this.currentLine.append(" // ").append(this.currentLineComment);
            this.currentLineComment = null;
        }
        this.result.append(this.currentLine.toString());
        this.result.append(NEW_LINE);
        this.currentLine = new StringBuilder();
    }

    private void writeList(List<? extends ParseTree> list, TokenType delimiter, boolean writeNewLine) {
        boolean first = true;
        for (ParseTree parseTree : list) {
            if (first) {
                first = false;
            } else {
                if (delimiter != null) {
                    this.write(delimiter);
                }
                if (writeNewLine) {
                    this.writeln();
                }
            }
            this.visitAny(parseTree);
        }
    }

    private void writeTokenList(List<? extends Token> list, TokenType delimiter, boolean writeNewLine) {
        boolean first = true;
        for (Token token : list) {
            if (first) {
                first = false;
            } else {
                if (delimiter != null) {
                    this.write(delimiter);
                }
                if (writeNewLine) {
                    this.writeln();
                }
            }
            this.write(token);
        }
    }

    private void write(Keywords keyword) {
        this.write(keyword.toString());
    }

    private void write(TokenType type) {
        if (type == TokenType.CLOSE_CURLY) {
            --this.indentDepth;
        }
        boolean spaceBefore = true;
        boolean spaceAfter = true;
        switch (type) {
            case OPEN_PAREN: 
            case OPEN_SQUARE: 
            case CLOSE_SQUARE: 
            case PERIOD: {
                spaceBefore = false;
                spaceAfter = false;
                break;
            }
            case CLOSE_PAREN: 
            case SEMI_COLON: 
            case COMMA: 
            case COLON: {
                spaceBefore = false;
            }
        }
        this.write(type.toString(), spaceBefore, spaceAfter);
        if (type == TokenType.OPEN_CURLY) {
            ++this.indentDepth;
        }
    }

    private void write(Token token) {
        this.write(token.toString());
    }

    private void write(String value) {
        this.write(value, true, true);
    }

    private void write(String value, boolean spaceBefore, boolean spaceAfter) {
        if (value != null) {
            if (this.currentLine.length() == 0) {
                int i = 0;
                int indent = this.indentDepth * 2;
                while (i < indent) {
                    this.currentLine.append(' ');
                    ++i;
                }
            } else {
                int lastIndex = this.currentLine.length() - 1;
                if (!spaceBefore && this.currentLine.charAt(lastIndex) == ' ') {
                    this.currentLine.deleteCharAt(lastIndex);
                }
            }
            this.currentLine.append(value);
            if (spaceAfter) {
                this.currentLine.append(' ');
            }
        }
    }
}

