/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.type;

import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.gwt.thirdparty.javascript.jscomp.type.FlowScope;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ObjectType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.Visitor;
import java.util.Map;

public class ClosureReverseAbstractInterpreter
extends ChainableReverseAbstractInterpreter {
    private final Visitor<JSType> restrictToArrayVisitor = new ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor(this){

        @Override
        protected JSType caseTopType(JSType topType) {
            return topType.isAllType() ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE) : topType;
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            JSType arrayType = ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE);
            return arrayType.isSubtype(type) ? arrayType : null;
        }
    };
    private final Visitor<JSType> restrictToNotArrayVisitor = new ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor(this){

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type.isSubtype(ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE)) ? null : type;
        }
    };
    private final Visitor<JSType> restrictToObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor(this){

        @Override
        protected JSType caseTopType(JSType topType) {
            return ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return type;
        }
    };
    private final Visitor<JSType> restrictToNotObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor(this){

        @Override
        public JSType caseAllType() {
            return ClosureReverseAbstractInterpreter.this.typeRegistry.createUnionType(ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN), ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_VOID));
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return null;
        }
    };
    private Map<String, Function<TypeRestriction, JSType>> restricters = new ImmutableMap.Builder().put((Object)"isDef", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            if (p.outcome) {
                return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(p.type);
            }
            return p.type != null ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE).getGreatestSubtype(p.type) : null;
        }
    }).put((Object)"isNull", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            if (p.outcome) {
                return p.type != null ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE).getGreatestSubtype(p.type) : null;
            }
            return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutNull(p.type);
        }
    }).put((Object)"isDefAndNotNull", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            if (p.outcome) {
                return ClosureReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(ClosureReverseAbstractInterpreter.this.getRestrictedWithoutNull(p.type));
            }
            return p.type != null ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_VOID).getGreatestSubtype(p.type) : null;
        }
    }).put((Object)"isString", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(p.type, "string", p.outcome);
        }
    }).put((Object)"isBoolean", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(p.type, "boolean", p.outcome);
        }
    }).put((Object)"isNumber", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(p.type, "number", p.outcome);
        }
    }).put((Object)"isFunction", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            return ClosureReverseAbstractInterpreter.this.getRestrictedByTypeOfResult(p.type, "function", p.outcome);
        }
    }).put((Object)"isArray", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            if (p.type == null) {
                return p.outcome ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ARRAY_TYPE) : null;
            }
            Visitor visitor = p.outcome ? ClosureReverseAbstractInterpreter.this.restrictToArrayVisitor : ClosureReverseAbstractInterpreter.this.restrictToNotArrayVisitor;
            return (JSType)p.type.visit(visitor);
        }
    }).put((Object)"isObject", (Object)new Function<TypeRestriction, JSType>(){

        public JSType apply(TypeRestriction p) {
            if (p.type == null) {
                return p.outcome ? ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.OBJECT_TYPE) : null;
            }
            Visitor visitor = p.outcome ? ClosureReverseAbstractInterpreter.this.restrictToObjectVisitor : ClosureReverseAbstractInterpreter.this.restrictToNotObjectVisitor;
            return (JSType)p.type.visit(visitor);
        }
    }).build();

    public ClosureReverseAbstractInterpreter(CodingConvention convention, JSTypeRegistry typeRegistry) {
        super(convention, typeRegistry);
    }

    @Override
    public FlowScope getPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, boolean outcome) {
        if (condition.isCall() && condition.getChildCount() == 2) {
            Node callee = condition.getFirstChild();
            Node param = condition.getLastChild();
            if (callee.isGetProp() && param.isQualifiedName()) {
                Function<TypeRestriction, JSType> restricter;
                JSType paramType = this.getTypeIfRefinable(param, blindScope);
                Node left = callee.getFirstChild();
                Node right = callee.getLastChild();
                if (left.isName() && "goog".equals(left.getString()) && right.isString() && (restricter = this.restricters.get(right.getString())) != null) {
                    return this.restrictParameter(param, paramType, blindScope, restricter, outcome);
                }
            }
        }
        return this.nextPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome);
    }

    private FlowScope restrictParameter(Node parameter, JSType type, FlowScope blindScope, Function<TypeRestriction, JSType> restriction, boolean outcome) {
        if ((type = (JSType)restriction.apply((Object)new TypeRestriction(type, outcome))) != null) {
            FlowScope informed = blindScope.createChildFlowScope();
            this.declareNameInScope(informed, parameter, type);
            return informed;
        }
        return blindScope;
    }

    private static class TypeRestriction {
        private final JSType type;
        private final boolean outcome;

        private TypeRestriction(JSType type, boolean outcome) {
            this.type = type;
            this.outcome = outcome;
        }
    }
}

