/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.jstype;

import com.google.gwt.thirdparty.javascript.rhino.jstype.EnumElementType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ObjectType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.RelationshipVisitor;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplateType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplatizedType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.UnionType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ValueType;

class CanCastToVisitor
implements RelationshipVisitor<Boolean> {
    CanCastToVisitor() {
    }

    @Override
    public Boolean caseUnknownType(JSType thisType, JSType thatType) {
        return true;
    }

    @Override
    public Boolean caseNoType(JSType thatType) {
        return true;
    }

    @Override
    public Boolean caseNoObjectType(JSType thatType) {
        return true;
    }

    @Override
    public Boolean caseAllType(JSType thatType) {
        return true;
    }

    boolean canCastToUnion(JSType thisType, UnionType unionType) {
        for (JSType type : unionType.getAlternates()) {
            if (!thisType.visit(this, type).booleanValue()) continue;
            return true;
        }
        return false;
    }

    boolean canCastToFunction(JSType thisType, FunctionType functionType) {
        if (thisType.isFunctionType()) {
            return true;
        }
        return thisType.isSubtype(functionType) || functionType.isSubtype(thisType);
    }

    private boolean isInterface(JSType type) {
        ObjectType objType = type.toObjectType();
        if (objType != null) {
            FunctionType constructor = objType.getConstructor();
            return constructor != null && ((JSType)constructor).isInterface();
        }
        return false;
    }

    Boolean castCastToHelper(JSType thisType, JSType thatType) {
        if (thatType.isUnknownType() || thatType.isAllType() || thatType.isNoObjectType() || thatType.isNoType()) {
            return true;
        }
        if (thisType.isRecordType() || thatType.isRecordType()) {
            return true;
        }
        if (this.isInterface(thisType) || this.isInterface(thatType)) {
            return true;
        }
        if (thatType.isEnumElementType()) {
            return thisType.visit(this, thatType.toMaybeEnumElementType().getPrimitiveType());
        }
        if (thatType.isUnionType()) {
            return this.canCastToUnion(thisType, thatType.toMaybeUnionType());
        }
        if (thatType.isFunctionType()) {
            return this.canCastToFunction(thisType, thatType.toMaybeFunctionType());
        }
        if (thatType.isTemplatizedType()) {
            return thisType.visit(this, thatType.toMaybeTemplatizedType().getReferencedTypeInternal());
        }
        if (!thisType.isSubtype(thatType) && !thatType.isSubtype(thisType)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean caseValueType(ValueType thisType, JSType thatType) {
        return this.castCastToHelper(thisType, thatType);
    }

    @Override
    public Boolean caseObjectType(ObjectType thisType, JSType thatType) {
        return this.castCastToHelper(thisType, thatType);
    }

    @Override
    public Boolean caseFunctionType(FunctionType thisType, JSType thatType) {
        return this.castCastToHelper(thisType, thatType);
    }

    @Override
    public Boolean caseUnionType(UnionType thisType, JSType thatType) {
        boolean visited = false;
        for (JSType type : thisType.getAlternates()) {
            if (type.isVoidType() || type.isNullType()) continue;
            visited = true;
            if (!type.visit(this, thatType).booleanValue()) continue;
            return true;
        }
        if (!visited) {
            JSType NULL_TYPE = thisType.getNativeType(JSTypeNative.NULL_TYPE);
            JSType VOID_TYPE = thisType.getNativeType(JSTypeNative.VOID_TYPE);
            if (!NULL_TYPE.visit(this, thatType).booleanValue() && !VOID_TYPE.visit(this, thatType).booleanValue()) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean caseTemplatizedType(TemplatizedType thisType, JSType thatType) {
        return thisType.getReferencedTypeInternal().visit(this, thatType);
    }

    @Override
    public Boolean caseTemplateType(TemplateType thisType, JSType thatType) {
        return true;
    }

    @Override
    public Boolean caseEnumElementType(EnumElementType typeType, JSType thatType) {
        return typeType.getPrimitiveType().visit(this, thatType);
    }
}

