/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.jstype;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.javascript.rhino.jstype.EquivalenceMethod;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplateType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplateTypeMapReplacer;
import java.io.Serializable;
import java.util.Arrays;

public class TemplateTypeMap
implements Serializable {
    private final ImmutableList<TemplateType> templateKeys;
    private final ImmutableList<JSType> templateValues;
    private final ImmutableList<JSType> resolvedTemplateValues;
    final JSTypeRegistry registry;

    TemplateTypeMap(JSTypeRegistry registry, ImmutableList<TemplateType> templateKeys, ImmutableList<JSType> templateValues) {
        Preconditions.checkNotNull(templateKeys);
        Preconditions.checkNotNull((Object)templateValues);
        this.registry = registry;
        this.templateKeys = templateKeys;
        int nKeys = templateKeys.size();
        this.templateValues = templateValues.size() > nKeys ? templateValues.subList(0, nKeys) : templateValues;
        TemplateTypeMapReplacer replacer = new TemplateTypeMapReplacer(registry, this);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSType templateValue : this.templateValues) {
            builder.add((Object)templateValue.visit(replacer));
        }
        this.resolvedTemplateValues = builder.build();
    }

    public boolean isEmpty() {
        return this.templateKeys.isEmpty();
    }

    public ImmutableList<TemplateType> getTemplateKeys() {
        return this.templateKeys;
    }

    public boolean hasTemplateKey(TemplateType templateKey) {
        for (TemplateType entry : this.templateKeys) {
            if (entry != templateKey) continue;
            return true;
        }
        return false;
    }

    int numUnfilledTemplateKeys() {
        return this.templateKeys.size() - this.templateValues.size();
    }

    ImmutableList<TemplateType> getUnfilledTemplateKeys() {
        return this.templateKeys.subList(this.templateValues.size(), this.templateKeys.size());
    }

    public boolean hasTemplateType(TemplateType key) {
        return this.getTemplateTypeIndex(key) != -1;
    }

    public JSType getTemplateType(TemplateType key) {
        int index = this.getTemplateTypeIndex(key);
        return index == -1 ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (JSType)this.templateValues.get(index);
    }

    public TemplateType getTemplateTypeKeyByName(String keyName) {
        for (TemplateType key : this.templateKeys) {
            if (!key.getReferenceName().equals(keyName)) continue;
            return key;
        }
        return null;
    }

    private int getTemplateTypeIndex(TemplateType key) {
        int maxIndex = Math.min(this.templateKeys.size(), this.templateValues.size());
        int i = maxIndex - 1;
        while (i >= 0) {
            if (this.templateKeys.get(i) == key) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private JSType getResolvedTemplateType(TemplateType key) {
        int index = this.getTemplateTypeIndex(key);
        return index == -1 ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (JSType)this.resolvedTemplateValues.get(index);
    }

    public boolean checkEquivalenceHelper(TemplateTypeMap that, EquivalenceMethod eqMethod) {
        ImmutableList<TemplateType> thisKeys = this.getTemplateKeys();
        ImmutableList<TemplateType> thatKeys = that.getTemplateKeys();
        EquivalenceMatch[] thatMatches = new EquivalenceMatch[thatKeys.size()];
        Arrays.fill((Object[])thatMatches, (Object)EquivalenceMatch.NO_KEY_MATCH);
        int i = 0;
        while (i < thisKeys.size()) {
            TemplateType thisKey = (TemplateType)thisKeys.get(i);
            JSType thisType = this.getResolvedTemplateType(thisKey);
            EquivalenceMatch thisMatch = EquivalenceMatch.NO_KEY_MATCH;
            int j = 0;
            while (j < thatKeys.size()) {
                TemplateType thatKey = (TemplateType)thatKeys.get(j);
                JSType thatType = that.getResolvedTemplateType(thatKey);
                if (thisKey == thatKey) {
                    EquivalenceMatch newMatchType = EquivalenceMatch.VALUE_MISMATCH;
                    if (thisType.checkEquivalenceHelper(thatType, eqMethod)) {
                        newMatchType = EquivalenceMatch.VALUE_MATCH;
                    }
                    if (thisMatch != EquivalenceMatch.VALUE_MATCH) {
                        thisMatch = newMatchType;
                    }
                    if (thatMatches[j] != EquivalenceMatch.VALUE_MATCH) {
                        thatMatches[j] = newMatchType;
                    }
                }
                ++j;
            }
            if (this.failedEquivalenceCheck(thisMatch, eqMethod)) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < thatMatches.length) {
            if (this.failedEquivalenceCheck(thatMatches[i], eqMethod)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean failedEquivalenceCheck(EquivalenceMatch eqMatch, EquivalenceMethod eqMethod) {
        return eqMatch == EquivalenceMatch.VALUE_MISMATCH || eqMatch == EquivalenceMatch.NO_KEY_MATCH && eqMethod != EquivalenceMethod.INVARIANT;
    }

    TemplateTypeMap extend(TemplateTypeMap thatMap) {
        thatMap = thatMap.addUnknownValues();
        return this.registry.createTemplateTypeMap(this.concatImmutableLists(thatMap.templateKeys, this.templateKeys), this.concatImmutableLists(thatMap.templateValues, this.templateValues));
    }

    TemplateTypeMap addValues(ImmutableList<JSType> newValues) {
        int numUnfilledKeys = this.numUnfilledTemplateKeys();
        if (numUnfilledKeys < newValues.size()) {
            newValues = newValues.subList(0, numUnfilledKeys);
        }
        return this.registry.createTemplateTypeMap(this.templateKeys, this.concatImmutableLists(this.templateValues, newValues));
    }

    private TemplateTypeMap addUnknownValues() {
        int numUnfilledTemplateKeys = this.numUnfilledTemplateKeys();
        if (numUnfilledTemplateKeys == 0) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (i < numUnfilledTemplateKeys) {
            builder.add((Object)this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            ++i;
        }
        return this.addValues((ImmutableList<JSType>)builder.build());
    }

    private <T> ImmutableList<T> concatImmutableLists(ImmutableList<T> first, ImmutableList<T> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(first);
        builder.addAll(second);
        return builder.build();
    }

    boolean hasAnyTemplateTypesInternal() {
        for (JSType templateValue : this.templateValues) {
            if (!templateValue.hasAnyTemplateTypes()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "";
        int len = Math.max(Math.max(this.templateKeys.size(), this.templateValues.size()), this.resolvedTemplateValues.size());
        s = String.valueOf(s) + "{ ";
        int i = 0;
        while (i < len) {
            s = String.valueOf(s) + "(";
            s = String.valueOf(s) + (i < this.templateKeys.size() ? (Serializable)this.templateKeys.get(i) : "");
            s = String.valueOf(s) + ",";
            s = String.valueOf(s) + (i < this.templateValues.size() ? (Serializable)this.templateValues.get(i) : "");
            s = String.valueOf(s) + ",";
            s = String.valueOf(s) + (i < this.resolvedTemplateValues.size() ? (Serializable)this.resolvedTemplateValues.get(i) : "");
            s = String.valueOf(s) + ") ";
            ++i;
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    private static enum EquivalenceMatch {
        NO_KEY_MATCH,
        VALUE_MISMATCH,
        VALUE_MATCH;

    }
}

