/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.jstype;

import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ModificationVisitor;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplateType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplateTypeMap;
import java.util.ArrayDeque;

public class TemplateTypeMapReplacer
extends ModificationVisitor {
    private final TemplateTypeMap replacements;
    private ArrayDeque<TemplateType> visitedTypes;

    public TemplateTypeMapReplacer(JSTypeRegistry registry, TemplateTypeMap replacements) {
        super(registry, false);
        this.replacements = replacements;
        this.visitedTypes = new ArrayDeque();
    }

    @Override
    public JSType caseTemplateType(TemplateType type) {
        if (this.replacements.hasTemplateKey(type)) {
            if (this.hasVisitedType(type) || !this.replacements.hasTemplateType(type)) {
                return type;
            }
            JSType replacement = this.replacements.getTemplateType(type);
            this.visitedTypes.push(type);
            JSType visitedReplacement = replacement.visit(this);
            this.visitedTypes.pop();
            return visitedReplacement;
        }
        return type;
    }

    private boolean hasVisitedType(TemplateType type) {
        for (TemplateType visitedType : this.visitedTypes) {
            if (visitedType != type) continue;
            return true;
        }
        return false;
    }
}

