/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.testing;

import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.StaticScope;
import com.google.gwt.thirdparty.javascript.rhino.testing.MapBasedScope;
import com.google.gwt.thirdparty.javascript.rhino.testing.TestErrorReporter;
import java.util.Iterator;
import junit.framework.Assert;

public class Asserts {
    private Asserts() {
    }

    public static JSType assertResolvesToSame(JSType type) {
        Assert.assertSame((Object)type, (Object)Asserts.assertValidResolve(type));
        return type;
    }

    public static JSType assertValidResolve(JSType type) {
        return Asserts.assertValidResolve(type, MapBasedScope.emptyScope());
    }

    public static JSType assertValidResolve(JSType type, StaticScope<JSType> scope) {
        TestErrorReporter t = TestErrorReporter.forNoExpectedReports();
        JSType resolvedType = type.resolve(t, scope);
        Asserts.assertTypeEquals("JSType#resolve should not affect object equality", type, resolvedType);
        return resolvedType;
    }

    public static void assertTypeNotEquals(JSType a, JSType b) {
        Asserts.assertTypeNotEquals("", a, b);
    }

    public static void assertTypeNotEquals(String message, JSType a, JSType b) {
        Assert.assertFalse((String)(String.valueOf(message) + (message.isEmpty() ? "" : "\n") + "Type: " + b + "\n"), (boolean)a.isEquivalentTo(b));
        Assert.assertFalse((String)(String.valueOf(message) + " Equals is not symmetric.\n" + "Type: " + b + "\n"), (boolean)b.isEquivalentTo(a));
    }

    public static void assertTypeEquals(JSType a, JSType b) {
        Asserts.assertTypeEquals("", a, b);
    }

    public static void assertTypeEquals(String message, JSType a, JSType b) {
        Assert.assertTrue((String)("Both types must be null, or both must be non-null " + a + "," + b), (a == null == (b == null) ? 1 : 0) != 0);
        if (a == null) {
            return;
        }
        Assert.assertTrue((String)(String.valueOf(message) + (message.isEmpty() ? "" : "\n") + "Expected: " + a + "\n" + "Actual  : " + b), (boolean)a.isEquivalentTo(b));
        Assert.assertTrue((String)(String.valueOf(message) + " Equals is not symmetric.\n" + "Expected: " + b + "\n" + "Actual  : " + a), (boolean)b.isEquivalentTo(a));
    }

    public static <T extends JSType, S extends JSType> void assertTypeCollectionEquals(Iterable<T> a, Iterable<S> b) {
        Assert.assertEquals((int)Iterables.size(a), (int)Iterables.size(b));
        Iterator<T> aIterator = a.iterator();
        Iterator<S> bIterator = b.iterator();
        while (aIterator.hasNext()) {
            Asserts.assertTypeEquals((JSType)aIterator.next(), (JSType)bIterator.next());
        }
    }

    public static void assertEquivalenceOperations(JSType a, JSType b) {
        Assert.assertTrue((boolean)a.isEquivalentTo(b));
        Assert.assertTrue((boolean)a.isEquivalentTo(a));
        Assert.assertTrue((boolean)b.isEquivalentTo(b));
        Assert.assertTrue((boolean)b.isEquivalentTo(a));
        Assert.assertTrue((boolean)a.isSubtype(b));
        Assert.assertTrue((boolean)a.isSubtype(a));
        Assert.assertTrue((boolean)b.isSubtype(b));
        Assert.assertTrue((boolean)b.isSubtype(a));
        Asserts.assertTypeEquals(a, a.getGreatestSubtype(b));
        Asserts.assertTypeEquals(a, a.getGreatestSubtype(a));
        Asserts.assertTypeEquals(a, b.getGreatestSubtype(b));
        Asserts.assertTypeEquals(a, b.getGreatestSubtype(a));
        Asserts.assertTypeEquals(a, a.getLeastSupertype(b));
        Asserts.assertTypeEquals(a, a.getLeastSupertype(a));
        Asserts.assertTypeEquals(a, b.getLeastSupertype(b));
        Asserts.assertTypeEquals(a, b.getLeastSupertype(a));
        Assert.assertTrue((boolean)a.canCastTo(b));
        Assert.assertTrue((boolean)a.canCastTo(a));
        Assert.assertTrue((boolean)b.canCastTo(b));
        Assert.assertTrue((boolean)b.canCastTo(a));
    }
}

