/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.testing;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.javascript.rhino.JSTypeExpression;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionBuilder;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ObjectType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplatizedType;
import com.google.gwt.thirdparty.javascript.rhino.testing.Asserts;
import com.google.gwt.thirdparty.javascript.rhino.testing.TestErrorReporter;
import junit.framework.TestCase;

public abstract class BaseJSTypeTestCase
extends TestCase {
    protected JSTypeRegistry registry;
    protected TestErrorReporter errorReporter;
    protected JSType ALL_TYPE;
    protected ObjectType NO_OBJECT_TYPE;
    protected ObjectType NO_TYPE;
    protected ObjectType NO_RESOLVED_TYPE;
    protected FunctionType ARRAY_FUNCTION_TYPE;
    protected ObjectType ARRAY_TYPE;
    protected JSType BOOLEAN_OBJECT_FUNCTION_TYPE;
    protected ObjectType BOOLEAN_OBJECT_TYPE;
    protected JSType BOOLEAN_TYPE;
    protected ObjectType CHECKED_UNKNOWN_TYPE;
    protected JSType DATE_FUNCTION_TYPE;
    protected ObjectType DATE_TYPE;
    protected JSType ERROR_FUNCTION_TYPE;
    protected ObjectType ERROR_TYPE;
    protected JSType EVAL_ERROR_FUNCTION_TYPE;
    protected ObjectType EVAL_ERROR_TYPE;
    protected FunctionType FUNCTION_FUNCTION_TYPE;
    protected FunctionType FUNCTION_INSTANCE_TYPE;
    protected ObjectType FUNCTION_PROTOTYPE;
    protected JSType GREATEST_FUNCTION_TYPE;
    protected JSType LEAST_FUNCTION_TYPE;
    protected JSType MATH_TYPE;
    protected JSType NULL_TYPE;
    protected JSType NUMBER_OBJECT_FUNCTION_TYPE;
    protected ObjectType NUMBER_OBJECT_TYPE;
    protected JSType NUMBER_STRING_BOOLEAN;
    protected JSType NUMBER_TYPE;
    protected FunctionType OBJECT_FUNCTION_TYPE;
    protected JSType NULL_VOID;
    protected JSType OBJECT_NUMBER_STRING;
    protected JSType OBJECT_NUMBER_STRING_BOOLEAN;
    protected JSType OBJECT_PROTOTYPE;
    protected ObjectType OBJECT_TYPE;
    protected JSType RANGE_ERROR_FUNCTION_TYPE;
    protected ObjectType RANGE_ERROR_TYPE;
    protected JSType REFERENCE_ERROR_FUNCTION_TYPE;
    protected ObjectType REFERENCE_ERROR_TYPE;
    protected JSType REGEXP_FUNCTION_TYPE;
    protected ObjectType REGEXP_TYPE;
    protected JSType STRING_OBJECT_FUNCTION_TYPE;
    protected ObjectType STRING_OBJECT_TYPE;
    protected JSType STRING_TYPE;
    protected JSType SYNTAX_ERROR_FUNCTION_TYPE;
    protected ObjectType SYNTAX_ERROR_TYPE;
    protected JSType TYPE_ERROR_FUNCTION_TYPE;
    protected ObjectType TYPE_ERROR_TYPE;
    protected FunctionType U2U_CONSTRUCTOR_TYPE;
    protected FunctionType U2U_FUNCTION_TYPE;
    protected ObjectType UNKNOWN_TYPE;
    protected JSType URI_ERROR_FUNCTION_TYPE;
    protected ObjectType URI_ERROR_TYPE;
    protected JSType VOID_TYPE;
    protected int NATIVE_PROPERTIES_COUNT;
    public static final String ALL_NATIVE_EXTERN_TYPES = "/**\n * @constructor\n * @param {*=} opt_value\n */\nfunction Object(opt_value) {}\n\n/**\n * @constructor\n * @extends {Object}\n * @param {...*} var_args\n */\n\nfunction Function(var_args) {}\n/**\n * @constructor\n * @extends {Object}\n * @param {...*} var_args\n * @return {!Array}\n */\nfunction Array(var_args) {}\n\n/**\n * @constructor\n * @param {*=} opt_value\n * @return {boolean}\n */\nfunction Boolean(opt_value) {}\n\n/**\n * @constructor\n * @param {*=} opt_value\n * @return {number}\n */\nfunction Number(opt_value) {}\n\n/**\n * @constructor\n * @param {?=} opt_yr_num\n * @param {?=} opt_mo_num\n * @param {?=} opt_day_num\n * @param {?=} opt_hr_num\n * @param {?=} opt_min_num\n * @param {?=} opt_sec_num\n * @param {?=} opt_ms_num\n * @return {string}\n */\nfunction Date(opt_yr_num, opt_mo_num, opt_day_num, opt_hr_num,    opt_min_num, opt_sec_num, opt_ms_num) {}\n\n/**\n * @constructor\n * @extends {Object}\n * @param {*=} opt_str\n * @return {string}\n */\nfunction String(opt_str) {}\n\n/**\n * @constructor\n * @param {*=} opt_pattern\n * @param {*=} opt_flags\n * @return {!RegExp}\n */\nfunction RegExp(opt_pattern, opt_flags) {}\n\n/**\n * @constructor\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!Error}\n */\nfunction Error(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!EvalError}\n */\nfunction EvalError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!RangeError}\n */\nfunction RangeError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!ReferenceError}\n */\nfunction ReferenceError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!SyntaxError}\n */\nfunction SyntaxError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!TypeError}\n */\nfunction TypeError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*=} opt_message\n * @param {*=} opt_file\n * @param {*=} opt_line\n * @return {!URIError}\n */\nfunction URIError(opt_message, opt_file, opt_line) {}\n\n/**\n * @param {string} progId\n * @param {string=} opt_location\n * @constructor\n */\nfunction ActiveXObject(progId, opt_location) {}\n";

    protected void setUp() throws Exception {
        super.setUp();
        this.errorReporter = new TestErrorReporter(null, null);
        this.registry = new JSTypeRegistry(this.errorReporter);
        this.initTypes();
    }

    protected void initTypes() {
        this.ALL_TYPE = this.registry.getNativeType(JSTypeNative.ALL_TYPE);
        this.NO_OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.NO_OBJECT_TYPE);
        this.NO_TYPE = this.registry.getNativeObjectType(JSTypeNative.NO_TYPE);
        this.NO_RESOLVED_TYPE = this.registry.getNativeObjectType(JSTypeNative.NO_RESOLVED_TYPE);
        this.ARRAY_FUNCTION_TYPE = this.registry.getNativeFunctionType(JSTypeNative.ARRAY_FUNCTION_TYPE);
        this.ARRAY_TYPE = this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE);
        this.BOOLEAN_OBJECT_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE);
        this.BOOLEAN_OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.BOOLEAN_OBJECT_TYPE);
        this.BOOLEAN_TYPE = this.registry.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        this.CHECKED_UNKNOWN_TYPE = this.registry.getNativeObjectType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
        this.DATE_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.DATE_FUNCTION_TYPE);
        this.DATE_TYPE = this.registry.getNativeObjectType(JSTypeNative.DATE_TYPE);
        this.ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.ERROR_FUNCTION_TYPE);
        this.ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.ERROR_TYPE);
        this.EVAL_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.EVAL_ERROR_FUNCTION_TYPE);
        this.EVAL_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.EVAL_ERROR_TYPE);
        this.FUNCTION_FUNCTION_TYPE = this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
        this.FUNCTION_INSTANCE_TYPE = this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_INSTANCE_TYPE);
        this.FUNCTION_PROTOTYPE = this.registry.getNativeObjectType(JSTypeNative.FUNCTION_PROTOTYPE);
        this.GREATEST_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.GREATEST_FUNCTION_TYPE);
        this.LEAST_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.LEAST_FUNCTION_TYPE);
        this.NULL_TYPE = this.registry.getNativeType(JSTypeNative.NULL_TYPE);
        this.NUMBER_OBJECT_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE);
        this.NUMBER_OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.NUMBER_OBJECT_TYPE);
        this.NUMBER_STRING_BOOLEAN = this.registry.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN);
        this.NUMBER_TYPE = this.registry.getNativeType(JSTypeNative.NUMBER_TYPE);
        this.OBJECT_FUNCTION_TYPE = this.registry.getNativeFunctionType(JSTypeNative.OBJECT_FUNCTION_TYPE);
        this.NULL_VOID = this.registry.getNativeType(JSTypeNative.NULL_VOID);
        this.OBJECT_NUMBER_STRING = this.registry.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING);
        this.OBJECT_NUMBER_STRING_BOOLEAN = this.registry.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN);
        this.OBJECT_PROTOTYPE = this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE);
        this.OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        this.RANGE_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.RANGE_ERROR_FUNCTION_TYPE);
        this.RANGE_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.RANGE_ERROR_TYPE);
        this.REFERENCE_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE);
        this.REFERENCE_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.REFERENCE_ERROR_TYPE);
        this.REGEXP_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.REGEXP_FUNCTION_TYPE);
        this.REGEXP_TYPE = this.registry.getNativeObjectType(JSTypeNative.REGEXP_TYPE);
        this.STRING_OBJECT_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE);
        this.STRING_OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.STRING_OBJECT_TYPE);
        this.STRING_TYPE = this.registry.getNativeType(JSTypeNative.STRING_TYPE);
        this.SYNTAX_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE);
        this.SYNTAX_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.SYNTAX_ERROR_TYPE);
        this.TYPE_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.TYPE_ERROR_FUNCTION_TYPE);
        this.TYPE_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.TYPE_ERROR_TYPE);
        this.U2U_CONSTRUCTOR_TYPE = this.registry.getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
        this.U2U_FUNCTION_TYPE = this.registry.getNativeFunctionType(JSTypeNative.U2U_FUNCTION_TYPE);
        this.UNKNOWN_TYPE = this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        this.URI_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.URI_ERROR_FUNCTION_TYPE);
        this.URI_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.URI_ERROR_TYPE);
        this.VOID_TYPE = this.registry.getNativeType(JSTypeNative.VOID_TYPE);
        BaseJSTypeTestCase.addNativeProperties(this.registry);
        this.NATIVE_PROPERTIES_COUNT = this.OBJECT_TYPE.getPropertiesCount();
    }

    public static void addNativeProperties(JSTypeRegistry registry) {
        JSType booleanType = registry.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        JSType numberType = registry.getNativeType(JSTypeNative.NUMBER_TYPE);
        JSType stringType = registry.getNativeType(JSTypeNative.STRING_TYPE);
        JSType unknownType = registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        ObjectType objectType = registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        ObjectType arrayType = registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE);
        ObjectType dateType = registry.getNativeObjectType(JSTypeNative.DATE_TYPE);
        ObjectType regexpType = registry.getNativeObjectType(JSTypeNative.REGEXP_TYPE);
        ObjectType booleanObjectType = registry.getNativeObjectType(JSTypeNative.BOOLEAN_OBJECT_TYPE);
        ObjectType numberObjectType = registry.getNativeObjectType(JSTypeNative.NUMBER_OBJECT_TYPE);
        ObjectType stringObjectType = registry.getNativeObjectType(JSTypeNative.STRING_OBJECT_TYPE);
        ObjectType objectPrototype = registry.getNativeFunctionType(JSTypeNative.OBJECT_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(registry, objectPrototype, "constructor", objectType);
        BaseJSTypeTestCase.addMethod(registry, objectPrototype, "toString", stringType);
        BaseJSTypeTestCase.addMethod(registry, objectPrototype, "toLocaleString", stringType);
        BaseJSTypeTestCase.addMethod(registry, objectPrototype, "valueOf", unknownType);
        BaseJSTypeTestCase.addMethod(registry, objectPrototype, "hasOwnProperty", booleanType);
        BaseJSTypeTestCase.addMethod(registry, objectPrototype, "isPrototypeOf", booleanType);
        BaseJSTypeTestCase.addMethod(registry, objectPrototype, "propertyIsEnumerable", booleanType);
        ObjectType arrayPrototype = registry.getNativeFunctionType(JSTypeNative.ARRAY_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "constructor", arrayType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "toString", stringType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "toLocaleString", stringType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "concat", arrayType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "join", stringType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "pop", unknownType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "push", numberType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "reverse", arrayType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "shift", unknownType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "slice", arrayType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "sort", arrayType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "splice", arrayType);
        BaseJSTypeTestCase.addMethod(registry, arrayPrototype, "unshift", numberType);
        arrayType.defineDeclaredProperty("length", numberType, null);
        ObjectType booleanPrototype = registry.getNativeFunctionType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(registry, booleanPrototype, "constructor", booleanObjectType);
        BaseJSTypeTestCase.addMethod(registry, booleanPrototype, "toString", stringType);
        BaseJSTypeTestCase.addMethod(registry, booleanPrototype, "valueOf", booleanType);
        ObjectType datePrototype = registry.getNativeFunctionType(JSTypeNative.DATE_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "constructor", dateType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "toString", stringType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "toDateString", stringType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "toTimeString", stringType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "toLocaleString", stringType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "toLocaleDateString", stringType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "toLocaleTimeString", stringType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "valueOf", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getTime", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getFullYear", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getUTCFullYear", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getMonth", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getUTCMonth", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getDate", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getUTCDate", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getDay", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getUTCDay", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getHours", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getUTCHours", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getMinutes", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getUTCMinutes", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getSeconds", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getUTCSeconds", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getMilliseconds", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getUTCMilliseconds", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "getTimezoneOffset", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setTime", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setMilliseconds", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setUTCMilliseconds", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setSeconds", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setUTCSeconds", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setMinutes", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setUTCMinutes", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setHours", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setUTCHours", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setDate", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setUTCDate", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setMonth", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setUTCMonth", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setFullYear", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "setUTCFullYear", numberType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "toUTCString", stringType);
        BaseJSTypeTestCase.addMethod(registry, datePrototype, "toGMTString", stringType);
        ObjectType numberPrototype = registry.getNativeFunctionType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(registry, numberPrototype, "constructor", numberObjectType);
        BaseJSTypeTestCase.addMethod(registry, numberPrototype, "toString", stringType);
        BaseJSTypeTestCase.addMethod(registry, numberPrototype, "toLocaleString", stringType);
        BaseJSTypeTestCase.addMethod(registry, numberPrototype, "valueOf", numberType);
        BaseJSTypeTestCase.addMethod(registry, numberPrototype, "toFixed", stringType);
        BaseJSTypeTestCase.addMethod(registry, numberPrototype, "toExponential", stringType);
        BaseJSTypeTestCase.addMethod(registry, numberPrototype, "toPrecision", stringType);
        ObjectType regexpPrototype = registry.getNativeFunctionType(JSTypeNative.REGEXP_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(registry, regexpPrototype, "constructor", regexpType);
        BaseJSTypeTestCase.addMethod(registry, regexpPrototype, "exec", registry.createNullableType(arrayType));
        BaseJSTypeTestCase.addMethod(registry, regexpPrototype, "test", booleanType);
        BaseJSTypeTestCase.addMethod(registry, regexpPrototype, "toString", stringType);
        regexpType.defineDeclaredProperty("source", stringType, null);
        regexpType.defineDeclaredProperty("global", booleanType, null);
        regexpType.defineDeclaredProperty("ignoreCase", booleanType, null);
        regexpType.defineDeclaredProperty("multiline", booleanType, null);
        regexpType.defineDeclaredProperty("lastIndex", numberType, null);
        ObjectType stringPrototype = registry.getNativeFunctionType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "constructor", stringObjectType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "toString", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "valueOf", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "charAt", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "charCodeAt", numberType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "concat", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "indexOf", numberType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "lastIndexOf", numberType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "localeCompare", numberType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "match", registry.createNullableType(arrayType));
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "replace", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "search", numberType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "slice", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "split", arrayType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "substring", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "toLowerCase", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "toLocaleLowerCase", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "toUpperCase", stringType);
        BaseJSTypeTestCase.addMethod(registry, stringPrototype, "toLocaleUpperCase", stringType);
        stringObjectType.defineDeclaredProperty("length", numberType, null);
    }

    private static void addMethod(JSTypeRegistry registry, ObjectType receivingType, String methodName, JSType returnType) {
        receivingType.defineDeclaredProperty(methodName, new FunctionBuilder(registry).withReturnType(returnType).build(), null);
    }

    protected JSType createUnionType(JSType ... variants) {
        return this.registry.createUnionType(variants);
    }

    protected RecordTypeBuilder createRecordTypeBuilder() {
        return new RecordTypeBuilder(this.registry);
    }

    protected JSType createNullableType(JSType type) {
        return this.registry.createNullableType(type);
    }

    protected JSType createOptionalType(JSType type) {
        return this.registry.createOptionalType(type);
    }

    protected TemplatizedType createTemplatizedType(ObjectType baseType, ImmutableList<JSType> templatizedTypes) {
        return this.registry.createTemplatizedType(baseType, templatizedTypes);
    }

    protected TemplatizedType createTemplatizedType(ObjectType baseType, JSType ... templatizedType) {
        return this.createTemplatizedType(baseType, (ImmutableList<JSType>)ImmutableList.copyOf((Object[])templatizedType));
    }

    protected void assertTypeEquals(JSType expected, Node actual) {
        this.assertTypeEquals(expected, new JSTypeExpression(actual, ""));
    }

    protected void assertTypeEquals(JSType expected, JSTypeExpression actual) {
        BaseJSTypeTestCase.assertEquals((Object)expected, (Object)this.resolve(actual, new String[0]));
    }

    protected JSType resolve(JSTypeExpression n, String ... warnings) {
        this.errorReporter.setWarnings(warnings);
        return n.evaluate(null, this.registry);
    }

    protected final void assertTypeEquals(JSType a, JSType b) {
        Asserts.assertTypeEquals(a, b);
    }

    protected final void assertTypeEquals(String msg, JSType a, JSType b) {
        Asserts.assertTypeEquals(msg, a, b);
    }

    protected final void assertTypeNotEquals(JSType a, JSType b) {
        Asserts.assertTypeNotEquals(a, b);
    }

    protected final void assertTypeNotEquals(String msg, JSType a, JSType b) {
        Asserts.assertTypeNotEquals(msg, a, b);
    }
}

