/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.testing;

import com.google.gwt.thirdparty.javascript.rhino.ErrorReporter;
import junit.framework.Assert;

public final class TestErrorReporter
extends Assert
implements ErrorReporter {
    private String[] errors;
    private String[] warnings;
    private int errorsIndex = 0;
    private int warningsIndex = 0;

    public TestErrorReporter(String[] errors, String[] warnings) {
        this.errors = errors;
        this.warnings = warnings;
    }

    public static TestErrorReporter forNoExpectedReports() {
        return new TestErrorReporter(null, null);
    }

    public void setErrors(String[] errors) {
        this.errors = errors;
        this.errorsIndex = 0;
    }

    public void setWarnings(String[] warnings) {
        this.warnings = warnings;
        this.warningsIndex = 0;
    }

    @Override
    public void error(String message, String sourceName, int line, int lineOffset) {
        if (this.errors != null && this.errorsIndex < this.errors.length) {
            TestErrorReporter.assertEquals((String)this.errors[this.errorsIndex++], (String)message);
        } else {
            TestErrorReporter.fail((String)("extra error: " + message));
        }
    }

    @Override
    public void warning(String message, String sourceName, int line, int lineOffset) {
        if (this.warnings != null && this.warningsIndex < this.warnings.length) {
            TestErrorReporter.assertEquals((String)this.warnings[this.warningsIndex++], (String)message);
        } else {
            TestErrorReporter.fail((String)("extra warning: " + message));
        }
    }

    public boolean hasEncounteredAllWarnings() {
        return this.warnings == null ? this.warningsIndex == 0 : this.warnings.length == this.warningsIndex;
    }

    public boolean hasEncounteredAllErrors() {
        return this.errors == null ? this.errorsIndex == 0 : this.errors.length == this.errorsIndex;
    }
}

