/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.dev.util.arg;

import com.google.gwt.util.tools.ArgHandlerInt;

/**
 * An ArgHandler to provide the -XfragmentCount flag.
 */
public class ArgHandlerFragmentCount extends ArgHandlerInt {

  private final OptionFragmentCount option;

  public ArgHandlerFragmentCount(OptionFragmentCount option) {
    this.option = option;
  }

  @Override
  public String getPurpose() {
    return "EXPERIMENTAL: " +
       "Limits of number of fragments using a code splitter that merges split points.";
  }

  @Override
  public String getTag() {
    return "-XfragmentCount";
  }

  @Override
  public String[] getTagArgs() {
    return new String[] {"numFragments"};
  }

  @Override
  public void setInt(int value) {
    option.setFragmentCount(value);
  }
}
