/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.RestartMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevServerOutputTracker {
    private CountDownLatch monitor = new CountDownLatch(1);
    private Finder finder;

    public DevServerOutputTracker(InputStream inputStream, Pattern success, Pattern failure, Consumer<Result> onMatch) {
        this.finder = new Finder(inputStream, success, failure, result -> {
            if (result != null) {
                onMatch.accept((Result)result);
            }
            this.monitor.countDown();
        });
    }

    public Runnable serverRestartGuard(Pattern restartingPattern, Pattern restartedPattern) {
        Objects.requireNonNull(restartingPattern, "Restarting pattern is required");
        Objects.requireNonNull(restartedPattern, "Restarted pattern is required");
        this.finder.restartMonitor = new RestartMonitor(restartingPattern, restartedPattern);
        return this.finder.restartMonitor::waitForServerReady;
    }

    static Runnable activeServerRestartGuard() {
        return Thread.getAllStackTraces().keySet().stream().filter(t -> FinderThread.class.equals(t.getClass())).findFirst().map(FinderThread.class::cast).map(t -> t.finder.restartMonitor).map(m -> m::waitForServerReady).orElse(null);
    }

    public void find() {
        FinderThread finderThread = new FinderThread(this.finder);
        finderThread.start();
    }

    public boolean awaitFirstMatch(int timeoutInSeconds) throws InterruptedException {
        return this.monitor.await(timeoutInSeconds, TimeUnit.SECONDS);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevServerOutputTracker.class);
    }

    private static class Finder
    implements Runnable {
        private InputStream inputStream;
        private StringBuilder cumulativeOutput = new StringBuilder();
        private Pattern success;
        private Pattern failure;
        private Consumer<Result> onMatch;
        private boolean started = false;
        private RestartMonitor restartMonitor;

        private Finder(InputStream inputStream, Pattern success, Pattern failure, Consumer<Result> onMatch) {
            this.inputStream = inputStream;
            this.success = success;
            this.failure = failure;
            this.onMatch = onMatch;
        }

        @Override
        public void run() {
            InputStreamReader reader = new InputStreamReader(this.inputStream, StandardCharsets.UTF_8);
            try {
                this.readLinesLoop(reader);
            }
            catch (IOException e) {
                DevServerOutputTracker.getLogger().error("Exception when reading stream.", (Throwable)e);
                this.onMatch.accept(new Result(false));
            }
            if (!this.started) {
                this.onMatch.accept(new Result(false, this.cumulativeOutput.toString()));
            } else {
                this.onMatch.accept(null);
            }
        }

        private void readLinesLoop(InputStreamReader reader) throws IOException {
            int i;
            StringBuilder line = new StringBuilder();
            while ((i = reader.read()) >= 0) {
                char ch = (char)i;
                line.append(ch);
                if (ch != '\n') continue;
                this.processLine(line.toString());
                line.setLength(0);
            }
        }

        private void processLine(String line) {
            boolean failed;
            String cleanLine;
            String logLine = cleanLine = line.replaceAll("(\u001b\\[[;\\d]*m|[\b\r]+)", "");
            logLine = logLine.replaceAll("\n$", "");
            if ((logLine = logLine.replaceAll("[0-9]+:[0-9]+:[0-9]+ [AP]M ", "")).startsWith("Recompiling because ")) {
                LoggerFactory.getLogger((String)(DevServerOutputTracker.class.getName() + ".Reloader")).debug(logLine);
            } else if (logLine.startsWith("[vite] page reload")) {
                DevServerOutputTracker.getLogger().debug(logLine);
            } else {
                DevServerOutputTracker.getLogger().info(logLine);
            }
            boolean succeed = this.success != null && this.success.matcher(line).find();
            boolean bl = failed = this.failure != null && this.failure.matcher(line).find();
            if (!failed) {
                this.cumulativeOutput.append(cleanLine);
            }
            if (succeed || failed) {
                this.onMatch.accept(new Result(succeed, this.cumulativeOutput.toString()));
                if (succeed) {
                    this.started = true;
                }
                this.cumulativeOutput = new StringBuilder();
            }
            if (this.restartMonitor != null) {
                this.restartMonitor.parseLine(cleanLine);
            }
        }
    }

    private static class FinderThread
    extends Thread {
        private final Finder finder;

        public FinderThread(Finder finder) {
            super(finder);
            this.setDaemon(true);
            this.setName("dev-server-output");
            this.finder = finder;
        }
    }

    public static class Result {
        private boolean success;
        private String output;

        private Result(boolean success) {
            this(success, "");
        }

        private Result(boolean success, String output) {
            this.success = success;
            this.output = output;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getOutput() {
            return this.output;
        }
    }
}

